/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.position;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.opplugin.web.config.HRBaseDataOp;
import kd.hrmp.hbpm.business.application.impl.position.PositionServiceApplicationImpl;
import kd.hrmp.hbpm.business.domain.service.impl.position.ChangeMsgServiceImpl;
import kd.hrmp.hbpm.business.domain.service.position.IBosPositionService;
import kd.hrmp.hbpm.opplugin.web.position.validate.BosPositionValidator;
import kd.hrmp.hbpm.opplugin.web.position.validate.PositionDisableFutureValidator;
import kd.hrmp.hbpm.opplugin.web.position.validate.PositionDisableValidator;

public class PositionDisableOp
extends HRBaseDataOp {
    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new PositionDisableValidator());
        args.addValidator((AbstractValidator)new PositionDisableFutureValidator());
        args.addValidator((AbstractValidator)new BosPositionValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] positions = args.getDataEntities();
        PositionServiceApplicationImpl positionServiceApplication = new PositionServiceApplicationImpl();
        positionServiceApplication.changePositionEnable(positions, "0");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        ChangeMsgServiceImpl changeMsgServiceImpl = new ChangeMsgServiceImpl();
        changeMsgServiceImpl.sendMsg();
        List positionIds = Arrays.stream(e.getDataEntities()).map(position -> position.getLong("boid")).collect(Collectors.toList());
        IBosPositionService.getInstance().disablePositions(positionIds);
    }
}

