/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.position;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.config.HRBaseDataOp;
import kd.hrmp.hbpm.business.application.impl.position.PositionServiceApplicationImpl;
import kd.hrmp.hbpm.business.domain.service.impl.position.ChangeMsgServiceImpl;
import kd.hrmp.hbpm.business.domain.service.position.IBosPositionService;
import kd.hrmp.hbpm.opplugin.web.position.validate.BosPositionValidator;
import kd.hrmp.hbpm.opplugin.web.position.validate.PositionEnableValidator;
import kd.hrmp.hbpm.opplugin.web.position.validate.PositionHisLoopValidator;

public class PositionEnableOp
extends HRBaseDataOp {
    public void onAddValidators(AddValidatorsEventArgs args) {
        ArrayList<ExtendedDataEntity> falseDataentity = new ArrayList<ExtendedDataEntity>(8);
        args.addValidator((AbstractValidator)new PositionEnableValidator(falseDataentity));
        args.addValidator((AbstractValidator)new PositionHisLoopValidator(falseDataentity, "id").checkCurrent(true));
        args.addValidator((AbstractValidator)new BosPositionValidator());
        args.getValidators().forEach(validator -> validator.setAddBillNoForContent(false));
    }

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("parent");
        fieldKeys.add("adminorg");
        args.getFieldKeys().clear();
        ArrayList fieldsNameList = Lists.newArrayListWithExpectedSize((int)this.billEntityType.getFields().size());
        DataEntityPropertyCollection collection = this.billEntityType.getProperties();
        collection.forEach(entityProperty -> {
            String propertyName = entityProperty.getName();
            if (!HRStringUtils.equals((String)propertyName, (String)"multilanguagetext") && !propertyName.endsWith("_id")) {
                fieldsNameList.add(propertyName);
            }
        });
        args.getFieldKeys().addAll(fieldsNameList);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] positions = args.getDataEntities();
        PositionServiceApplicationImpl positionServiceApplication = new PositionServiceApplicationImpl();
        positionServiceApplication.changePositionEnable(positions, "1");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        ChangeMsgServiceImpl changeMsgServiceImpl = new ChangeMsgServiceImpl();
        changeMsgServiceImpl.sendMsg();
        IBosPositionService.getInstance().commonSyncPositions();
    }
}

