/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.position;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hrmp.hbpm.business.application.impl.position.PositionServiceApplicationImpl;
import kd.hrmp.hbpm.business.application.position.IPositionServiceApplication;
import kd.hrmp.hbpm.business.domain.service.impl.position.ChangeMsgServiceImpl;
import kd.hrmp.hbpm.business.domain.service.position.IBosPositionService;
import kd.hrmp.hbpm.opplugin.web.position.validate.PositionFutureEffectValidator;

public class PositionFutureEffectOp
extends HRDataBaseOp {
    private IPositionServiceApplication positionServiceApplication = new PositionServiceApplicationImpl();

    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        List fieldKeys = evt.getFieldKeys();
        fieldKeys.add("datastatus");
        fieldKeys.add("boid");
        fieldKeys.add("bsed");
        fieldKeys.add("parent");
        fieldKeys.add("adminorg");
        fieldKeys.add("sourcevid");
        fieldKeys.add("changetype");
    }

    public void onAddValidators(AddValidatorsEventArgs evt) {
        evt.addValidator((AbstractValidator)new PositionFutureEffectValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs evt) {
        super.beginOperationTransaction(evt);
        DynamicObject[] futureVersions = evt.getDataEntities();
        if (evt.getOperationKey().equals("retry")) {
            this.positionServiceApplication.positionFutureEffect(futureVersions);
        } else if (evt.getOperationKey().equals("revoke")) {
            List boids = Arrays.stream(futureVersions).map(dyn -> dyn.getLong("boid")).collect(Collectors.toList());
            this.positionServiceApplication.positionFutureRevoke(boids, false);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        ChangeMsgServiceImpl changeMsgServiceImpl = new ChangeMsgServiceImpl();
        changeMsgServiceImpl.sendMsg();
        List positionIds = Arrays.stream(e.getDataEntities()).map(position -> position.getLong("boid")).collect(Collectors.toList());
        IBosPositionService.getInstance().addOrUpdatePositions(positionIds);
    }
}

