/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.position;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hrmp.hbpm.business.application.impl.position.PositionServiceApplicationImpl;
import kd.hrmp.hbpm.business.application.impl.position.PreviousPositionServiceApplication;
import kd.hrmp.hbpm.business.application.position.IPositionServiceApplication;
import kd.hrmp.hbpm.business.utils.PositionUtils;
import kd.hrmp.hbpm.opplugin.web.position.PositionCommonOp;

public abstract class PositionMServiceOp
extends PositionCommonOp {
    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        ArrayList<DynamicObject> previousPositions = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> currentPositions = new ArrayList<DynamicObject>(16);
        Object[] dataEntities = args.getDataEntities();
        if (PositionUtils.isArrayEmpty((Object[])dataEntities).booleanValue()) {
            return;
        }
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"hbpm_positionhr");
        for (Object positionInit : dataEntities) {
            DynamicObject position = this.transferPosition((DynamicObject)positionInit, mainEntityType);
            if (PositionUtils.getCurrentDate().after(HRDateTimeUtils.truncateDate((Date)position.getDate("bsed")))) {
                previousPositions.add(position);
                continue;
            }
            currentPositions.add(position);
        }
        if (!CollectionUtils.isEmpty(previousPositions)) {
            this.doSavePositions((IPositionServiceApplication)new PreviousPositionServiceApplication(), previousPositions);
        }
        if (!CollectionUtils.isEmpty(currentPositions)) {
            this.doSavePositions((IPositionServiceApplication)new PositionServiceApplicationImpl(), currentPositions);
        }
    }

    protected DynamicObject transferPosition(DynamicObject positionInit, MainEntityType mainEntityType) {
        DynamicObject position = new DynamicObject((DynamicObjectType)mainEntityType);
        HRDynamicObjectUtils.copy((DynamicObject)positionInit, (DynamicObject)position);
        Long positionId = positionInit.getLong("id");
        if (positionId == null || positionId == 0L) {
            positionId = PositionUtils.createId((String)"homs_positionbill");
        }
        position.set("id", (Object)positionId);
        return position;
    }

    protected abstract void doSavePositions(IPositionServiceApplication var1, List<DynamicObject> var2);
}

