/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.position;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidatePriority;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.opplugin.web.config.HRBaseDataOp;
import kd.hrmp.hbpm.business.application.impl.position.PositionServiceApplicationImpl;
import kd.hrmp.hbpm.business.domain.service.impl.position.ChangeMsgServiceImpl;
import kd.hrmp.hbpm.business.domain.service.position.IBosPositionService;
import kd.hrmp.hbpm.business.utils.JobLevelGradeRangeCheck;
import kd.hrmp.hbpm.business.utils.JobLevelGradeRangeImportSaveCheck;
import kd.hrmp.hbpm.business.utils.PositionUtils;
import kd.hrmp.hbpm.opplugin.web.position.validate.BosPositionValidator;
import kd.hrmp.hbpm.opplugin.web.position.validate.JobLevelGradeRangeImportValidator;
import kd.hrmp.hbpm.opplugin.web.position.validate.PositionHisLoopValidator;
import kd.hrmp.hbpm.opplugin.web.position.validate.PositionSubValidator;
import kd.hrmp.hbpm.opplugin.web.validate.PositionImptValidator;

public class PositionSaveOp
extends HRBaseDataOp {
    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        new PositionServiceApplicationImpl().setMustInputFieldDefaultValue(args.getDataEntities());
        args.addValidator((AbstractValidator)new PositionImptValidator(true, true));
        args.addValidator((AbstractValidator)new PositionHisLoopValidator(null, "id").checkMemory());
        args.addValidator((AbstractValidator)new JobLevelGradeRangeImportValidator((JobLevelGradeRangeCheck)new JobLevelGradeRangeImportSaveCheck()));
        PositionSubValidator positionSubValidator = new PositionSubValidator(this.getOption().getVariableValue("errorIds"));
        positionSubValidator.setValidatePriority(ValidatePriority.Normal);
        args.addValidator((AbstractValidator)positionSubValidator);
        args.addValidator((AbstractValidator)new BosPositionValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        super.beforeExecuteOperationTransaction(args);
        String isInitValidate = this.getOption().getVariableValue("isInitValidate", "false");
        if (StringUtils.isNotEmpty((CharSequence)isInitValidate) && "true".equals(isInitValidate)) {
            args.setCancel(true);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        ArrayList<DynamicObject> positionList = new ArrayList<DynamicObject>(16);
        for (DynamicObject positionInit : args.getDataEntities()) {
            DynamicObject position = this.transferPosition(positionInit);
            positionList.add(position);
        }
        PositionServiceApplicationImpl positionServiceApplication = new PositionServiceApplicationImpl();
        positionServiceApplication.savePosition(positionList, null);
    }

    private DynamicObject transferPosition(DynamicObject positionInit) {
        DynamicObject position = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hbpm_positionhr"));
        HRDynamicObjectUtils.copy((DynamicObject)positionInit, (DynamicObject)position);
        Long positionId = positionInit.getLong("id");
        if (positionId == 0L) {
            positionId = PositionUtils.createId((String)"homs_positionbill");
        }
        position.set("id", (Object)positionId);
        return position;
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        ChangeMsgServiceImpl changeMsgServiceImpl = new ChangeMsgServiceImpl();
        changeMsgServiceImpl.sendMsg();
        List positionIds = Arrays.stream(e.getDataEntities()).map(position -> position.getLong("boid")).collect(Collectors.toList());
        IBosPositionService.getInstance().addOrUpdatePositions(positionIds);
    }
}

