/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.position;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hrmp.hbpm.business.domain.service.impl.position.ChangeMsgServiceImpl;
import kd.hrmp.hbpm.business.domain.service.position.IBosPositionService;
import kd.hrmp.hbpm.business.service.position.PositionTplChangeSyncPosService;
import kd.hrmp.hbpm.business.utils.SystemParamHelper;
import kd.hrmp.hbpm.opplugin.web.position.validate.JobLevelGradeRangeImportValidator;
import kd.hrmp.hbpm.opplugin.web.position.validate.PositionTplCommonValidator;
import kd.hrmp.hbpm.opplugin.web.position.validate.PositionTplNameAndEnableValidator;
import kd.hrmp.hbpm.opplugin.web.position.validate.PositionTplSaveValidator;

public class PositionTplSaveOp
extends HRDataBaseOp {
    private Map<Long, DynamicObject> oldDynMap;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("levelgradetext");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new PositionTplCommonValidator());
        args.addValidator((AbstractValidator)new PositionTplNameAndEnableValidator());
        args.addValidator((AbstractValidator)new PositionTplSaveValidator());
        args.addValidator((AbstractValidator)new JobLevelGradeRangeImportValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        List oldIdList = Arrays.stream(dataEntities).filter(dynamicObject -> dynamicObject.getLong("id") != 0L).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        DynamicObject[] oldDyns = new HRBaseServiceHelper(dataEntities[0].getDynamicObjectType().getName()).loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", oldIdList)});
        this.oldDynMap = Arrays.stream(oldDyns).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
        String importType = (String)this.getOption().getVariables().get("importtype");
        if (!HRStringUtils.isEmpty((String)importType) && "new".equals(importType)) {
            for (DynamicObject dataEntity : dataEntities) {
                this.setFieldRange(dataEntity, dataEntity.getLong("org.id"));
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        PositionTplChangeSyncPosService syncUpdatePosService = new PositionTplChangeSyncPosService(this.oldDynMap);
        syncUpdatePosService.syncUpdatePosition(e.getDataEntities());
    }

    private void setFieldRange(DynamicObject positionDy, Long buId) {
        Map batchParameter = SystemParamHelper.getBatchParameter(Collections.singletonList(buId));
        if (batchParameter == null || batchParameter.size() == 0) {
            return;
        }
        Map parameter = batchParameter.getOrDefault(String.valueOf(buId), Maps.newHashMap());
        if (parameter.isEmpty()) {
            return;
        }
        boolean openpositiontpl = parameter.getOrDefault("openpositiontpl", false);
        if (!openpositiontpl) {
            return;
        }
        boolean positiontplismodify = parameter.getOrDefault("positiontplismodify", false);
        if (!positiontplismodify) {
            DynamicObjectCollection fieldrange = positionDy.getDynamicObjectCollection("fieldrange");
            fieldrange.removeAll((Collection)fieldrange);
            positionDy.set("ablemodifyfield", (Object)positiontplismodify);
            return;
        }
        positionDy.set("ablemodifyfield", (Object)positiontplismodify);
        String modifyfieldrange = parameter.getOrDefault("modifyfieldrange", "");
        if (modifyfieldrange.equals("")) {
            return;
        }
        List fieldRangeDataList = (List)JSONObject.parseObject((String)modifyfieldrange, List.class);
        List<Object> fieldRangeId = fieldRangeDataList.stream().map(temp -> temp.getOrDefault((Object)"modifyfieldrange", (Object)0L)).collect(Collectors.toList());
        DynamicObjectCollection fieldrange = positionDy.getDynamicObjectCollection("fieldrange");
        fieldrange.removeAll((Collection)fieldrange);
        DynamicObjectType dynamicObjectType = fieldrange.getDynamicObjectType();
        fieldRangeId.forEach(temp -> {
            DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
            dynamicObject.set("fbasedataid", temp);
            fieldrange.add((Object)dynamicObject);
        });
        positionDy.set("fieldrange", (Object)fieldrange);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        ChangeMsgServiceImpl changeMsgServiceImpl = new ChangeMsgServiceImpl();
        changeMsgServiceImpl.sendMsg();
        IBosPositionService.getInstance().commonSyncPositions();
    }
}

