/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.position.validate;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.ext.BosPositionValidateReq;
import kd.hr.hbp.common.ext.BosPositionValidateResult;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.domain.service.position.IBosPositionService;

public class BosPositionValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(BosPositionValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities.length == 0) {
            LOGGER.info("dataEntities is empty");
            return;
        }
        if (IBosPositionService.getInstance().isDisableSyncPlatformPosition()) {
            return;
        }
        DynamicObject[] positions = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList()).toArray(new DynamicObject[0]);
        List curPositionIds = Arrays.stream(positions).map(position -> position.getLong("boid")).filter(boId -> boId != 0L).collect(Collectors.toList());
        HashMap updateHisCurPositionMap = new HashMap(curPositionIds.size());
        if (!CollectionUtils.isEmpty(curPositionIds)) {
            HashMap<Long, DynamicObject> curPositionMap = new HashMap<Long, DynamicObject>(curPositionIds.size());
            DynamicObject[] curPositions = PositionQueryRepository.getInstance().queryCurEffectingPosition(curPositionIds, String.join((CharSequence)",", "adminorg.id", "boid", "bsed"));
            if (curPositions.length > 0) {
                curPositionMap.putAll(Arrays.stream(curPositions).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (v1, v2) -> v1)));
                Arrays.stream(positions).forEach(position -> {
                    long positionId = position.getLong("boid");
                    DynamicObject curPosition = (DynamicObject)curPositionMap.get(positionId);
                    if (!HRObjectUtils.isEmpty((Object)curPosition) && HRDateTimeUtils.dayBefore((Date)position.getDate("bsed"), (Date)curPosition.getDate("bsed"))) {
                        updateHisCurPositionMap.put(positionId, curPosition);
                    }
                });
            }
        }
        List reqs = Arrays.stream(positions).map(position -> {
            BosPositionValidateReq req = new BosPositionValidateReq();
            long positionId = position.getLong("boid");
            req.setPositionId(positionId);
            ILocaleString positionName = position.getLocaleString("name");
            String positionNumber = position.getString("number");
            long positionOrgId = position.getLong("adminorg.id");
            req.setPosition(position);
            if (updateHisCurPositionMap.containsKey(positionId)) {
                DynamicObject curPosition = (DynamicObject)updateHisCurPositionMap.get(positionId);
                positionName = curPosition.getLocaleString("name");
                positionNumber = curPosition.getString("number");
                positionOrgId = curPosition.getLong("adminorg.id");
                req.setPosition(curPosition);
            }
            req.setPositionOrgId(positionOrgId);
            req.setPositionNumber(positionNumber);
            req.setPositionName(positionName);
            return req;
        }).collect(Collectors.toList());
        List results = IBosPositionService.getInstance().bosPositionValidate(reqs);
        if (results.size() == 0) {
            LOGGER.error("results is empty");
            return;
        }
        for (int i = 0; i < dataEntities.length; ++i) {
            BosPositionValidateResult result = (BosPositionValidateResult)results.get(i);
            ExtendedDataEntity dataEntity = dataEntities[i];
            if (!result.getResult()) {
                this.addFatalErrorMessage(dataEntity, result.getMessage());
                continue;
            }
            DynamicObject position2 = dataEntity.getDataEntity();
            long positionId = position2.getLong("boid");
            long bosPositionId = result.getBosPositionId();
            if (positionId != 0L || bosPositionId == 0L) continue;
            position2.set("id", (Object)bosPositionId);
        }
    }
}

