/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.position.validate;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.hbpm.business.domain.repository.position.MserviceQueryRepository;
import kd.hrmp.hbpm.business.utils.JobLevelGradeRangeCheck;
import kd.hrmp.hbpm.business.utils.PositionJobRelationCheckUtil;
import kd.hrmp.hbpm.business.utils.PositionPermissionUtil;
import kd.hrmp.hbpm.business.utils.PositionUtils;
import kd.hrmp.hbpm.common.constants.JobLevelGradeRangeEnum;
import kd.hrmp.hbpm.common.constants.JobLevelGradeTextEnum;

public class JobLevelGradeRangeImportValidator
extends HRDataBaseValidator {
    private List<ExtendedDataEntity> falseDataentity = new ArrayList<ExtendedDataEntity>();
    private static final Log LOGGER = LogFactory.getLog(JobLevelGradeRangeImportValidator.class);
    private JobLevelGradeRangeCheck check = new JobLevelGradeRangeCheck();
    private BooleanSupplier isCheckEnable = () -> this.getOption().containsVariable("importtype");
    private boolean isRevise;

    public JobLevelGradeRangeImportValidator() {
    }

    public JobLevelGradeRangeImportValidator(JobLevelGradeRangeCheck check) {
        this.check = check;
    }

    public JobLevelGradeRangeImportValidator(JobLevelGradeRangeCheck check, List<ExtendedDataEntity> falseDataentity) {
        this.check = check;
        this.falseDataentity = falseDataentity;
    }

    public JobLevelGradeRangeImportValidator(boolean isRevise) {
        this.isRevise = isRevise;
    }

    public void validate() {
        Object[] data = this.getDataEntities();
        if (PositionUtils.isArrayEmpty((Object[])data).booleanValue() || !this.isImport(data[0].getDataEntity()).booleanValue()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.checkJobRelatedInformation((ExtendedDataEntity[])data);
        this.checkDataEnable((ExtendedDataEntity[])data);
        LOGGER.info(String.format("JobLevelGradeRangeImportValidator validate all time : %s", System.currentTimeMillis() - startTime));
    }

    private void checkDataEnable(ExtendedDataEntity[] data) {
        if (this.isCheckEnable.getAsBoolean() && !this.isRevise) {
            for (ExtendedDataEntity entity : data) {
                if (entity.getDataEntity().getBoolean("enable")) continue;
                this.addFatalErrorMessage(entity, ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u662f\u201c\u542f\u7528\u201d\u72b6\u6001\u3002", (String)"JobLevelGradeRangeImportValidator_0", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void checkJobRelatedInformation(ExtendedDataEntity[] data) {
        LinkedList<Long> scmLists = new LinkedList<Long>();
        LinkedList<Long> jobFamilyLists = new LinkedList<Long>();
        LinkedList<Long> jobLists = new LinkedList<Long>();
        long startTime = System.currentTimeMillis();
        HasPermOrgResult posHasPermOrg = PositionPermissionUtil.getPosHasPermOrg();
        Map<Long, Map<String, List<Long>>> scmBu = this.getScmBu(data);
        LOGGER.info(String.format("JobLevelGradeRangeImportValidator getScmBu time : %s", System.currentTimeMillis() - startTime));
        for (ExtendedDataEntity dataEntity : data) {
            DynamicObject dy = dataEntity.getDataEntity();
            this.showErrorMessage(dataEntity, this.check.checkJobSystemRelatedInfo(dy, posHasPermOrg, scmBu));
            if (this.isAlreadyCheckedError(dy)) continue;
            DynamicObject scm = dy.getDynamicObject("jobscm");
            DynamicObject job = dy.getDynamicObject("job");
            if (!Objects.nonNull(scm)) continue;
            scmLists.add(scm.getLong("id"));
            if (!Objects.nonNull(job)) continue;
            jobFamilyLists.add(job.getLong("jobfamily.id"));
            jobLists.add(job.getLong("id"));
        }
        this.populateRange(data, scmLists, jobFamilyLists, jobLists);
    }

    private Map<Long, Map<String, List<Long>>> getScmBu(ExtendedDataEntity[] data) {
        HashMap bu = Maps.newHashMap();
        for (ExtendedDataEntity entity : data) {
            List<Long> list;
            DynamicObject dy = entity.getDataEntity();
            this.check.insertOldLevelGradeScm(dy, JobLevelGradeTextEnum.LEVEL);
            this.check.insertOldLevelGradeScm(dy, JobLevelGradeTextEnum.GRADE);
            Long buId = dy.getLong("orgdesignbu.id");
            Long jobScmId = dy.getLong("jobscm.id");
            Long levelScmId = dy.getLong("joblevelscm.id");
            Long gradeScmId = dy.getLong("jobgradescm.id");
            if (buId == 0L || jobScmId == 0L && levelScmId == 0L && gradeScmId == 0L) continue;
            Map map = (Map)bu.get(buId);
            if (Objects.isNull(map)) {
                map = Maps.newHashMap();
                bu.put(buId, map);
            }
            if (jobScmId != 0L) {
                list = (LinkedList<Long>)map.get("hbjm_jobscmhr");
                if (Objects.isNull(list)) {
                    list = new LinkedList<Long>();
                    map.put("hbjm_jobscmhr", list);
                }
                list.add(jobScmId);
            }
            if (levelScmId != 0L) {
                list = (List)map.get("hbjm_joblevelscmhr");
                if (Objects.isNull(list)) {
                    list = new LinkedList();
                    map.put("hbjm_joblevelscmhr", list);
                }
                list.add(levelScmId);
            }
            if (gradeScmId == 0L) continue;
            list = (List)map.get("hbjm_jobgradescmhr");
            if (Objects.isNull(list)) {
                list = new LinkedList();
                map.put("hbjm_jobgradescmhr", list);
            }
            list.add(gradeScmId);
        }
        if (CollectionUtils.isEmpty((Map)bu)) {
            return null;
        }
        return MserviceQueryRepository.getInstance().queryPermission((Map)bu);
    }

    private Boolean isImport(DynamicObject dy) {
        if (HRStringUtils.equals((String)dy.getString("initdatasource"), (String)"1") || this.getOption().containsVariable("importtype")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void populateRange(ExtendedDataEntity[] data, List<Long> scmLists, List<Long> jobFamilyLists, List<Long> jobs) {
        long startTime = System.currentTimeMillis();
        Map collects = MserviceQueryRepository.getInstance().getJobLevelGrade(scmLists, jobFamilyLists);
        Map jobLevelGradeRange = MserviceQueryRepository.getInstance().getJobLevelGradeRangeByJobIds(jobs);
        Map jobLevelGradeRangeInfo = MserviceQueryRepository.getInstance().getJobLevelGradeRangeInfo(jobs);
        LOGGER.info(String.format("JobLevelGradeRangeImportValidator getJobLevel time : %s", System.currentTimeMillis() - startTime));
        for (ExtendedDataEntity entity : data) {
            DynamicObject dy = entity.getDataEntity();
            if (this.isAlreadyCheckedError(dy)) continue;
            DynamicObject scmDy = PositionJobRelationCheckUtil.getInstance().getJobScmByCollects(dy, collects);
            DynamicObject jobByQuery = (DynamicObject)jobLevelGradeRange.get(dy.getLong("job.id"));
            Map levelGradeRangeInfo = PositionJobRelationCheckUtil.getInstance().getLevelGradeRangeByJobId(jobLevelGradeRangeInfo, dy.getString("job.id"));
            this.populateLevelGradeRange(entity, scmDy, dy, levelGradeRangeInfo, JobLevelGradeRangeEnum.LEVEL);
            this.populateLevelGradeRange(entity, scmDy, dy, levelGradeRangeInfo, JobLevelGradeRangeEnum.GRADE);
            if (this.isAlreadyCheckedError(dy)) continue;
            this.showErrorMessage(entity, this.check.checkRangeWithInJobRange(dy, scmDy, jobByQuery, JobLevelGradeRangeEnum.LEVEL));
            this.showErrorMessage(entity, this.check.checkRangeWithInJobRange(dy, scmDy, jobByQuery, JobLevelGradeRangeEnum.GRADE));
        }
    }

    private boolean isAlreadyCheckedError(DynamicObject dy) {
        return this.getValidateResult().getAllErrorInfo().stream().anyMatch(info -> info.getPkValue().equals(dy.getLong("id")));
    }

    private void populateLevelGradeRange(ExtendedDataEntity en, DynamicObject scmDy, DynamicObject entity, Map<String, List<DynamicObject>> levelGradeRangeInfo, JobLevelGradeRangeEnum rangeEnum) {
        String lowName = entity.getString(rangeEnum.getLowSign() + "text");
        String highName = entity.getString(rangeEnum.getHighSign() + "text");
        if (HRStringUtils.isEmpty((String)lowName) || HRStringUtils.isEmpty((String)highName)) {
            return;
        }
        HashMap lowAndHighLevelGrade = Maps.newHashMapWithExpectedSize((int)4);
        boolean formJobRange = false;
        if (Objects.nonNull(levelGradeRangeInfo) && !CollectionUtils.isEmpty((Collection)levelGradeRangeInfo.get(rangeEnum.getSign()))) {
            List<DynamicObject> dynamicObjects = levelGradeRangeInfo.get(rangeEnum.getSign());
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (HRStringUtils.equals((String)lowName, (String)dynamicObject.getString(rangeEnum.getName()))) {
                    lowAndHighLevelGrade.put(rangeEnum.getLowSign(), dynamicObject);
                }
                if (!HRStringUtils.equals((String)highName, (String)dynamicObject.getString(rangeEnum.getName()))) continue;
                lowAndHighLevelGrade.put(rangeEnum.getHighSign(), dynamicObject);
            }
            formJobRange = true;
        }
        if (formJobRange) {
            String message = this.check.checkJobRangeValid(rangeEnum, (DynamicObject)lowAndHighLevelGrade.get(rangeEnum.getLowSign()), (DynamicObject)lowAndHighLevelGrade.get(rangeEnum.getHighSign()));
            if (!HRStringUtils.isEmpty((String)message)) {
                this.showErrorMessage(en, message);
                return;
            }
        } else {
            DynamicObject levelScm = entity.getDynamicObject(rangeEnum.getScmSign());
            if (Objects.isNull(levelScm) && (Objects.isNull(scmDy) || Objects.isNull(levelScm = scmDy.getDynamicObject(rangeEnum.getScmSign())))) {
                this.showErrorMessage(en, this.check.checkLevelGradeScmValid(levelScm, lowName, highName, rangeEnum));
                return;
            }
            DynamicObjectCollection dynamicObjectCollection = levelScm.getDynamicObjectCollection("entryentity");
            if (Objects.nonNull(dynamicObjectCollection)) {
                for (DynamicObject dy : dynamicObjectCollection) {
                    if (HRStringUtils.equals((String)lowName, (String)dy.getString(rangeEnum.getNameSign()))) {
                        lowAndHighLevelGrade.put(rangeEnum.getLowSign(), dy);
                    }
                    if (!HRStringUtils.equals((String)highName, (String)dy.getString(rangeEnum.getNameSign()))) continue;
                    lowAndHighLevelGrade.put(rangeEnum.getHighSign(), dy);
                }
            }
        }
        entity.set(rangeEnum.getLowSign(), lowAndHighLevelGrade.get(rangeEnum.getLowSign()));
        entity.set(rangeEnum.getHighSign(), lowAndHighLevelGrade.get(rangeEnum.getHighSign()));
        this.showErrorMessage(en, this.check.checkJobLevelGradeRangeValid(entity, rangeEnum));
    }

    private void showErrorMessage(ExtendedDataEntity dataEntity, Object content) {
        if (Objects.isNull(content)) {
            return;
        }
        if (content instanceof String) {
            this.addFatalErrorMessage(dataEntity, (String)content);
        } else if (content instanceof List) {
            List result = (List)content;
            if (CollectionUtils.isEmpty((Collection)result)) {
                return;
            }
            result.forEach(value -> this.addFatalErrorMessage(dataEntity, (String)value));
        }
    }
}

