/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.position.validate;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.lang.Lang;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbpm.business.utils.GroupKey;
import kd.hrmp.hbpm.business.utils.HbpmGroupKeyBuilder;

public class MultilangUniqueValidator
extends AbstractValidator {
    private DataEntityPropertyCollection props;
    private String entityNumber;
    private Map<GroupKey, List<ExtendedDataEntity>> allBuildKeysMap;
    private Set<GroupKey> dbGroupKeys;
    private String[] mulCols = new String[]{"name"};
    private List<String> mulColsList = Collections.singletonList("name");
    private Lang[] supportMulTypes = new Lang[]{Lang.zh_CN, Lang.en_US, Lang.zh_TW};
    Map<String, String> entityNameVsEsg = Maps.newHashMapWithExpectedSize((int)16);

    public MultilangUniqueValidator() {
        this.entityNameVsEsg.put("hbpm_positiontpltype", ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u540d\u79f0\u201d\u3002", (String)"MultilangUniqueValidator_2", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]));
        this.entityNameVsEsg.put("hbpm_positiontpl", ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u540d\u79f0\u201d\u3002", (String)"MultilangUniqueValidator_2", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]));
    }

    private String getErrorInfo() {
        String op = this.getOption().getVariableValue("op", "");
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String name = dataEntities[0].getDataEntity().getDataEntityType().getName();
        if (this.entityNameVsEsg.containsKey(name) && HRStringUtils.equals((String)op, (String)"enable")) {
            return ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u53ef\u7528\u6570\u636e\u3002", (String)"MultilangUniqueValidator_0", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
        }
        this.getOption().setVariableValue("nameError", "true");
        return this.entityNameVsEsg.getOrDefault(name, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u53ef\u7528\u6570\u636e\u3002", (String)"MultilangUniqueValidator_0", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]));
    }

    public void validate() {
        if (this.mulCols == null || this.mulCols.length <= 0) {
            return;
        }
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length <= 0) {
            return;
        }
        DynamicObject dy = dataEntities[0].getDataEntity();
        this.props = dy.getDataEntityType().getProperties();
        this.entityNumber = dy.getDataEntityType().getName();
        this.getEnabledLang();
        this.buildKeys();
        this.checkInDB();
        this.checkInMemory();
    }

    private void getEnabledLang() {
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        List enabledLangList = service.getEnabledLang();
        if (enabledLangList != null && enabledLangList.size() > 0) {
            Lang[] enabledLang = new Lang[enabledLangList.size()];
            for (int ii = 0; ii < enabledLangList.size(); ++ii) {
                enabledLang[ii] = Lang.from((String)((EnabledLang)enabledLangList.get((int)ii)).number);
            }
            this.supportMulTypes = enabledLang;
        }
    }

    private void buildKeys() {
        Map groupkeys;
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HbpmGroupKeyBuilder build = HbpmGroupKeyBuilder.newInstance((ExtendedDataEntity[])dataEntities, this.mulColsList);
        this.allBuildKeysMap = groupkeys = build.buildKeys();
    }

    protected void checkInDB() {
        if (this.allBuildKeysMap == null || this.allBuildKeysMap.size() <= 0) {
            return;
        }
        if (!this.hasMulCol(this.mulCols)) {
            return;
        }
        Map<String, Object> allDataMap = this.buildEmptyMap();
        this.dealAllEntityData(allDataMap);
        Map<String, QFilter> filterMap = this.buildFilters(allDataMap);
        List<DynamicObject> searchResult = this.getAllMulDataByFilter(filterMap);
        HashMap errorInfoMap = new HashMap(searchResult.size());
        if (searchResult != null && searchResult.size() > 0) {
            this.dbGroupKeys = new HashSet<GroupKey>(searchResult.size());
            for (DynamicObject data : searchResult) {
                GroupKey groupKey = HbpmGroupKeyBuilder.buildKey((int)0, (DynamicObject)data, this.mulColsList, (DataEntityPropertyCollection)this.props);
                List<ExtendedDataEntity> entryValue = this.allBuildKeysMap.get(groupKey);
                if (entryValue != null && entryValue.size() > 0) {
                    entryValue.forEach(entry -> {
                        if (entry.getDataEntity().getDataEntityType().getProperties().containsKey((Object)"boid") && (entry.getDataEntity().getLong("boid") != 0L || this.getOption().containsVariable("importtype") && "override".equals(this.getOption().getVariableValue("importtype")))) {
                            String er;
                            Long entityBoId = entry.getDataEntity().getLong("boid");
                            if (entityBoId.longValue() != data.getLong("boid") && HRStringUtils.isEmpty((String)(er = (String)errorInfoMap.get(entityBoId)))) {
                                errorInfoMap.put(entityBoId, this.getErrorInfo());
                            }
                        } else {
                            String er;
                            Long entityFId = entry.getDataEntity().getLong("id");
                            if (entityFId.longValue() != data.getLong("id") && HRStringUtils.isEmpty((String)(er = (String)errorInfoMap.get(entityFId)))) {
                                errorInfoMap.put(entityFId, this.getErrorInfo());
                            }
                        }
                    });
                }
                this.dbGroupKeys.add(groupKey);
            }
            if (errorInfoMap.size() > 0) {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity entity : dataEntities = this.getDataEntities()) {
                    String errorInfo;
                    DynamicObject entityData = entity.getDataEntity();
                    Long entityId = entityData.getLong("id");
                    if (entity.getDataEntity().getDataEntityType().getProperties().containsKey((Object)"boid") && (entityData.getLong("boid") != 0L || this.getOption().containsVariable("importtype") && "override".equals(this.getOption().getVariableValue("importtype")))) {
                        errorInfo = (String)errorInfoMap.get(entityData.getLong("boid"));
                        if (!HRStringUtils.isNotEmpty((String)errorInfo)) continue;
                        this.addErrorMessage(entity, errorInfo);
                        continue;
                    }
                    errorInfo = (String)errorInfoMap.get(entityId);
                    if (!HRStringUtils.isNotEmpty((String)errorInfo)) continue;
                    this.addErrorMessage(entity, errorInfo);
                }
            }
        }
    }

    protected void checkInMemory() {
        if (this.allBuildKeysMap == null || this.allBuildKeysMap.size() <= 0) {
            return;
        }
        for (Map.Entry<GroupKey, List<ExtendedDataEntity>> entry : this.allBuildKeysMap.entrySet()) {
            List<ExtendedDataEntity> entryValue = entry.getValue();
            if (entryValue == null || entryValue.size() <= 1 || this.dbGroupKeys != null && this.dbGroupKeys.contains(entry.getKey())) continue;
            for (int index = 1; index < entryValue.size(); ++index) {
                this.addErrorMessage(entryValue.get(index), this.getErrorInfo());
            }
        }
    }

    private List<DynamicObject> getAllMulDataByFilter(Map<String, QFilter> filterMap) {
        ArrayList<DynamicObject> searchResult = new ArrayList<DynamicObject>(8);
        for (Lang lang : this.supportMulTypes) {
            DynamicObjectCollection ormResult;
            QFilter filter = filterMap.get(lang.toString());
            if (filter == null || (ormResult = this.getDataFromDb(lang, filter)) == null || ormResult.size() <= 0) continue;
            searchResult.addAll((Collection<DynamicObject>)ormResult);
        }
        return searchResult;
    }

    private DynamicObjectCollection getDataFromDb(Lang lang, QFilter filter) {
        ORM orm = ORM.create();
        orm.hint().setLang(lang);
        String baseQueryFiled = "id,number,";
        if (this.props.containsKey((Object)"boid")) {
            baseQueryFiled = baseQueryFiled + "boid,";
        }
        DynamicObjectCollection ormResult = orm.query(this.getEntityNumber(), baseQueryFiled + StringUtils.join((Object[])this.mulCols, (String)","), new QFilter[]{filter});
        return ormResult;
    }

    private Map<String, QFilter> buildFilters(Map<String, Object> allDataMap) {
        HashMap<String, QFilter> filterMap = new HashMap<String, QFilter>(8);
        for (Map.Entry<String, Object> entry : allDataMap.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof Map)) continue;
            if (value instanceof Map) {
                Lang[] mulMap = (Lang[])value;
                Lang[] langArray = this.supportMulTypes;
                int n = langArray.length;
                for (int i = 0; i < n; ++i) {
                    Lang lang = langArray[i];
                    StringBuilder strBuilder = new StringBuilder();
                    strBuilder.append(entry.getKey()).append(".").append(lang.toString());
                    List filterData = (List)mulMap.get(strBuilder.toString());
                    if (filterData == null || filterData.size() <= 0) continue;
                    QFilter filter = (QFilter)filterMap.get(lang.toString());
                    if (filter == null) {
                        filter = new QFilter("1", "=", (Object)1);
                    }
                    filter.and(entry.getKey(), "in", (Object)filterData);
                    filterMap.put(lang.toString(), filter);
                }
                continue;
            }
            for (Lang lang : this.supportMulTypes) {
                QFilter filter = (QFilter)filterMap.get(lang.toString());
                if (filter == null) {
                    filter = new QFilter("1", "=", (Object)1);
                }
                filter.and(entry.getKey(), "in", value);
                filterMap.put(lang.toString(), filter);
            }
        }
        for (Lang lang : this.supportMulTypes) {
            QFilter filter = (QFilter)filterMap.get(lang.toString());
            if (filter == null) continue;
            filter.and(this.getCommonFilter());
        }
        return filterMap;
    }

    protected QFilter getCommonFilter() {
        return null;
    }

    protected String getEntityNumber() {
        return this.entityNumber;
    }

    private void dealAllEntityData(Map<String, Object> allDataMap) {
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject data = entity.getDataEntity();
            for (String col : this.mulCols) {
                Object[] values;
                IDataEntityProperty prop = (IDataEntityProperty)this.props.get((Object)col);
                if (prop == null || prop.isDbIgnore() || (values = HbpmGroupKeyBuilder.formatValue((IDataEntityProperty)prop, (Object)data.get(col), (DynamicObject)data)) == null || values.length <= 0) continue;
                Object propValue = values[0];
                if (propValue instanceof OrmLocaleValue) {
                    OrmLocaleValue info = (OrmLocaleValue)propValue;
                    Map mulMap = (Map)allDataMap.get(col);
                    for (Lang lang : this.supportMulTypes) {
                        StringBuilder strBuilder = new StringBuilder();
                        strBuilder.append(col).append(".").append(lang.toString());
                        List list = (List)mulMap.get(strBuilder.toString());
                        if (!StringUtils.isNotEmpty((CharSequence)info.get((Object)lang.toString()))) continue;
                        list.add(info.get((Object)lang.toString()));
                    }
                    continue;
                }
                List list = (List)allDataMap.get(col);
                list.add(propValue);
            }
        }
    }

    private Map<String, Object> buildEmptyMap() {
        HashMap<String, Object> allDataMap = new HashMap<String, Object>(8);
        for (String col : this.mulCols) {
            IDataEntityProperty prop = (IDataEntityProperty)this.props.get((Object)col);
            if (prop == null || prop.isDbIgnore()) continue;
            if (prop instanceof MuliLangTextProp) {
                HashMap mulMap = new HashMap(8);
                for (Lang lang : this.supportMulTypes) {
                    StringBuilder strBuilder = new StringBuilder();
                    strBuilder.append(col).append(".").append(lang.toString());
                    mulMap.put(strBuilder.toString(), new ArrayList());
                }
                allDataMap.put(col, mulMap);
                continue;
            }
            allDataMap.put(col, new ArrayList());
        }
        return allDataMap;
    }

    private boolean hasMulCol(String[] mulCols) {
        boolean hasMul = false;
        for (String col : mulCols) {
            IDataEntityProperty prop = (IDataEntityProperty)this.props.get((Object)col);
            if (!(prop instanceof MuliLangTextProp)) continue;
            hasMul = true;
            break;
        }
        return hasMul;
    }
}

