/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.position.validate;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import org.apache.commons.collections.CollectionUtils;

public class PositionDisableFutureValidator
extends HRDataBaseValidator {
    private String operationKey;

    public PositionDisableFutureValidator() {
    }

    public PositionDisableFutureValidator(String operationKey) {
        this.operationKey = operationKey;
    }

    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        List<Long> enablePositonId = HRStringUtils.equals((String)"dochange", (String)this.operationKey) ? this.getEnablePositionIds() : Arrays.stream(datas).filter(dyn -> HRStringUtils.equals((String)"1", (String)dyn.getDataEntity().getString("enable"))).map(dyn -> dyn.getDataEntity().getLong("id")).collect(Collectors.toList());
        DynamicObject[] subPositionDyns = PositionQueryRepository.getInstance().querySubPositions(enablePositonId);
        this.checkExistFutureVersion(datas, subPositionDyns, enablePositonId);
    }

    private void checkExistFutureVersion(ExtendedDataEntity[] datas, DynamicObject[] subPositionDyns, List<Long> ids) {
        List allSubIds = Arrays.stream(subPositionDyns).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        ArrayList<Long> positionIdList = new ArrayList<Long>(ids);
        positionIdList.addAll(allSubIds);
        DynamicObject[] futureVersions = PositionQueryRepository.getInstance().queryPositionFutureVersion(positionIdList);
        if (futureVersions.length == 0) {
            return;
        }
        List hasFutureVersionList = Arrays.stream(futureVersions).map(dyn -> dyn.getLong("boid")).collect(Collectors.toList());
        Map<Long, List<Long>> idSubPosMap = this.groupSubPositionMap(subPositionDyns);
        for (ExtendedDataEntity data : datas) {
            List<Long> subIds;
            Long id = data.getDataEntity().getLong("id");
            if (!ids.contains(id)) continue;
            if (hasFutureVersionList.contains(id)) {
                this.addFatalErrorMessage(data, ResManager.loadKDString((String)"\u5c97\u4f4d\u6709\u5f85\u751f\u6548\u7248\u672c\uff0c\u4e0d\u5141\u8bb8\u7981\u7528\u3002", (String)"PositionDisableFutureValidator_1", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]));
            }
            if (CollectionUtils.isEmpty(subIds = idSubPosMap.get(id))) {
                return;
            }
            subIds.retainAll(hasFutureVersionList);
            if (subIds.size() <= 0) continue;
            this.addFatalErrorMessage(data, ResManager.loadKDString((String)"\u4e0b\u7ea7\u5c97\u4f4d\u6709\u5f85\u751f\u6548\u7248\u672c\uff0c\u4e0d\u5141\u8bb8\u7981\u7528\u3002", (String)"PositionDisableFutureValidator_2", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]));
        }
    }

    private Map<Long, List<Long>> groupSubPositionMap(DynamicObject[] subPositions) {
        HashMap subPositionMap = Maps.newHashMap();
        for (DynamicObject subPosition : subPositions) {
            Long parentId = subPosition.getLong("parent.id");
            List subIdList = subPositionMap.computeIfAbsent(parentId, v -> Lists.newArrayList());
            subIdList.add(subPosition.getLong("id"));
        }
        return subPositionMap;
    }

    private List<Long> getEnablePositionIds() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ArrayList positionIds = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            if (!"0".equals(dataEntity.getDataEntity().getString("enable"))) continue;
            positionIds.add(dataEntity.getDataEntity().getLong("boid"));
        }
        return positionIds;
    }
}

