/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.position.validate;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.utils.PositionUtils;

public class PositionDisableSubValidator
extends HRDataBaseValidator {
    private String operationKey;

    public PositionDisableSubValidator(String operationKey) {
        this.operationKey = operationKey;
    }

    public void validate() {
        Object[] dataEntities = this.getDataEntities();
        if (PositionUtils.isArrayEmpty((Object[])dataEntities).booleanValue()) {
            return;
        }
        List<Long> enablePositionIds = this.getEnablePositionIds();
        List<Long> containsSubPositionIds = this.getContainsSubPositionIds(enablePositionIds);
        for (Object data : dataEntities) {
            if (!containsSubPositionIds.contains(data.getDataEntity().getLong("boid"))) continue;
            this.addFatalErrorMessage((ExtendedDataEntity)data, ResManager.loadKDString((String)"\u7981\u7528\u5931\u8d25\uff0c\u5c97\u4f4d\u6709\u5df2\u542f\u7528\u7684\u4e0b\u7ea7\u5c97\u4f4d\u3002", (String)"PositionDisableValidator_2", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]));
        }
    }

    private List<Long> getContainsSubPositionIds(List<Long> enablePositionIds) {
        ArrayList<Long> containsSubPositionIds = new ArrayList<Long>();
        if (CollectionUtils.isEmpty(enablePositionIds)) {
            return containsSubPositionIds;
        }
        ArrayList<Long> successPosId = new ArrayList<Long>();
        DynamicObject[] subPositions = PositionQueryRepository.getInstance().querySubPositions(enablePositionIds);
        DynamicObject[] subPositionExcludeFuture = (DynamicObject[])Arrays.stream(subPositions).filter(dyn -> !HRStringUtils.equals((String)"0", (String)dyn.getString("datastatus"))).toArray(DynamicObject[]::new);
        Map<Long, List<Long>> subPositionMap = this.groupSubPositionMap(subPositionExcludeFuture);
        HashMap waitIdMap = Maps.newHashMap();
        for (Long id : enablePositionIds) {
            List<Long> subIds = subPositionMap.get(id);
            if (subIds == null) {
                successPosId.add(id);
                continue;
            }
            if (enablePositionIds.containsAll(subIds)) {
                this.filterWaitEnablePos(id, subIds, successPosId, containsSubPositionIds, waitIdMap);
                continue;
            }
            containsSubPositionIds.add(id);
        }
        if (!ObjectUtils.isEmpty((Object)waitIdMap)) {
            for (int count = 0; count < 10 && !ObjectUtils.isEmpty((Object)waitIdMap); ++count) {
                HashMap copyIdMap = new HashMap();
                waitIdMap.forEach((key, value) -> copyIdMap.put(key, value));
                for (Map.Entry next : copyIdMap.entrySet()) {
                    Long id = (Long)next.getKey();
                    if (successPosId.contains(id) || containsSubPositionIds.contains(id)) continue;
                    List subWorkRoleIds = (List)next.getValue();
                    waitIdMap.remove(id);
                    this.filterWaitEnablePos(id, subWorkRoleIds, successPosId, containsSubPositionIds, waitIdMap);
                }
            }
        }
        return containsSubPositionIds;
    }

    private void filterWaitEnablePos(Long id, List<Long> subIds, List<Long> successPosId, List<Long> failPosId, Map<Long, List<Long>> waitIdMap) {
        List failLowPositions = subIds.stream().filter(subId -> failPosId.contains(subId)).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(failLowPositions)) {
            failPosId.add(id);
        } else {
            List waitLowPositions = subIds.stream().filter(subId -> !successPosId.contains(subId)).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(waitLowPositions)) {
                waitIdMap.put(id, waitLowPositions);
            } else {
                successPosId.add(id);
            }
        }
    }

    private Map<Long, List<Long>> groupSubPositionMap(DynamicObject[] subPositions) {
        HashMap subPositionMap = Maps.newHashMap();
        for (DynamicObject subPosition : subPositions) {
            Long parentId = subPosition.getLong("parent.id");
            List subIdList = subPositionMap.computeIfAbsent(parentId, v -> Lists.newArrayList());
            subIdList.add(subPosition.getLong("id"));
        }
        return subPositionMap;
    }

    private List<Long> getEnablePositionIds() {
        ValidateResultCollection validateResults = this.getValidateContext().getValidateResults();
        HashSet errorDataIndex = null;
        if (validateResults != null) {
            errorDataIndex = validateResults.getErrorDataIndexs();
        }
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ArrayList positionIds = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
        for (int i = 0; i < dataEntities.length; ++i) {
            if (errorDataIndex != null && errorDataIndex.contains(i)) continue;
            if (HRStringUtils.equals((String)"disable", (String)this.operationKey)) {
                positionIds.add(dataEntities[i].getDataEntity().getLong("boid"));
                continue;
            }
            if (!HRStringUtils.equals((String)"dochange", (String)this.operationKey) || !"0".equals(dataEntities[i].getDataEntity().getString("enable"))) continue;
            positionIds.add(dataEntities[i].getDataEntity().getLong("boid"));
        }
        return positionIds;
    }
}

