/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.position.validate;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.hbpm.business.domain.repository.position.MserviceQueryRepository;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;

public class PositionDisableValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        String operateKey = this.getOperateKey();
        if ("disable".equals(operateKey)) {
            List<Long> enablePositonId = Arrays.stream(datas).filter(dyn -> HRStringUtils.equals((String)"1", (String)dyn.getDataEntity().getString("enable"))).map(dyn -> dyn.getDataEntity().getLong("id")).collect(Collectors.toList());
            ArrayList<Long> successPosId = new ArrayList<Long>();
            ArrayList<Long> failPosId = new ArrayList<Long>();
            this.validateSub(enablePositonId, successPosId, failPosId);
            Map allUsersOfPosition = MserviceQueryRepository.getInstance().queryAllUsersByPosition(enablePositonId);
            this.check(datas, enablePositonId, failPosId, allUsersOfPosition);
        }
    }

    private void check(ExtendedDataEntity[] datas, List<Long> enablePositonId, List<Long> failPosId, Map<Long, Set<Long>> allUsersOfPosition) {
        for (ExtendedDataEntity data : datas) {
            Set<Long> userOfPositions;
            Long id = data.getDataEntity().getLong("id");
            if (!enablePositonId.contains(id)) {
                this.addFatalErrorMessage(data, ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u542f\u7528\u72b6\u6001\u7684\u5c97\u4f4d\u624d\u80fd\u7981\u7528\u3002", (String)"PositionDisableValidator_1", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]));
            }
            if (failPosId.contains(id)) {
                this.addFatalErrorMessage(data, ResManager.loadKDString((String)"\u7981\u7528\u5931\u8d25\uff0c\u5c97\u4f4d\u6709\u5df2\u542f\u7528\u7684\u4e0b\u7ea7\u5c97\u4f4d\u3002", (String)"PositionDisableValidator_2", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]));
            }
            if (ObjectUtils.isEmpty(allUsersOfPosition) || ObjectUtils.isEmpty(userOfPositions = allUsersOfPosition.get(id))) continue;
            this.addFatalErrorMessage(data, ResManager.loadKDString((String)"\u5c97\u4f4d\u6709\u5728\u804c\u4eba\u5458\uff0c\u4e0d\u5141\u8bb8\u7981\u7528\u3002", (String)"PositionDisableValidator_3", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]));
        }
    }

    private void validateSub(List<Long> idList, List<Long> successPosId, List<Long> failPosId) {
        DynamicObject[] subPositions = PositionQueryRepository.getInstance().querySubPositions(idList);
        DynamicObject[] subPositionExcludeFuture = (DynamicObject[])Arrays.stream(subPositions).filter(dyn -> !HRStringUtils.equals((String)"0", (String)dyn.getString("datastatus"))).toArray(DynamicObject[]::new);
        Map<Long, List<Long>> idSubPosMap = this.groupSubPositionMap(subPositionExcludeFuture);
        HashMap waitIdMap = Maps.newHashMap();
        for (Long id : idList) {
            List<Long> subIds = idSubPosMap.get(id);
            if (subIds == null) {
                successPosId.add(id);
                continue;
            }
            if (idList.containsAll(subIds)) {
                this.filterWaitEnablePos(id, subIds, successPosId, failPosId, waitIdMap);
                continue;
            }
            failPosId.add(id);
        }
        if (!ObjectUtils.isEmpty((Object)waitIdMap)) {
            for (int count = 0; count < 10 && !ObjectUtils.isEmpty((Object)waitIdMap); ++count) {
                HashMap copyIdMap = new HashMap();
                waitIdMap.forEach((key, value) -> copyIdMap.put(key, value));
                for (Map.Entry next : copyIdMap.entrySet()) {
                    Long id = (Long)next.getKey();
                    if (successPosId.contains(id) || failPosId.contains(id)) continue;
                    List subWorkRoleIds = (List)next.getValue();
                    waitIdMap.remove(id);
                    this.filterWaitEnablePos(id, subWorkRoleIds, successPosId, failPosId, waitIdMap);
                }
            }
        }
    }

    private void filterWaitEnablePos(Long id, List<Long> subIds, List<Long> successPosId, List<Long> failPosId, Map<Long, List<Long>> waitIdMap) {
        List failLowPositions = subIds.stream().filter(subId -> failPosId.contains(subId)).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(failLowPositions)) {
            failPosId.add(id);
        } else {
            List waitLowPositions = subIds.stream().filter(subId -> !successPosId.contains(subId)).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(waitLowPositions)) {
                waitIdMap.put(id, waitLowPositions);
            } else {
                successPosId.add(id);
            }
        }
    }

    private Map<Long, List<Long>> groupSubPositionMap(DynamicObject[] subPositions) {
        HashMap subPositionMap = Maps.newHashMap();
        for (DynamicObject subPosition : subPositions) {
            Long parentId = subPosition.getLong("parent.id");
            List subIdList = subPositionMap.computeIfAbsent(parentId, v -> Lists.newArrayList());
            subIdList.add(subPosition.getLong("id"));
        }
        return subPositionMap;
    }
}

