/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.position.validate;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.hbpm.business.domain.service.impl.position.PositionServiceImpl;
import org.apache.commons.collections.CollectionUtils;

public class PositionFutureEffectValidator
extends HRDataBaseValidator {
    private static Log logger = LogFactory.getLog(PositionFutureEffectValidator.class);

    public void validate() {
        if (Objects.isNull(this.dataEntities) || this.dataEntities.length == 0) {
            return;
        }
        if (HRStringUtils.equals((String)this.getOperateKey(), (String)"retry")) {
            this.checkRetry();
            this.checkBaseData();
        } else if (HRStringUtils.equals((String)this.getOperateKey(), (String)"revoke")) {
            this.checkRevoke();
        }
    }

    private void checkRetry() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String errorMsg;
            DynamicObject pos = dataEntity.getDataEntity();
            if (!HRStringUtils.equals((String)pos.getString("datastatus"), (String)"0")) {
                errorMsg = ResManager.loadKDString((String)"\u53ea\u80fd\u91cd\u8bd5\u5f85\u751f\u6548\u6570\u636e\u3002", (String)"PositionFutureEffectValidator_0", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, errorMsg);
            }
            if (!HRDateTimeUtils.dayAfter((Date)pos.getDate("bsed"), (Date)HRDateTimeUtils.getNowDate())) continue;
            errorMsg = ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u665a\u4e8e\u5f53\u524d\u65e5\u671f\uff0c\u4e0d\u80fd\u91cd\u8bd5\u3002", (String)"PositionFutureEffectValidator_2", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, errorMsg);
        }
    }

    private void checkRevoke() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject pos = dataEntity.getDataEntity();
            if (HRStringUtils.equals((String)pos.getString("datastatus"), (String)"0")) continue;
            String errorMsg = ResManager.loadKDString((String)"\u53ea\u80fd\u64a4\u9500\u5f85\u751f\u6548\u6570\u636e\u3002", (String)"PositionFutureEffectValidator_1", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBaseData() {
        ArrayList<ExtendedDataEntity> dataList = new ArrayList<ExtendedDataEntity>(Arrays.asList(this.dataEntities));
        if (CollectionUtils.isNotEmpty((Collection)this.getFalseDataEntities())) {
            dataList.removeAll(this.getFalseDataEntities());
        }
        if (dataList.size() == 0) {
            return;
        }
        List<ExtendedDataEntity> sortDataList = this.sortFromHighToLow(dataList);
        HashMap errMap = Maps.newHashMapWithExpectedSize((int)sortDataList.size());
        StringBuilder errInfo = new StringBuilder();
        ArrayList successBoIdList = Lists.newArrayListWithExpectedSize((int)sortDataList.size());
        for (ExtendedDataEntity dataEntity : sortDataList) {
            DynamicObject pos = dataEntity.getDataEntity();
            DynamicObject parent = pos.getDynamicObject("parent");
            DynamicObject adminorg = pos.getDynamicObject("adminorg");
            long posId = pos.getLong("id");
            long posBoid = pos.getLong("boid");
            String errorMsg = "";
            if (parent != null && !HRStringUtils.equals((String)parent.getString("enable"), (String)"1")) {
                errorMsg = ResManager.loadKDString((String)"\u4e0a\u7ea7\u5c97\u4f4d\u5df2\u7981\u7528\u3002", (String)"PositionFutureEffectValidator_3", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, errorMsg);
                errInfo.append(errorMsg);
            }
            if (parent != null && !HRStringUtils.equals((String)parent.getString("datastatus"), (String)"1") && !successBoIdList.contains(parent.getLong("id"))) {
                errorMsg = ResManager.loadKDString((String)"\u4e0a\u7ea7\u5c97\u4f4d\u672a\u751f\u6548\u3002", (String)"PositionFutureEffectValidator_4", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, errorMsg);
                errInfo.append(errorMsg);
            }
            if (adminorg == null) {
                errorMsg = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"PositionFutureEffectValidator_6", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, errorMsg);
                errInfo.append(errorMsg);
            } else if (!HRStringUtils.equals((String)adminorg.getString("enable"), (String)"1")) {
                errorMsg = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u5df2\u7981\u7528\u3002", (String)"PositionFutureEffectValidator_5", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, errorMsg);
                errInfo.append(errorMsg);
            }
            String errMsgStr = errInfo.toString();
            if (HRStringUtils.isNotEmpty((String)errMsgStr)) {
                errMap.put(posId, errMsgStr);
            } else {
                successBoIdList.add(posBoid);
            }
            errInfo.setLength(0);
        }
        if (errMap.size() > 0) {
            TXHandle txHandle = TX.requiresNew();
            try {
                logger.info("save_futureeffect_failresult_start");
                PositionServiceImpl positionService = new PositionServiceImpl();
                positionService.saveFutureEffectFailResult((Map)errMap);
            }
            catch (Exception e) {
                logger.error("save_futureeffect_failresult_error", (Throwable)e);
                txHandle.markRollback();
            }
            finally {
                txHandle.close();
                logger.info("save_futureeffect_failresult_end");
            }
        }
    }

    private List<ExtendedDataEntity> sortFromHighToLow(List<ExtendedDataEntity> dataList) {
        HashMap posIdToDataMap = Maps.newHashMapWithExpectedSize((int)dataList.size());
        HashMap posIdToParentMap = Maps.newHashMapWithExpectedSize((int)dataList.size());
        for (ExtendedDataEntity extendedDataEntity : dataList) {
            DynamicObject pos = extendedDataEntity.getDataEntity();
            posIdToParentMap.put(pos.getLong("boid"), pos.getLong("parent.id"));
            posIdToDataMap.put(pos.getLong("boid"), extendedDataEntity);
        }
        ArrayList sortDataList = Lists.newArrayListWithExpectedSize((int)dataList.size());
        for (ExtendedDataEntity extendedDataEntity : dataList) {
            long posId = extendedDataEntity.getDataEntity().getLong("boid");
            this.addDataFromHighToLow(posId, posIdToParentMap, posIdToDataMap, sortDataList);
        }
        return sortDataList;
    }

    private void addDataFromHighToLow(long posId, Map<Long, Long> posParentBoIdMap, Map<Long, ExtendedDataEntity> posIdToDataMap, List<ExtendedDataEntity> sortDataList) {
        ExtendedDataEntity data = posIdToDataMap.get(posId);
        Long parent = posParentBoIdMap.get(posId);
        if (parent == null || parent == 0L) {
            if (!sortDataList.contains(data)) {
                sortDataList.add(data);
            }
            return;
        }
        ExtendedDataEntity parentData = posIdToDataMap.get(parent);
        if (parentData == null || sortDataList.contains(parentData)) {
            if (!sortDataList.contains(data)) {
                sortDataList.add(data);
            }
            return;
        }
        this.addDataFromHighToLow(parent, posParentBoIdMap, posIdToDataMap, sortDataList);
        if (!sortDataList.contains(data)) {
            sortDataList.add(data);
        }
    }
}

