/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.position.validate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.opplugin.web.validate.basedata.PositionValidatorServiceHelper;

public class PositionFutureVersionExistValidator
extends HRDataBaseValidator {
    private PositionValidatorServiceHelper positionValidatorServiceHelper = new PositionValidatorServiceHelper();
    private String idKey = "boid";

    public PositionFutureVersionExistValidator() {
    }

    public PositionFutureVersionExistValidator(String idKey) {
        this.idKey = idKey;
    }

    public void validate() {
        Map versionIdAndPositionMap;
        if (HRStringUtils.equals((String)this.idKey, (String)"boid")) {
            versionIdAndPositionMap = Arrays.stream(this.dataEntities).collect(Collectors.toMap(dyn -> dyn.getDataEntity().getLong("boid"), ExtendedDataEntity::getDataEntity));
        } else {
            List idList = Arrays.stream(this.dataEntities).map(data -> data.getDataEntity().getLong(this.idKey)).collect(Collectors.toList());
            versionIdAndPositionMap = PositionQueryRepository.getInstance().queryVersionIdAndPositionMap(idList);
        }
        ArrayList positionBoidList = Lists.newArrayListWithExpectedSize((int)this.dataEntities.length);
        for (ExtendedDataEntity data2 : this.dataEntities) {
            DynamicObject pos = data2.getDataEntity();
            DynamicObject bo = (DynamicObject)versionIdAndPositionMap.get(pos.getLong(this.idKey));
            if (bo == null) continue;
            long boid = bo.getLong("boid");
            positionBoidList.add(boid);
        }
        if (CollectionUtils.isEmpty((Collection)positionBoidList)) {
            return;
        }
        DynamicObject[] positionFutureVersions = PositionQueryRepository.getInstance().queryPositionFutureVersion((List)positionBoidList);
        if (positionFutureVersions.length == 0) {
            return;
        }
        Map<Long, DynamicObject> futureVersionMap = Arrays.stream(positionFutureVersions).collect(Collectors.toMap(dyn -> dyn.getLong("boid"), dyn -> dyn, (v1, v2) -> v2));
        Date now = HRDateTimeUtils.getNowDate();
        for (ExtendedDataEntity data3 : this.dataEntities) {
            long boid;
            DynamicObject futureVersion;
            DynamicObject pos = data3.getDataEntity();
            DynamicObject bo = (DynamicObject)versionIdAndPositionMap.get(pos.getLong(this.idKey));
            if (bo == null || (futureVersion = futureVersionMap.get(boid = bo.getLong("boid"))) == null) continue;
            Date bsed = pos.getDate("bsed");
            if (HRDateTimeUtils.truncateDate((Date)bsed).after(HRDateTimeUtils.truncateDate((Date)now))) {
                this.addFatalErrorMessage(data3, this.positionValidatorServiceHelper.validateHasFutureVersion());
                continue;
            }
            Date futureBsed = futureVersion.getDate("bsed");
            if (HRDateTimeUtils.truncateDate((Date)now).before(futureBsed)) continue;
            this.addFatalErrorMessage(data3, this.positionValidatorServiceHelper.validateHasFutureFailVersion());
        }
    }
}

