/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.position.validate;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.hbpm.business.domain.repository.position.MserviceQueryRepository;
import kd.hrmp.hbpm.business.utils.PositionJobRelationCheckUtil;
import kd.hrmp.hbpm.business.utils.PositionUtils;

public class PositionJobRelationValidator
extends HRDataBaseValidator {
    private PositionJobRelationCheckUtil positionJobRelationCheckUtil = PositionJobRelationCheckUtil.getInstance();

    public void validate() {
        Object[] dataEntities = this.getDataEntities();
        if (PositionUtils.isArrayEmpty((Object[])dataEntities).booleanValue()) {
            return;
        }
        LinkedList jobScmCollect = Lists.newLinkedList();
        LinkedList jobCollect = Lists.newLinkedList();
        LinkedList jobFamilyCollect = Lists.newLinkedList();
        Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).forEach(position -> {
            DynamicObject jobScm = position.getDynamicObject("jobscm");
            DynamicObject job = position.getDynamicObject("job");
            if (!HRObjectUtils.isEmpty((Object)jobScm)) {
                jobScmCollect.add(jobScm.getLong("id"));
            }
            if (!HRObjectUtils.isEmpty((Object)job)) {
                jobCollect.add(job.getLong("id"));
                jobFamilyCollect.add(job.getLong("jobfamily.id"));
            }
        });
        this.checkJobRelatedInfo((ExtendedDataEntity[])dataEntities, jobScmCollect, jobCollect, jobFamilyCollect);
    }

    private void checkJobRelatedInfo(ExtendedDataEntity[] dataEntities, List<Long> jobScmCollect, List<Long> jobCollect, List<Long> jobFamilyCollect) {
        MserviceQueryRepository mserviceQueryRepository = MserviceQueryRepository.getInstance();
        Map jobScmRelationRange = mserviceQueryRepository.getJobLevelGrade(jobScmCollect, jobFamilyCollect);
        Map jobLevelGradeRangeInfo = mserviceQueryRepository.getJobLevelGradeRangeInfo(jobCollect);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject position = dataEntity.getDataEntity();
            this.showErrorMessage(dataEntity, this.positionJobRelationCheckUtil.checkJobSystemRelated(position));
            if (this.isAlreadyCheckedError(position)) continue;
            Map levelGradeRangeByJobId = this.positionJobRelationCheckUtil.getLevelGradeRangeByJobId(jobLevelGradeRangeInfo, position.getString("job.id"));
            Map jobLevelGradeRange = this.positionJobRelationCheckUtil.getJobLevelGradeRange(position, this.positionJobRelationCheckUtil.getJobScmByCollects(position, jobScmRelationRange), levelGradeRangeByJobId);
            this.showErrorMessage(dataEntity, this.positionJobRelationCheckUtil.checkJobLevelGradeRange(position, jobLevelGradeRange));
        }
    }

    private void showErrorMessage(ExtendedDataEntity dataEntity, Object content) {
        if (Objects.isNull(content)) {
            return;
        }
        if (content instanceof String) {
            this.addFatalErrorMessage(dataEntity, (String)content);
        } else if (content instanceof List) {
            List result = (List)content;
            if (CollectionUtils.isEmpty((Collection)result)) {
                return;
            }
            result.forEach(value -> this.addFatalErrorMessage(dataEntity, (String)value));
        }
    }

    private boolean isAlreadyCheckedError(DynamicObject dy) {
        return this.getValidateResult().getAllErrorInfo().stream().anyMatch(info -> info.getPkValue().equals(dy.getLong("id")));
    }
}

