/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.position.validate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.hbpm.business.utils.PositionUtils;
import kd.hrmp.hbpm.opplugin.web.validate.basedata.PositionValidatorServiceHelper;

public class PositionRelationImportValidator
extends HRDataBaseValidator {
    private List<ExtendedDataEntity> falseDataentity;
    private PositionValidatorServiceHelper positionValidatorServiceHelper = new PositionValidatorServiceHelper();

    public PositionRelationImportValidator(List<ExtendedDataEntity> falseDataentity) {
        this.falseDataentity = falseDataentity;
    }

    public void validate() {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject position = data.getDataEntity();
            this.validateEnable(position, data);
            this.validateEntryEntity(position, data);
            this.validateRelBsed(position, data);
        }
        this.falseDataentity.addAll(this.getFalseDataEntities());
    }

    private void validateEnable(DynamicObject position, ExtendedDataEntity data) {
        String msg = this.positionValidatorServiceHelper.validatePositionEnable(position);
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            this.addFatalErrorMessage(data, msg);
        }
    }

    private void validateRelBsed(DynamicObject position, ExtendedDataEntity data) {
        Date firstBsed;
        Date bsed = position.getDate("bsed");
        String msg = this.positionValidatorServiceHelper.validateFirstBsed(bsed, firstBsed = position.getDate("firstbsed"));
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            this.addFatalErrorMessage(data, msg);
        }
        if (StringUtils.isNotEmpty((CharSequence)(msg = this.positionValidatorServiceHelper.validateBSedLessAssignDate(bsed, PositionUtils.getCurrentDate())))) {
            this.addFatalErrorMessage(data, msg);
        }
    }

    private void validateEntryEntity(DynamicObject position, ExtendedDataEntity data) {
        DynamicObjectCollection entryEntity = position.getDynamicObjectCollection("entryentity");
        if (entryEntity != null && entryEntity.size() > 0) {
            ArrayList reportTypeIds = Lists.newArrayListWithExpectedSize((int)8);
            for (DynamicObject entity : entryEntity) {
                String targetWorkRoleUniqueMessage;
                String targetWorkRoleMessage;
                String reportTypeMessage;
                DynamicObject reportType = entity.getDynamicObject("reporttype");
                DynamicObject targetWorkRole = entity.getDynamicObject("targetworkrole");
                if (!HRObjectUtils.isEmpty((Object)targetWorkRole) && StringUtils.isNotEmpty((CharSequence)(reportTypeMessage = this.positionValidatorServiceHelper.validateMustForReportType(reportType)))) {
                    this.addFatalErrorMessage(data, reportTypeMessage);
                }
                if (!HRObjectUtils.isEmpty((Object)reportType) && StringUtils.isNotEmpty((CharSequence)(targetWorkRoleMessage = this.positionValidatorServiceHelper.validateMustForTargetWorkRole(targetWorkRole)))) {
                    this.addFatalErrorMessage(data, targetWorkRoleMessage);
                }
                if (!StringUtils.isNotEmpty((CharSequence)(targetWorkRoleUniqueMessage = this.positionValidatorServiceHelper.validateReportTypeUnique(reportTypeIds, reportType)))) continue;
                this.addFatalErrorMessage(data, targetWorkRoleUniqueMessage);
            }
        }
    }
}

