/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.position.validate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.service.position.PositionServiceHelper;
import kd.hrmp.hbpm.business.utils.PositionUtils;
import kd.hrmp.hbpm.opplugin.web.validate.basedata.PositionValidatorServiceHelper;

public class PositionStatusValidator
extends HRDataBaseValidator {
    public PositionValidatorServiceHelper positionValidatorServiceHelper = new PositionValidatorServiceHelper();
    private String operationKey;

    public PositionStatusValidator(String operationKey) {
        this.operationKey = operationKey;
    }

    public void validate() {
        Object[] dataEntities = this.dataEntities;
        if (PositionUtils.isArrayEmpty((Object[])dataEntities).booleanValue()) {
            return;
        }
        Map<Long, ExtendedDataEntity> positionIdToEntityMap = Arrays.stream(dataEntities).collect(Collectors.toMap(data -> data.getDataEntity().getLong("id"), data -> data));
        DynamicObject[] positionDyns = PositionQueryRepository.getInstance().queryPositionBaseInfo(new ArrayList<Long>(positionIdToEntityMap.keySet()));
        if (HRStringUtils.equals((String)"save", (String)this.operationKey)) {
            this.checkSaveOperationData(positionIdToEntityMap, (ExtendedDataEntity[])dataEntities);
        }
        if (HRStringUtils.equals((String)"dochange", (String)this.operationKey)) {
            this.checkChangeOperationData(positionIdToEntityMap, positionDyns);
        }
        if (HRStringUtils.equals((String)"enable", (String)this.operationKey)) {
            this.checkEnableOperationData(positionIdToEntityMap, positionDyns);
        }
        if (HRStringUtils.equals((String)"disable", (String)this.operationKey)) {
            this.checkDisableOperationData((ExtendedDataEntity[])dataEntities);
        }
    }

    private void checkSaveOperationData(Map<Long, ExtendedDataEntity> positionIdToEntityMap, ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject position = dataEntity.getDataEntity();
            String msg = null;
            if (this.integrationCheckParent(position, positionIdToEntityMap) || !StringUtils.isNotEmpty((CharSequence)(msg = this.positionValidatorServiceHelper.validateParentPositionEnable(position.getDynamicObject("parent"), position.getString("name"))))) continue;
            this.addFatalErrorMessage(positionIdToEntityMap.get(position.getLong("id")), msg);
        }
    }

    private void checkChangeOperationData(Map<Long, ExtendedDataEntity> positionIdToEntityMap, DynamicObject[] positionDyns) {
        for (DynamicObject position : positionDyns) {
            String msg = null;
            if (!PositionServiceHelper.isInitComplete((DynamicObject)position)) {
                msg = ResManager.loadKDString((String)"\u53ea\u80fd\u53d8\u66f4\u521d\u59cb\u5316\u5df2\u5b8c\u6210\u7684\u5c97\u4f4d\u3002", (String)"PositionStatusValidator_1", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(positionIdToEntityMap.get(position.getLong("id")), msg);
            }
            if (StringUtils.isNotEmpty((CharSequence)(msg = this.positionValidatorServiceHelper.validateAdminOrgEnable(position.getDynamicObject("adminorg"))))) {
                this.addFatalErrorMessage(positionIdToEntityMap.get(position.getLong("id")), msg);
            }
            if (this.integrationCheckParent(position, positionIdToEntityMap) || !StringUtils.isNotEmpty((CharSequence)(msg = this.positionValidatorServiceHelper.validateParentPositionEnable(position.getDynamicObject("parent"), position.getString("name"))))) continue;
            this.addFatalErrorMessage(positionIdToEntityMap.get(position.getLong("id")), msg);
        }
    }

    private void checkEnableOperationData(Map<Long, ExtendedDataEntity> positionIdToEntityMap, DynamicObject[] positionDyns) {
        for (DynamicObject position : positionDyns) {
            String msg = null;
            if (!PositionServiceHelper.isInitComplete((DynamicObject)position)) {
                msg = ResManager.loadKDString((String)"\u53ea\u80fd\u542f\u7528\u521d\u59cb\u5316\u5df2\u5b8c\u6210\u7684\u5c97\u4f4d\u3002", (String)"PositionStatusValidator_5", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(positionIdToEntityMap.get(position.getLong("id")), msg);
            }
            if (PositionServiceHelper.isEnabled((DynamicObject)position)) {
                msg = ResManager.loadKDString((String)"\u53ea\u80fd\u542f\u7528\u5f85\u542f\u7528\u6216\u8005\u5df2\u7981\u7528\u7684\u5c97\u4f4d\u3002", (String)"PositionStatusValidator_4", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(positionIdToEntityMap.get(position.getLong("id")), msg);
            }
            if (!StringUtils.isNotEmpty((CharSequence)(msg = this.positionValidatorServiceHelper.validateAdminOrgEnable(position.getDynamicObject("adminorg"))))) continue;
            this.addFatalErrorMessage(positionIdToEntityMap.get(position.getLong("id")), msg);
        }
    }

    private void checkDisableOperationData(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject position = dataEntity.getDataEntity();
            String msg = null;
            if (!PositionServiceHelper.isInitComplete((DynamicObject)position)) {
                msg = ResManager.loadKDString((String)"\u53ea\u80fd\u7981\u7528\u521d\u59cb\u5316\u5df2\u5b8c\u6210\u7684\u5c97\u4f4d\u3002", (String)"PositionStatusValidator_2", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(dataEntity, msg);
            }
            if (PositionServiceHelper.isEnabled((DynamicObject)position)) continue;
            msg = ResManager.loadKDString((String)"\u53ea\u80fd\u7981\u7528\u5df2\u542f\u7528\u7684\u5c97\u4f4d\u3002", (String)"PositionStatusValidator_3", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
            this.addFatalErrorMessage(dataEntity, msg);
        }
    }

    private boolean integrationCheckParent(DynamicObject pos, Map<Long, ExtendedDataEntity> posMap) {
        long posId = pos.getLong("id");
        ExtendedDataEntity dataEntity = posMap.get(posId);
        if (dataEntity == null) {
            return true;
        }
        DynamicObject position = dataEntity.getDataEntity();
        if ("2".equals(position.getString("initdatasource"))) {
            if ("0".equals(position.getString("enable"))) {
                return true;
            }
            if ("1".equals(position.getString("enable"))) {
                DynamicObject parent = position.getDynamicObject("parent");
                if (parent == null) {
                    return true;
                }
                long parentId = parent.getLong("id");
                ExtendedDataEntity parentFromParam = posMap.get(parentId);
                if (parentFromParam != null && "1".equals(parentFromParam.getDataEntity().getString("enable"))) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }
}

