/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.position.validate;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.hbpm.business.utils.model.PositionNodeEntity;

public class PositionSubValidator
extends HRDataBaseValidator {
    private final String errorIdsStr;

    public PositionSubValidator(String errorIdsStr) {
        this.errorIdsStr = errorIdsStr;
    }

    private List<ExtendedDataEntity> getFalseExtendedDataEntity() {
        ValidateResultCollection resultCollection = this.getValidateContext().getValidateResults();
        if (resultCollection == null) {
            return new ArrayList<ExtendedDataEntity>();
        }
        HashSet falseSet = this.getValidateContext().getValidateResults().getErrorDataIndexs();
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        if (!CollectionUtils.isEmpty((Collection)falseSet)) {
            ArrayList<ExtendedDataEntity> falseList = new ArrayList<ExtendedDataEntity>(falseSet.size());
            falseSet.forEach(id -> falseList.add(extendedDataEntities[id]));
            return falseList;
        }
        return new ArrayList<ExtendedDataEntity>();
    }

    public void validate() {
        List<ExtendedDataEntity> falseList = this.getFalseExtendedDataEntity();
        List errorIdList = JSON.parseArray((String)this.errorIdsStr, Long.class);
        if (CollectionUtils.isEmpty(falseList) && CollectionUtils.isEmpty((Collection)errorIdList)) {
            return;
        }
        errorIdList = errorIdList == null ? new ArrayList() : errorIdList;
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashMap<Long, PositionNodeEntity> map = new HashMap<Long, PositionNodeEntity>(dataEntities.length);
        String message = ResManager.loadKDString((String)"\u4e0a\u7ea7\u5c97\u4f4d\u4e0d\u5b58\u5728\u3002", (String)"PositionSubValidator_0", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dy = dataEntity.getDataEntity();
            Long positionId = dy.getLong("id");
            if (errorIdList.contains(positionId)) {
                this.addErrorMessage(dataEntity, message);
            }
            map.put(positionId, new PositionNodeEntity(positionId, Long.valueOf(dy.getLong("parent.id")), dataEntity));
        }
        map.values().forEach(node -> {
            Long parentId = node.getParentId();
            PositionNodeEntity positionNodeEntity = (PositionNodeEntity)map.get(parentId);
            if (positionNodeEntity != null) {
                positionNodeEntity.getSubNodeList().add(node);
            }
        });
        HashSet set = new HashSet(dataEntities.length);
        falseList.forEach(extend -> ((PositionNodeEntity)map.get(extend.getDataEntity().getLong("id"))).setErrorByParent(set));
        errorIdList.forEach(id -> ((PositionNodeEntity)map.get(id)).setErrorByParent(set));
        String errorMessage = ResManager.loadKDString((String)"\u4e0a\u7ea7\u5c97\u4f4d\u201c%s\u201d\u6709\u9519\u8bef\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PositionSubValidator_1", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
        map.values().stream().filter(PositionNodeEntity::isErrorFlag).forEach(entity -> this.addErrorMessage(entity.getExtendedDataEntity(), String.format(Locale.ROOT, errorMessage, entity.getExtendedDataEntity().getDataEntity().getString("parent.number"))));
    }
}

