/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.position.validate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ValidateResult;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.hbpm.business.utils.SystemParamHelper;

public class PositionTplEnableValidator
extends HRDataBaseValidator {
    public void validate() {
        super.validate();
        ValidateResult validateResult = this.getValidateResult();
        Map validation = this.getValidation();
        List validateErrors = this.getValidateContext().getValidateResults().getValidateErrors();
        if (validateErrors.size() > 0) {
            return;
        }
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Map<Long, String> orgIdAndName = Arrays.stream(dataEntities).collect(Collectors.toMap(temp -> temp.getDataEntity().getLong("org.id"), temp -> temp.getDataEntity().getString("org.name"), (k1, k2) -> k1));
        Map batchParameter = SystemParamHelper.getBatchParameter(new ArrayList<Long>(orgIdAndName.keySet()));
        Arrays.asList(dataEntities).forEach(dataEntitity -> {
            long orgId = dataEntitity.getDataEntity().getLong("org.id");
            Map parameterData = (Map)batchParameter.get(String.valueOf(orgId));
            String orgName = (String)orgIdAndName.get(orgId);
            if (parameterData == null) {
                this.addFatalErrorMessage((ExtendedDataEntity)dataEntitity, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u201c%1$s\u201d\u672a\u542f\u7528\u6a21\u677f\u5e93\uff0c\u4e0d\u53ef\u542f\u7528\u6570\u636e\u3002", (String)"PositionTplEnableValidator_0", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]), orgName));
                return;
            }
            Boolean openTpl = (Boolean)parameterData.get("openpositiontpl");
            if (openTpl != null && !openTpl.booleanValue()) {
                this.addFatalErrorMessage((ExtendedDataEntity)dataEntitity, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u201c%1$s\u201d\u672a\u542f\u7528\u6a21\u677f\u5e93\uff0c\u4e0d\u53ef\u542f\u7528\u6570\u636e\u3002", (String)"PositionTplEnableValidator_0", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]), orgName));
            }
        });
    }
}

