/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.position.validate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ValidateResult;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.hbpm.business.service.position.PositionTplApplicationScopeServiceImpl;
import kd.hrmp.hbpm.business.utils.SystemParamHelper;

public class PositionTplSaveValidator
extends HRDataBaseValidator {
    public void validate() {
        super.validate();
        ValidateResult validateResult = this.getValidateResult();
        Map validation = this.getValidation();
        List validateErrors = this.getValidateContext().getValidateResults().getValidateErrors();
        if (validateErrors.size() > 0) {
            return;
        }
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Map<Long, String> orgIdAndName = Arrays.stream(dataEntities).collect(Collectors.toMap(temp -> temp.getDataEntity().getLong("org.id"), temp -> temp.getDataEntity().getString("org.name"), (k1, k2) -> k1));
        ArrayList<Long> buids = new ArrayList<Long>(orgIdAndName.keySet());
        String importType = (String)this.getOption().getVariables().get("importtype");
        Set<Long> collect = buids.stream().collect(Collectors.toSet());
        HashMap orgIdAndSubOrgList = new HashMap(16);
        if (importType != null) {
            collect.forEach(temp -> {
                PositionTplApplicationScopeServiceImpl positionTplApplicationScopeService = new PositionTplApplicationScopeServiceImpl();
                List subOrgId = positionTplApplicationScopeService.getSubOrgId(temp);
                orgIdAndSubOrgList.put(String.valueOf(temp), subOrgId);
            });
        }
        Map batchParameter = SystemParamHelper.getBatchParameter(buids);
        Arrays.asList(dataEntities).forEach(dataEntitity -> {
            long orgId = dataEntitity.getDataEntity().getLong("org.id");
            Map parameterData = (Map)batchParameter.get(String.valueOf(orgId));
            String orgName = (String)orgIdAndName.get(orgId);
            String errorMsg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u201c%1$s\u201d\u672a\u542f\u7528\u6a21\u677f\u5e93\uff0c\u4e0d\u53ef\u65b0\u589e\u3002", (String)"PositionTplSaveValidator_0", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
            if (parameterData == null) {
                if (importType != null && !"new".equals(importType)) {
                    errorMsg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u201c%1$s\u201d\u672a\u542f\u7528\u6a21\u677f\u5e93\uff0c\u4e0d\u53ef\u53d8\u66f4\u3002", (String)"PositionTplSaveValidator_1", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]), orgName);
                }
                this.addFatalErrorMessage((ExtendedDataEntity)dataEntitity, String.format(errorMsg, orgName));
                return;
            }
            Boolean openTpl = (Boolean)parameterData.get("openpositiontpl");
            if (openTpl != null && !openTpl.booleanValue()) {
                if (importType != null && !"new".equals(importType)) {
                    errorMsg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u201c%1$s\u201d\u672a\u542f\u7528\u6a21\u677f\u5e93\uff0c\u4e0d\u53ef\u53d8\u66f4\u3002", (String)"PositionTplSaveValidator_1", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]), orgName);
                }
                this.addFatalErrorMessage((ExtendedDataEntity)dataEntitity, String.format(errorMsg, orgName));
            }
        });
    }
}

