/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.position.validate;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.hbpm.business.domain.repository.position.PositionTplTypeRepository;

public class PositionTplTypeIndexUniqueValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        HashMap indexVsCountMap = Maps.newHashMapWithExpectedSize((int)extendedDataEntities.length);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            Integer index = dataEntity.getInt("index");
            if (!Objects.nonNull(index) || index.equals(0)) continue;
            Integer curCount = indexVsCountMap.getOrDefault(index, 1);
            indexVsCountMap.put(index, curCount);
        }
        DynamicObject[] dynArr = PositionTplTypeRepository.getInstance().getAllDyn("index");
        List indexListFromDb = Arrays.stream(dynArr).map(dyn -> dyn.getInt("index")).collect(Collectors.toList());
        Map<Long, Integer> idVsIndexMap = Arrays.stream(dynArr).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getInt("index")));
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            Integer index = extendedDataEntity.getDataEntity().getInt("index");
            long id = dataEntity.getLong("id");
            if (!Objects.nonNull(index) || index.equals(0)) continue;
            if ((Integer)indexVsCountMap.get(index) > 1) {
                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6392\u5e8f\u53f7\u201d", (String)"HRLogExportTaskClick_1", (String)"hrmp-hbp-common", (Object[])new Object[0]));
                this.getOption().setVariableValue("indexError", "true");
                continue;
            }
            if (!idVsIndexMap.containsKey(id)) {
                if (!indexListFromDb.contains(index)) continue;
                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6392\u5e8f\u53f7\u201d", (String)"HRLogExportTaskClick_1", (String)"hrmp-hbp-common", (Object[])new Object[0]));
                this.getOption().setVariableValue("indexError", "true");
                continue;
            }
            Integer removeVal = idVsIndexMap.remove(id);
            if (!idVsIndexMap.containsValue(index)) continue;
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6392\u5e8f\u53f7\u201d", (String)"HRLogExportTaskClick_1", (String)"hrmp-hbp-common", (Object[])new Object[0]));
            this.getOption().setVariableValue("indexError", "true");
            idVsIndexMap.put(id, removeVal);
        }
    }
}

