/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.position.validate;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.domain.repository.position.StandardPositionRepository;
import kd.hrmp.hbpm.business.utils.PositionPermissionUtil;
import kd.hrmp.hbpm.business.utils.PositionUtils;

public class StandardPositionValidator
extends HRDataBaseValidator {
    public void validate() {
        Object[] datas = this.getDataEntities();
        if (PositionUtils.isArrayEmpty((Object[])datas).booleanValue()) {
            return;
        }
        String operateKey = this.getOperateKey();
        if (Arrays.asList("save", "confirmchangenoaudit", "enablingsave").contains(operateKey)) {
            this.checkOrg((ExtendedDataEntity[])datas);
            this.checkOrgdesignbu((ExtendedDataEntity[])datas);
            if (HRStringUtils.equals((String)"confirmchangenoaudit", (String)operateKey)) {
                this.checkIsInitComplete((ExtendedDataEntity[])datas);
                this.checkPropChange((ExtendedDataEntity[])datas);
            }
        } else if (HRStringUtils.equals((String)"disable", (String)operateKey)) {
            this.checkDarkPosition((ExtendedDataEntity[])datas);
        }
    }

    private void checkIsInitComplete(ExtendedDataEntity[] data) {
        Arrays.stream(data).forEach(dataEntity -> this.validateIsInitComplete(dataEntity.getDataEntity(), (ExtendedDataEntity)dataEntity));
    }

    private void checkPropChange(ExtendedDataEntity[] datas) {
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)datas.length);
        for (ExtendedDataEntity data : datas) {
            ids.add(data.getDataEntity().getLong("boid"));
        }
        DynamicObject[] sourceDatas = StandardPositionRepository.getInstance().queryCurrentBoStdPositionByBoId((List)ids);
        Map<Long, DynamicObject> sourceMap = Arrays.stream(sourceDatas).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy));
        for (ExtendedDataEntity data : datas) {
            String errorMsg;
            DynamicObject dyn = data.getDataEntity();
            DynamicObject source = sourceMap.get(dyn.getLong("boid"));
            if (source == null) continue;
            if (!HRStringUtils.equals((String)dyn.getString("createorg.id"), (String)source.getString("createorg.id"))) {
                errorMsg = ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"StandardPositionValidator_4", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(data, errorMsg);
            }
            if (HRStringUtils.equals((String)dyn.getString("ctrlstrategy"), (String)source.getString("ctrlstrategy"))) continue;
            errorMsg = ResManager.loadKDString((String)"\u201c\u63a7\u5236\u7b56\u7565\u201d\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"StandardPositionValidator_5", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
            this.addFatalErrorMessage(data, errorMsg);
        }
    }

    private void checkOrg(ExtendedDataEntity[] data) {
        Arrays.stream(data).forEach(dataEntity -> {
            DynamicObjectCollection entries = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
            if (Objects.isNull(entries) || entries.isEmpty()) {
                return;
            }
            ArrayList ids = new ArrayList(entries.size());
            LinkedList removeDy = new LinkedList();
            entries.forEach(dy -> {
                long id = dy.getLong("adminorg.id");
                if (id == 0L) {
                    removeDy.add(dy);
                } else if (ids.contains(id)) {
                    String message = MessageFormat.format(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u201c{0}\u201d\u91cd\u590d\u6dfb\u52a0\uff0c\u8bf7\u4fee\u6539\u3002", (String)"StandardPositionValidator_0", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]), dy.getString("adminorg.name"));
                    this.addErrorMessage((ExtendedDataEntity)dataEntity, message);
                } else if (!"1".equals(dy.getString("adminorg.enable"))) {
                    String message = MessageFormat.format(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u201c{0}\u201d\u672a\u542f\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"StandardPositionValidator_6", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]), dy.getString("adminorg.name"));
                    this.addErrorMessage((ExtendedDataEntity)dataEntity, message);
                } else {
                    ids.add(id);
                }
            });
            if (!removeDy.isEmpty()) {
                entries.removeAll(removeDy);
            }
        });
    }

    private void checkOrgdesignbu(ExtendedDataEntity[] datas) {
        HasPermOrgResult hasPermOrg = PositionPermissionUtil.getPosHasPermOrg((long)RequestContext.get().getCurrUserId(), (String)"homs", (String)"hbpm_stposition", (String)"47150e89000000ac");
        Arrays.stream(datas).forEach(dataEntity -> {
            DynamicObject orgdesignbu = dataEntity.getDataEntity().getDynamicObject("orgdesignbu");
            String message = this.validateOrgHasPerm(orgdesignbu, hasPermOrg);
            if (HRStringUtils.isNotEmpty((String)message)) {
                this.addErrorMessage((ExtendedDataEntity)dataEntity, message);
            }
        });
    }

    private String validateOrgHasPerm(DynamicObject orgDy, HasPermOrgResult posHasPermOrg) {
        String msg = null;
        if (posHasPermOrg.hasAllOrgPerm()) {
            return null;
        }
        if (HRObjectUtils.isEmpty((Object)orgDy)) {
            return null;
        }
        List hasPermOrgs = posHasPermOrg.getHasPermOrgs();
        if (CollectionUtils.isEmpty((Collection)hasPermOrgs) || !hasPermOrgs.contains(orgDy.getLong("id"))) {
            msg = ResManager.loadKDString((String)"\u804c\u4f4d\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u4e0d\u5728\u6743\u9650\u8303\u56f4\u5185\uff0c\u8bf7\u4fee\u6539\u3002", (String)"StandardPositionValidator_3", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
        }
        return msg;
    }

    private void validateIsInitComplete(DynamicObject stPosition, ExtendedDataEntity data) {
        if (!"2".equals(stPosition.getString("initstatus"))) {
            String msg = ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d\u7f16\u7801\u65e0\u6548\u3002", (String)"StandardPositionValidator_2", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
            this.addFatalErrorMessage(data, msg);
        }
    }

    private void checkDarkPosition(ExtendedDataEntity[] data) {
        Map<Long, ExtendedDataEntity> collect = Arrays.stream(data).collect(Collectors.toMap(entity -> entity.getDataEntity().getLong("id"), entity -> entity, (v1, v2) -> v1));
        Object[] dys = PositionQueryRepository.getInstance().queryEnablePositionById(collect.keySet());
        if (PositionUtils.isArrayEmpty((Object[])dys).booleanValue()) {
            return;
        }
        for (Object dy : dys) {
            Long id = dy.getLong("stposition");
            ExtendedDataEntity entity2 = collect.get(id);
            if (Objects.isNull(entity2)) continue;
            String message = ResManager.loadKDString((String)"\u7981\u7528\u5931\u8d25\uff0c\u6807\u51c6\u5c97\u4f4d\u5df2\u7ecf\u6709\u5728\u804c\u4eba\u5458\u4efb\u804c\u3002", (String)"StandardPositionValidator_1", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
            this.addFatalErrorMessage(entity2, message);
            collect.remove(id);
        }
    }
}

