/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.projectrole;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hrmp.hbpm.business.application.impl.projectrole.ProjectRoleApplicationImpl;
import kd.hrmp.hbpm.business.application.impl.workrole.ReportingRelationServiceApplicationImpl;
import kd.hrmp.hbpm.business.application.projectrole.IProjectRoleApplication;
import kd.hrmp.hbpm.business.domain.repository.position.ReportingrelationQueryRepository;
import kd.hrmp.hbpm.business.domain.service.projectrole.ProRoleMsgService;
import kd.hrmp.hbpm.business.service.projectrole.ProjRoleChangeEvent;
import kd.hrmp.hbpm.business.service.projectrole.ProjectRoleValidateHelper;
import kd.hrmp.hbpm.business.utils.PRJRoleUtils;
import kd.hrmp.hbpm.business.utils.WorkRoleConverter;
import kd.hrmp.hbpm.business.utils.WorkRoleNewHisUtils;
import kd.hrmp.hbpm.common.constants.ProjectRoleConstants;
import kd.hrmp.hbpm.common.model.role.RelListsAfterCompareModel;
import kd.hrmp.hbpm.opplugin.web.validate.projectrole.ProRoleChgValidator;

public class ProjectRoleChangeOp
extends HRDataBaseOp
implements ProjectRoleConstants {
    private static final Log logger = LogFactory.getLog(ProjectRoleChangeOp.class);
    IProjectRoleApplication projectRoleApplication = ProjectRoleApplicationImpl.getInstance();
    private List<Map<String, Object>> msgMapList;
    private Long oldMainDutyProRoleBoId = null;
    private Long newMainDutyProRoleBoId = null;
    private Date effDate = null;

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new ProRoleChgValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String changeType = this.getOption().getVariableValue("changetype", "default");
        List<DynamicObject> projectRoleList = Arrays.asList(e.getDataEntities());
        switch (changeType) {
            case "modify": {
                DynamicObject projectRole = projectRoleList.get(0);
                boolean continueFlag = true;
                if (PRJRoleUtils.isDutyOnlyWithPage((DynamicObject)projectRole)) {
                    continueFlag = ProjectRoleValidateHelper.alterConfigWindow((DynamicObject)projectRole, (OperateOption)this.operateOption);
                }
                if (!continueFlag) {
                    e.setCancelOperation(true);
                    return;
                }
                ArrayList<DynamicObject> eventDataList = new ArrayList<DynamicObject>(16);
                HashMap<Long, Long> changeSceneSubMap = new HashMap<Long, Long>(16);
                this.effDate = projectRole.getDate("bsed");
                if (PRJRoleUtils.isDutyOnlyWithPage((DynamicObject)projectRole)) {
                    PRJRoleUtils.setRoleTypeDynByMainHead((DynamicObject)projectRole, (Boolean)Boolean.TRUE);
                    long proTeamId = projectRole.getLong("projteam.id");
                    DynamicObject dbMainDutyRoleDyn = PRJRoleUtils.getDbMainDutyRoleDyn((Long)proTeamId);
                    this.newMainDutyProRoleBoId = projectRole.getLong("boid");
                    if (dbMainDutyRoleDyn != null) {
                        this.oldMainDutyProRoleBoId = dbMainDutyRoleDyn.getLong("boid");
                        changeSceneSubMap.put(this.oldMainDutyProRoleBoId, PR_CHANGE_SUB_SCENE_DUTY_REPLACE);
                        changeSceneSubMap.put(this.newMainDutyProRoleBoId, PR_CHANGE_SUB_SCENE_DUTY_BE_REPLACE);
                    }
                    Map changeMap = PRJRoleUtils.getProjectRoleByChangeMainDutyRole((DynamicObject)projectRole, (DynamicObject)dbMainDutyRoleDyn);
                    List needChangeProjectRoleList = (List)changeMap.get("allRole");
                    needChangeProjectRoleList.removeIf(dy -> HRStringUtils.equals((String)dy.getString("boid"), (String)projectRole.getString("boid")));
                    if (!CollectionUtils.isEmpty((Collection)needChangeProjectRoleList)) {
                        WorkRoleNewHisUtils.setNewId((List)needChangeProjectRoleList);
                        HisResponse response = this.projectRoleApplication.changeProjectRolesOnlyADRelation(needChangeProjectRoleList);
                        eventDataList.addAll(Arrays.asList(((VersionChangeRespData)response.getData()).getNewDynamicObjects()));
                    }
                }
                HisResponse hisResponse = this.projectRoleApplication.changeProjectRolesOnlyADRelation(projectRoleList);
                eventDataList.addAll(Arrays.asList(((VersionChangeRespData)hisResponse.getData()).getNewDynamicObjects()));
                HashMap<Long, Long> changeTypeIdMap = new HashMap<Long, Long>(16);
                HashMap<Long, Long> changeOperateIdMap = new HashMap<Long, Long>(16);
                HashMap<Long, Long> changeSceneMap = new HashMap<Long, Long>(16);
                this.assemblyParams(eventDataList, changeTypeIdMap, changeOperateIdMap, changeSceneMap);
                ProjRoleChangeEvent.getInstance().handleProRoleEvent(eventDataList, changeSceneMap, changeSceneSubMap, changeTypeIdMap, changeOperateIdMap, this.oldMainDutyProRoleBoId, this.newMainDutyProRoleBoId, projectRoleList.get(0).getLong("changereason.id"));
                break;
            }
            case "cooperationchange": {
                this.changeNonAdministrativeRelations(projectRoleList);
                ProjRoleChangeEvent.handleChangeEvent((DynamicObject[])e.getDataEntities(), (long)CHANGE_TYPE_INFO, (long)CHANGE_OPERATE_INFO, (Long)PR_CHANGE_SCENE_UPDATE, (Long)projectRoleList.get(0).getLong("changereason.id"));
                break;
            }
        }
    }

    private void assemblyParams(List<DynamicObject> proRoleDynList, Map<Long, Long> changeTypeIdMap, Map<Long, Long> changeOperateIdMap, Map<Long, Long> changeSceneMap) {
        this.msgMapList = new ArrayList<Map<String, Object>>(16);
        PRJRoleUtils.assemblyProRoleMsgParams(proRoleDynList, this.msgMapList);
        proRoleDynList.forEach(dyn -> {
            if (!dyn.getBoolean("iscurrentversion")) {
                Long boId = dyn.getLong("boid");
                changeTypeIdMap.put(boId, CHANGE_TYPE_INFO);
                changeOperateIdMap.put(boId, CHANGE_OPERATE_INFO);
                changeSceneMap.put(boId, PR_CHANGE_SCENE_UPDATE);
            }
        });
    }

    private void changeNonAdministrativeRelations(List<DynamicObject> PRJRoleList) {
        List newReportList;
        List deleteReportList;
        ReportingRelationServiceApplicationImpl reportingRelationServiceApplication = new ReportingRelationServiceApplicationImpl();
        DynamicObject projectRole = PRJRoleList.get(0);
        RelListsAfterCompareModel relListsAfterCompareModel = this.compareEntryAndGetResult(projectRole);
        List changeReportList = relListsAfterCompareModel.getChangeReportList();
        if (!CollectionUtils.isEmpty((Collection)changeReportList)) {
            reportingRelationServiceApplication.changeReportRelationsProp("2", changeReportList);
        }
        if (!CollectionUtils.isEmpty((Collection)(deleteReportList = relListsAfterCompareModel.getDeleteReportList()))) {
            Date effectDate = ((DynamicObject)deleteReportList.get(0)).getDate("bsed");
            reportingRelationServiceApplication.enableOrDisableReportRelations(deleteReportList, "disable", effectDate);
        }
        if (!CollectionUtils.isEmpty((Collection)(newReportList = relListsAfterCompareModel.getNewReportList()))) {
            reportingRelationServiceApplication.addReportRelations(newReportList);
        }
    }

    private RelListsAfterCompareModel compareEntryAndGetResult(DynamicObject projectRole) {
        DynamicObjectCollection relationEntry = projectRole.getDynamicObjectCollection("entryentity");
        long projectRoleBoId = projectRole.getLong("boid");
        WorkRoleConverter workRoleConverter = new WorkRoleConverter(Collections.singletonList(projectRoleBoId));
        DynamicObject[] nonADRelations = ReportingrelationQueryRepository.getInstance().queryNonAdministrativeRelationByDutyRoleIds(Collections.singletonList(projectRole.getLong("boid")));
        Map<Long, DynamicObject> boIdVsRelation = Arrays.stream(nonADRelations).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy));
        RelListsAfterCompareModel relListsAfterCompareModel = new RelListsAfterCompareModel();
        Object effectDate = projectRole.get("bsed");
        for (DynamicObject rowRelation : relationEntry) {
            long entryRelationBoId = rowRelation.getLong("reportingrelboid");
            DynamicObject dbRelation = boIdVsRelation.get(entryRelationBoId);
            if (dbRelation != null) {
                PRJRoleUtils.changeNonAdministrativeRelation((DynamicObject)dbRelation, (DynamicObject)rowRelation);
                relListsAfterCompareModel.addChangeReportingRel(dbRelation);
                continue;
            }
            DynamicObject newRelation = PRJRoleUtils.createNonAdministrativeRelationFromEntry4New((DynamicObject)rowRelation);
            newRelation.set("role", (Object)workRoleConverter.getWorkRoleId(projectRoleBoId));
            newRelation.set("enable", (Object)projectRole.getString("enable"));
            newRelation.set("bsed", effectDate);
            newRelation.set("initstatus", (Object)"2");
            relListsAfterCompareModel.addNewReportingRel(newRelation);
        }
        if (relListsAfterCompareModel.getChangeReportList().size() != nonADRelations.length) {
            Set entryRelationBoIdSet = relationEntry.stream().map(dy -> dy.getLong("reportingrelboid")).collect(Collectors.toSet());
            boIdVsRelation.entrySet().stream().filter(entry -> !entryRelationBoIdSet.contains(entry.getKey())).peek(entry -> ((DynamicObject)entry.getValue()).set("bsed", effectDate)).forEach(entry -> relListsAfterCompareModel.addDeleteReportingRel((DynamicObject)entry.getValue()));
        }
        return relListsAfterCompareModel;
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        logger.info("ProjectRoleChangeOp endOperationTransaction sendMsg start, oldMainDutyProRoleId={}, newMainDutyProRoleBoId={}", (Object)this.oldMainDutyProRoleBoId, (Object)this.newMainDutyProRoleBoId);
        try {
            ProRoleMsgService.getInstance().sendProRoleChgMsg(this.msgMapList, this.newMainDutyProRoleBoId, this.oldMainDutyProRoleBoId, this.effDate);
        }
        catch (Exception exception) {
            logger.error("ProjectRoleChangeOp.endOperationTransaction sendProRoleChgMsg is Exception", (Object)e);
        }
        logger.info("ProjectRoleChangeOp endOperationTransaction sendMsg end.");
    }
}

