/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.projectrole;

import com.alibaba.fastjson.JSON;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hrmp.hbpm.business.application.impl.projectrole.ProjectRoleApplicationImpl;
import kd.hrmp.hbpm.business.application.projectrole.IProjectRoleApplication;
import kd.hrmp.hbpm.business.domain.repository.position.CommonQueryRepository;
import kd.hrmp.hbpm.business.service.projectrole.ProjRoleChangeEvent;
import kd.hrmp.hbpm.business.utils.DynamicObjectBuilder;
import kd.hrmp.hbpm.business.utils.PRJRoleUtils;
import kd.hrmp.hbpm.business.utils.WorkRoleNewHisUtils;
import kd.hrmp.hbpm.common.constants.ProjectRoleConstants;
import kd.hrmp.hbpm.opplugin.web.validate.ProjectRoleDisableValidator;

public class ProjectRoleDisableOp
extends HRDataBaseOp
implements ProjectRoleConstants {
    IProjectRoleApplication projectRoleApplication = ProjectRoleApplicationImpl.getInstance();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ProjectRoleDisableValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        Set ProjectRoleIdSet = Arrays.stream(e.getDataEntities()).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] projectRoles = CommonQueryRepository.getInstance().loadDyById("hbpm_projectroles", ProjectRoleIdSet);
        List enableProRoleList = Arrays.stream(projectRoles).filter(dyn -> "1".equals(dyn.getString("enable"))).collect(Collectors.toList());
        List projectRoleList = WorkRoleNewHisUtils.getDy4ChgProp(enableProRoleList);
        DynamicObject disableInfo = this.getDisableInfo();
        projectRoleList.forEach(dy -> PRJRoleUtils.changeDy4Disable((DynamicObject)dy, (DynamicObject)disableInfo));
        HisResponse hisResponse = this.projectRoleApplication.disableProjectRoles(projectRoleList);
        Long changeReasonId = (Long)disableInfo.get("changereason");
        ProjRoleChangeEvent.handleChangeEvent((HisResponse)hisResponse, (long)CHANGE_TYPE_DISABLE, (long)CHANGE_OPERATE_DISABLE, (Long)PR_CHANGE_SCENE_DISABLE, (Long)(changeReasonId == null ? Long.valueOf(0L) : changeReasonId));
    }

    private DynamicObject getDisableInfo() {
        Map variables = this.getOption().getVariables();
        String changeType = variables.getOrDefault("changetype", "0");
        String changeReason = variables.getOrDefault("changereason", "0");
        String changeDesc = variables.getOrDefault("changedesc", "");
        ILocaleString changeDescLocaleString = (ILocaleString)JSON.parseObject((String)changeDesc, LocaleString.class);
        String effDtStr = variables.getOrDefault("bsed", "");
        Date effDt = "".equals(effDtStr) ? new Date() : Date.from(Instant.ofEpochMilli(Long.parseLong(effDtStr)));
        return this.getDisableInfo(changeDescLocaleString, Long.parseLong(changeType), Long.parseLong(changeReason), effDt);
    }

    private DynamicObject getDisableInfo(ILocaleString changeDesc, long changeType, long changeReason, Date effDt) {
        return DynamicObjectBuilder.createBuilder((String)"hbpm_disableinfo").set("changetype", (Object)changeType).set("changereason", (Object)changeReason).set("changedesc", (Object)changeDesc).set("bsed", (Object)effDt).build();
    }
}

