/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.projectrole;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.api.EnumResponseCode;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hrmp.hbpm.business.application.impl.projectrole.ProjectRoleApplicationImpl;
import kd.hrmp.hbpm.business.application.projectrole.IProjectRoleApplication;
import kd.hrmp.hbpm.business.domain.repository.position.CommonQueryRepository;
import kd.hrmp.hbpm.business.service.projectrole.ProjRoleChangeEvent;
import kd.hrmp.hbpm.business.utils.PRJRoleUtils;
import kd.hrmp.hbpm.common.constants.ProjectRoleConstants;
import kd.hrmp.hbpm.opplugin.web.validate.ProjectRoleEnableValidator;

public class ProjectRoleEnableOp
extends HRDataBaseOp
implements ProjectRoleConstants {
    private static final Log LOGGER = LogFactory.getLog(ProjectRoleEnableOp.class);
    private static final HRBaseServiceHelper HBPM_PROJECTROLESDETAIL = new HRBaseServiceHelper("hbpm_projectrolesdetail");
    IProjectRoleApplication projectRoleApplication = ProjectRoleApplicationImpl.getInstance();
    private List<Map<String, Object>> msgMapList;

    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        evt.getFieldKeys().add("enable");
        evt.getFieldKeys().add("projteam");
        evt.getFieldKeys().add("superroles");
        evt.getFieldKeys().add("sourcevid");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new ProjectRoleEnableValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        Set ProjectRoleIdSet = Arrays.stream(dataEntities).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] projectRoles = CommonQueryRepository.getInstance().loadDyById("hbpm_projectroles", ProjectRoleIdSet);
        if (projectRoles != null && projectRoles.length > 0) {
            ArrayList<DynamicObject> projectRoleList = new ArrayList<DynamicObject>(dataEntities.length);
            for (DynamicObject dynamicObject : projectRoles) {
                DynamicObject newDy = HBPM_PROJECTROLESDETAIL.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)newDy);
                newDy.set("enable", (Object)"1");
                newDy.set("bsed", (Object)new Date());
                projectRoleList.add(newDy);
            }
            HisResponse response = this.projectRoleApplication.enableProjectRoles(projectRoleList);
            if (response == null || !EnumResponseCode.SUCCESS.getCode().equals(response.getCode())) {
                throw new KDBizException(response != null ? response.getErrorMessage() : "error");
            }
            this.msgMapList = new ArrayList<Map<String, Object>>(16);
            PRJRoleUtils.assemblyProRoleMsgParams(Arrays.asList(((VersionChangeRespData)response.getData()).getNewDynamicObjects()), this.msgMapList);
            ProjRoleChangeEvent.handleChangeEvent((HisResponse)response, (long)CHANGE_TYPE_INFO, (long)CHANGE_OPERATE_INFO, (Long)PR_CHANGE_SCENE_UPDATE, (Long)0L);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        super.afterExecuteOperationTransaction(args);
        LOGGER.info("ProjectRoleEnableOp afterExecuteOperationTransaction sendMsg start, msgMapList:{}", this.msgMapList);
        try {
            PRJRoleUtils.proRoleUpSendMsg(this.msgMapList, null);
        }
        catch (Exception exception) {
            LOGGER.error("ProjectRoleEnableOp.afterExecuteOperationTransaction sendProRoleChgMsg is Exception", (Throwable)exception);
        }
        LOGGER.info("ProjectRoleEnableOp afterExecuteOperationTransaction sendMsg end.");
    }
}

