/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.projectrole;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hrmp.hbpm.business.application.impl.projectrole.ProjectRoleApplicationImpl;
import kd.hrmp.hbpm.business.application.projectrole.IProjectRoleApplication;
import kd.hrmp.hbpm.business.service.projectrole.ProjRoleChangeEvent;
import kd.hrmp.hbpm.business.service.projectrole.ProjectRoleValidateHelper;
import kd.hrmp.hbpm.business.utils.PRJRoleUtils;
import kd.hrmp.hbpm.business.utils.WorkRoleNewHisUtils;
import kd.hrmp.hbpm.common.constants.ProjectRoleConstants;
import kd.hrmp.hbpm.opplugin.web.validate.RolePlanImportValidator;

public class ProjectRoleImportByRolePlanOp
extends HRDataBaseOp
implements ProjectRoleConstants {
    private static final Log logger = LogFactory.getLog(ProjectRoleImportByRolePlanOp.class);
    private static IProjectRoleApplication projectRoleApplication = ProjectRoleApplicationImpl.getInstance();
    private List<DynamicObject> hisRetDataList;
    private Map<String, Object> mainDutyProRoleMap;
    private List<Map<String, Object>> msgMapList;

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new RolePlanImportValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject rolePlanPageModel = e.getDataEntities()[0];
        DynamicObjectCollection roleEntry = rolePlanPageModel.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)roleEntry)) {
            return;
        }
        List<DynamicObject> projectRoleList = roleEntry.stream().map(PRJRoleUtils::createProjectRoleFromPlanRole).peek(projectRole -> PRJRoleUtils.changeProjectRoleByRolePlanPage((DynamicObject)projectRole, (DynamicObject)rolePlanPageModel)).collect(Collectors.toList());
        Long orgId = rolePlanPageModel.getLong("projteam.org.id");
        for (DynamicObject dyn : projectRoleList) {
            dyn.set("org", (Object)orgId);
            PRJRoleUtils.setRoleTypeDynByMainHead((DynamicObject)dyn, (Boolean)Boolean.FALSE);
        }
        WorkRoleNewHisUtils.setNewId(projectRoleList);
        boolean continueFlag = true;
        Optional<DynamicObject> newMainRoleOptional = projectRoleList.stream().filter(PRJRoleUtils::isDuty).findAny();
        if (newMainRoleOptional.isPresent()) {
            continueFlag = ProjectRoleValidateHelper.alterConfigWindow((DynamicObject)newMainRoleOptional.get(), (OperateOption)this.operateOption);
        }
        if (!continueFlag) {
            e.setCancelOperation(true);
            return;
        }
        if (newMainRoleOptional.isPresent()) {
            DynamicObject mainRole = newMainRoleOptional.get();
            long projTeam = rolePlanPageModel.getLong("projteam.parentorg.id");
            mainRole.set("superroles", (Object)this.getSuperRole(projTeam));
            PRJRoleUtils.setRoleTypeDynByMainHead((DynamicObject)mainRole, (Boolean)Boolean.TRUE);
            this.hisRetDataList = new ArrayList<DynamicObject>(16);
            this.mainDutyProRoleMap = new HashMap<String, Object>(16);
            PRJRoleUtils.newMainRoleWithSubstituteMainRole((DynamicObject)mainRole, (Long)CHANGE_OPERATE_NEW, this.hisRetDataList, this.mainDutyProRoleMap);
            this.msgMapList = new ArrayList<Map<String, Object>>(16);
            PRJRoleUtils.assemblyProRoleMsgParams(this.hisRetDataList, this.msgMapList);
            List noMainRoleList = projectRoleList.stream().filter(dy -> !PRJRoleUtils.isDuty((DynamicObject)dy)).peek(dy -> dy.set("superroles", (Object)mainRole)).collect(Collectors.toList());
            HisResponse hisResponse = projectRoleApplication.saveProjectRoles(noMainRoleList);
            ProjRoleChangeEvent.getInstance().handleProRoleEventByHisResponse(hisResponse, PR_CHANGE_SCENE_ADD, PR_CHANGE_TYPE_ADD, CHANGE_OPERATE_NEW, 0L);
        } else {
            long prjTeamId = ((DynamicObject)projectRoleList.get(0)).getLong("projteam.id");
            Map teamIdVsMainRoleMap = PRJRoleUtils.getTeamIdVsMainRoleMap(Collections.singletonList(prjTeamId));
            DynamicObject mainRole = (DynamicObject)teamIdVsMainRoleMap.get(prjTeamId);
            projectRoleList.forEach(dy -> dy.set("superroles", (Object)mainRole));
            HisResponse hisResponse = projectRoleApplication.saveProjectRoles(projectRoleList);
            ProjRoleChangeEvent.getInstance().handleProRoleEventByHisResponse(hisResponse, PR_CHANGE_SCENE_ADD, PR_CHANGE_TYPE_ADD, CHANGE_OPERATE_NEW, 0L);
        }
    }

    private Long getSuperRole(Long projTeam) {
        if (projTeam == 0L) {
            return 0L;
        }
        HRBaseServiceHelper workRoleHelper = new HRBaseServiceHelper("hbpm_workroleshr");
        QFilter prjFilter = new QFilter("adminorg", "=", (Object)projTeam);
        QFilter dutyFilter = new QFilter("mainpeoincharge", "=", (Object)"1");
        DynamicObject[] projectRole = workRoleHelper.queryOriginalArray("id", new QFilter[]{prjFilter, dutyFilter, FILTER_IS_CURRENT_VERSION, Q_FILTER_ENABLE});
        if (projectRole.length == 1) {
            return projectRole[0].getLong("id");
        }
        return 0L;
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        PRJRoleUtils.proRoleUpSendMsg(this.msgMapList, this.mainDutyProRoleMap);
    }
}

