/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.projectrole;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hrmp.hbpm.business.application.impl.projectrole.ProjectRoleApplicationImpl;
import kd.hrmp.hbpm.business.application.projectrole.IProjectRoleApplication;
import kd.hrmp.hbpm.business.service.projectrole.ProjRoleChangeEvent;
import kd.hrmp.hbpm.business.service.projectrole.ProjectRoleValidateHelper;
import kd.hrmp.hbpm.business.utils.PRJRoleUtils;
import kd.hrmp.hbpm.business.utils.WorkRoleNewHisUtils;
import kd.hrmp.hbpm.common.constants.ProjectRoleConstants;
import kd.hrmp.hbpm.opplugin.web.validate.projectrole.ProRoleSaveValidator;

public class ProjectRoleSaveOp
extends HRDataBaseOp
implements ProjectRoleConstants {
    private static final Log logger = LogFactory.getLog(ProjectRoleSaveOp.class);
    IProjectRoleApplication projectRoleApplication = ProjectRoleApplicationImpl.getInstance();
    private List<DynamicObject> hisRetDataList;
    private List<Map<String, Object>> msgMapList;
    private Map<String, Object> mainDutyProRoleMap;

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new ProRoleSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        WorkRoleNewHisUtils.setNewId(Arrays.asList(e.getDataEntities()));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject projectRole = e.getDataEntities()[0];
        if (projectRole == null) {
            return;
        }
        boolean continueFlag = true;
        if (PRJRoleUtils.isDutyOnlyWithPage((DynamicObject)projectRole)) {
            continueFlag = ProjectRoleValidateHelper.alterConfigWindow((DynamicObject)projectRole, (OperateOption)this.operateOption);
        }
        if (!continueFlag) {
            e.setCancelOperation(true);
            return;
        }
        projectRole.set("org", (Object)projectRole.getLong("projteam.org.id"));
        if (PRJRoleUtils.isDuty((DynamicObject)projectRole)) {
            this.mainDutyProRoleMap = new HashMap<String, Object>(16);
            this.hisRetDataList = new ArrayList<DynamicObject>(16);
            PRJRoleUtils.newMainRoleWithSubstituteMainRole((DynamicObject)projectRole, (Long)CHANGE_OPERATE_NEW, this.hisRetDataList, this.mainDutyProRoleMap);
            this.msgMapList = new ArrayList<Map<String, Object>>(16);
            PRJRoleUtils.assemblyProRoleMsgParams(this.hisRetDataList, this.msgMapList);
        } else {
            HisResponse hisResponse = this.projectRoleApplication.saveProjectRoles(Arrays.asList(e.getDataEntities()));
            long changeReasonId = projectRole.getLong("changereason.id");
            ProjRoleChangeEvent.getInstance().handleProRoleEventByHisResponse(hisResponse, PR_CHANGE_SCENE_ADD, PR_CHANGE_TYPE_ADD, CHANGE_OPERATE_NEW, changeReasonId);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        PRJRoleUtils.proRoleUpSendMsg(this.msgMapList, this.mainDutyProRoleMap);
    }
}

