/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.projectrole.basedata;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.interaction.InteractionConfirmResult;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.entity.operate.interaction.KDInteractionException;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hrmp.hbpm.common.constants.ProjectRoleConstants;
import kd.hrmp.hbpm.opplugin.web.projectrole.basedata.RolePlanValidate;

public class RolePlanOperateOp
extends HRDataBaseOp
implements ProjectRoleConstants {
    private static final String OP_KEY = "kd.hrmp.hbpm.opplugin.web.projectrole.basedata.RolePlanOperateOp";
    private static final HRBaseServiceHelper helper = new HRBaseServiceHelper("hbpm_roleplan");

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("isdefaultplan");
        e.getFieldKeys().add("otclassify");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new RolePlanValidate());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        boolean b;
        String operationKey = e.getOperationKey();
        if (HRStringUtils.equals((String)"enable", (String)operationKey) && !(b = this.enableValidateV2(dataEntities = e.getDataEntities()))) {
            e.setCancelOperation(true);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey = e.getOperationKey();
        if (HRStringUtils.equals((String)"save", (String)operationKey)) {
            DynamicObject dataEntity = e.getDataEntities()[0];
            this.saveOperate(dataEntity);
        }
    }

    private void saveOperate(DynamicObject dataEntity) {
        QFilter filter;
        DynamicObject plan;
        if (dataEntity.getBoolean("isdefaultplan") && (plan = helper.queryOne("id,name,isdefaultplan", filter = new QFilter("enable", "=", (Object)"1").and(new QFilter("otclassify", "=", (Object)1020L)).and(new QFilter("isdefaultplan", "=", (Object)"1")).and(new QFilter("id", "!=", (Object)dataEntity.getLong("id"))))) != null) {
            plan.set("isdefaultplan", (Object)false);
            helper.updateOne(plan);
        }
    }

    private boolean enableValidateV2(DynamicObject[] dataEntities) {
        String confirmResultString = this.operateOption.getVariableValue("interactionconfirmresult", "");
        InteractionConfirmResult intConfirmResult = InteractionConfirmResult.fromJsonString((String)confirmResultString);
        if (intConfirmResult.getResults().containsKey(OP_KEY)) {
            String result = (String)intConfirmResult.getResults().get(OP_KEY);
            if ("Yes".equals(result)) {
                QFilter filter = new QFilter("isdefaultplan", "=", (Object)"1").and(new QFilter("otclassify", "=", (Object)1020L)).and(Q_FILTER_ENABLE);
                DynamicObject dynamicObjectsDb = helper.loadDynamicObject(filter);
                dynamicObjectsDb.set("isdefaultplan", (Object)"0");
                helper.updateOne(dynamicObjectsDb);
                return true;
            }
            return false;
        }
        Set ids = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        QFilter filter = new QFilter("isdefaultplan", "=", (Object)"1").and(new QFilter("otclassify", "=", (Object)1020L)).and(Q_FILTER_ENABLE);
        QFilter filterPage = new QFilter("id", "in", ids);
        DynamicObject[] dynamicObjectsPage = helper.loadDynamicObjectArray(new QFilter[]{filterPage});
        DynamicObject[] dynamicObjectsDb = helper.loadDynamicObjectArray(new QFilter[]{filter});
        long countPage = Arrays.stream(dynamicObjectsPage).filter(s -> s.getBoolean("isdefaultplan")).count();
        if (countPage > 1L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u80fd\u540c\u65f6\u542f\u7528\u591a\u4e2a\u9ed8\u8ba4\u89d2\u8272\u65b9\u6848\u3002", (String)"RolePlanOperateOp_1", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]));
        }
        if (countPage == 1L && dynamicObjectsDb.length == 1) {
            InteractionContext interactionContext = new InteractionContext();
            StringBuilder message = new StringBuilder();
            String msg = MessageFormat.format(ResManager.loadKDString((String)"\u76ee\u524d\u5df2\u5b58\u5728\u9ed8\u8ba4\u65b9\u6848\u201c{0}\u201d\uff0c\u662f\u5426\u628a\u5b83\u8bbe\u7f6e\u4e3a\u975e\u9ed8\u8ba4\u65b9\u6848\uff1f", (String)"RolePlanOperateOp_2", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]), dynamicObjectsDb[0].getString("name"));
            message.append(msg);
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setMessage(message.toString());
            errorInfo.setLevel(ErrorLevel.Warning);
            interactionContext.addOperateInfo(errorInfo);
            throw new KDInteractionException(OP_KEY, interactionContext);
        }
        return true;
    }
}

