/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.validate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.hbpm.business.domain.repository.position.PositionBillQueryRepository;
import kd.hrmp.hbpm.business.service.position.PositionServiceHelper;

public class PositionImptRuleNumberValidator
extends HRDataBaseValidator {
    private static final Log LOGGER = LogFactory.getLog(PositionImptRuleNumberValidator.class);

    public PositionImptRuleNumberValidator() {
    }

    public PositionImptRuleNumberValidator(List<ExtendedDataEntity> falseDataentity) {
    }

    public void validate() {
        ExtendedDataEntity[] dataArr = this.getDataEntities();
        ArrayList<ExtendedDataEntity> dataList = new ArrayList<ExtendedDataEntity>(Arrays.asList(dataArr));
        long startTime = System.currentTimeMillis();
        HashMap generateIds = (HashMap)HRAppCache.get((String)"hbpm").get("IMPORT_NEW_GENERATE_NUMBERS" + RequestContext.get().getTraceId(), Map.class);
        if (generateIds == null) {
            generateIds = new HashMap();
        }
        ArrayList<DynamicObject> positionBills = new ArrayList<DynamicObject>(dataList.size());
        for (ExtendedDataEntity data : dataList) {
            DynamicObject position = data.getDataEntity();
            if (position.getDynamicObject("adminorg") == null) continue;
            DynamicObject positionBill = PositionServiceHelper.transferPositionToPositionBill((DynamicObject)position);
            positionBills.add(positionBill);
        }
        List ruleNumbers = CodeRuleServiceHelper.getNumbers((String)"homs_positionbill", positionBills);
        HashMap ruleNumberToPositionBillMap = new HashMap();
        for (int i = 0; i < ruleNumbers.size(); ++i) {
            String ruleNumber = (String)ruleNumbers.get(i);
            if (!HRStringUtils.isNotEmpty((String)ruleNumber)) continue;
            ruleNumberToPositionBillMap.put(ruleNumber, positionBills.get(i));
        }
        DynamicObject[] existPosByNumber = PositionBillQueryRepository.getInstance().queryPositionDataByNumbers(new ArrayList(ruleNumberToPositionBillMap.keySet()));
        List dbExistNumber = Arrays.stream(existPosByNumber).map(dyn -> dyn.getString("number")).collect(Collectors.toList());
        int index = 0;
        for (ExtendedDataEntity data : dataList) {
            String errMsg;
            DynamicObject position = data.getDataEntity();
            if (position.getDynamicObject("adminorg") == null) continue;
            String fillNumber = position.getString("number");
            String ruleNumber = (String)ruleNumbers.get(index);
            ++index;
            if (!StringUtils.isEmpty((CharSequence)ruleNumber)) {
                position.set("number", (Object)ruleNumber);
                if (!generateIds.containsKey(fillNumber)) {
                    if (HRStringUtils.equals((String)ruleNumber, (String)fillNumber) && !dbExistNumber.contains(ruleNumber)) continue;
                    errMsg = ResManager.loadKDString((String)"\u5df2\u542f\u7528\u81ea\u52a8\u7f16\u7801\u89c4\u5219\uff0c\u5c97\u4f4d\u7f16\u7801\u4e0d\u9700\u8981\u586b\u5199\u3002", (String)"PositinRuleNumberImportPlugin_2", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
                    this.addFatalErrorMessage(data, errMsg);
                    continue;
                }
                if (!dbExistNumber.contains(ruleNumber)) continue;
                errMsg = ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219\u751f\u6210\u7f16\u7801\u201c%s\u201d\u5df2\u5b58\u5728\u3002", (String)"PositinRuleNumberImportPlugin_3", (String)"hrmp-hbpm-opplugin", (Object[])new Object[]{ruleNumber});
                this.addFatalErrorMessage(data, errMsg);
                position.set("number", (Object)"");
                continue;
            }
            if (generateIds.containsKey(fillNumber)) {
                errMsg = ResManager.loadKDString((String)"\u6ca1\u6709\u542f\u7528\u81ea\u52a8\u7f16\u7801\u89c4\u5219\uff0c\u8bf7\u586b\u5199\u5c97\u4f4d\u7f16\u7801\u3002", (String)"PositinRuleNumberImportPlugin_1", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(data, errMsg);
                continue;
            }
            if (!ruleNumbers.contains(fillNumber)) continue;
            errMsg = ResManager.loadKDString((String)"\u4e0e\u7f16\u7801\u89c4\u5219\u751f\u6210\u7f16\u7801\u201c%s\u201d\u91cd\u590d\u3002", (String)"PositinRuleNumberImportPlugin_4", (String)"hrmp-hbpm-opplugin", (Object[])new Object[]{fillNumber});
            this.addFatalErrorMessage(data, errMsg);
            position.set("number", (Object)"");
        }
        HRAppCache.get((String)"hbpm").put("IMPORT_NEW_GENERATE_NUMBERS" + RequestContext.get().getTraceId(), new HashMap(16));
        ArrayList<DynamicObject> falseBills = new ArrayList<DynamicObject>();
        for (ExtendedDataEntity falseData : this.getFalseExtendedDataEntity()) {
            DynamicObject pos = falseData.getDataEntity();
            String number = pos.getString("number");
            if (!ruleNumbers.contains(number) || dbExistNumber.contains(number)) continue;
            DynamicObject bill = (DynamicObject)ruleNumberToPositionBillMap.get(number);
            bill.set("number", (Object)number);
            falseBills.add(bill);
            ruleNumbers.remove(number);
        }
        PositionServiceHelper.recycleNumber((DynamicObject[])falseBills.toArray(new DynamicObject[0]));
        LOGGER.info(String.format("PositionImptRuleNumberValidator base valiate time : %s", System.currentTimeMillis() - startTime));
    }

    private List<ExtendedDataEntity> getFalseExtendedDataEntity() {
        ValidateResultCollection resultCollection = this.getValidateContext().getValidateResults();
        if (resultCollection == null) {
            return new ArrayList<ExtendedDataEntity>();
        }
        HashSet falseSet = this.getValidateContext().getValidateResults().getErrorDataIndexs();
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        if (!CollectionUtils.isEmpty((Collection)falseSet)) {
            ArrayList<ExtendedDataEntity> falseList = new ArrayList<ExtendedDataEntity>(falseSet.size());
            falseSet.forEach(id -> falseList.add(extendedDataEntities[id]));
            return falseList;
        }
        return new ArrayList<ExtendedDataEntity>();
    }
}

