/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.validate;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.hbpm.business.utils.PositionUtils;
import kd.hrmp.hbpm.opplugin.web.validate.basedata.PositionValidatorServiceHelper;

public class PositionImptValidator
extends HRDataBaseValidator {
    private static final Log LOGGER = LogFactory.getLog(PositionImptValidator.class);
    public PositionValidatorServiceHelper positionValidatorServiceHelper = new PositionValidatorServiceHelper();
    public ExtendedDataEntity[] dataEntities;
    private boolean validateBsedLessAssignDate;
    private boolean isInit;

    public PositionImptValidator() {
    }

    public PositionImptValidator(boolean validateBsedLessAssignDate) {
        this.validateBsedLessAssignDate = validateBsedLessAssignDate;
    }

    public PositionImptValidator(boolean validateBsedLessAssignDate, boolean isInit) {
        this.validateBsedLessAssignDate = validateBsedLessAssignDate;
        this.isInit = isInit;
    }

    public void validate() {
        this.dataEntities = this.getDataEntities();
        if (ArrayUtils.isEmpty((Object[])this.dataEntities)) {
            return;
        }
        long startTime = System.currentTimeMillis();
        String importtype = (String)this.getOption().getVariables().get("importtype");
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject position = data.getDataEntity();
            this.validateBsedAbility(position, data);
            if (this.isInit) continue;
            this.validateEstablishAbility(position, data);
            this.validateCountryAndCity(position, data);
            this.validateOrgNotNull(position, data);
            this.validateOther(position, data);
            if (HRStringUtils.equals((String)"new", (String)importtype)) {
                this.validateAdminorgNotNull(position, data);
            }
            this.validateAdminorgIsvirtual(position, data);
        }
        this.validatePostProcessor(this.dataEntities);
        LOGGER.info(String.format("PositionImptValidator base valiate time : %s", System.currentTimeMillis() - startTime));
    }

    protected void validateOther(DynamicObject position, ExtendedDataEntity data) {
    }

    protected void validatePostProcessor(ExtendedDataEntity[] dataEntities) {
    }

    private void validateBsedAbility(DynamicObject position, ExtendedDataEntity data) {
        String msg = this.positionValidatorServiceHelper.validateBSed(position.getDate("bsed"));
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            this.addFatalErrorMessage(data, msg);
            return;
        }
        if (this.validateBsedLessAssignDate && StringUtils.isNotEmpty((CharSequence)(msg = this.positionValidatorServiceHelper.validateBSedLessAssignDate(position.getDate("bsed"), PositionUtils.getCurrentDate())))) {
            this.addFatalErrorMessage(data, msg);
        }
        if (this.isInit) {
            return;
        }
        String message = this.positionValidatorServiceHelper.validateBSedAndAdminOrgEstablishmentDate(position.getDate("bsed"), position.getDynamicObject("adminorg"));
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            this.addFatalErrorMessage(data, message);
        }
    }

    private void validateEstablishAbility(DynamicObject position, ExtendedDataEntity data) {
        String message;
        String msg = this.positionValidatorServiceHelper.validateBSedAndEstablishmentDate(position.getDate("bsed"), position.getDate("establishmentdate"));
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            this.addFatalErrorMessage(data, msg);
        }
        if (StringUtils.isNotEmpty((CharSequence)(message = this.positionValidatorServiceHelper.validateEstablishLessParentFirstBsed(position.getDate("bsed"), position.getDynamicObject("parent"))))) {
            this.addFatalErrorMessage(data, message);
        }
    }

    private void validateCountryAndCity(DynamicObject position, ExtendedDataEntity data) {
        String msg = this.positionValidatorServiceHelper.validateCountryAndCity(position.getDynamicObject("countryregion"), position.getDynamicObject("city"));
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            this.addFatalErrorMessage(data, msg);
        }
    }

    private void validateOrgNotNull(DynamicObject position, ExtendedDataEntity data) {
        DynamicObject adminOrg = position.getDynamicObject("adminorg");
        if (HRObjectUtils.isEmpty((Object)adminOrg)) {
            return;
        }
        String msg = this.positionValidatorServiceHelper.validateOrgNotNull(adminOrg.getDynamicObject("org"));
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            this.addFatalErrorMessage(data, msg);
        }
    }

    private void validateAdminorgNotNull(DynamicObject position, ExtendedDataEntity data) {
        DynamicObject adminOrg = position.getDynamicObject("adminorg");
        String msg = this.positionValidatorServiceHelper.validateAdminorgNotNull(adminOrg);
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            this.addFatalErrorMessage(data, msg);
        }
    }

    private void validateAdminorgIsvirtual(DynamicObject position, ExtendedDataEntity data) {
        DynamicObject adminOrg = position.getDynamicObject("adminorg");
        if (adminOrg == null) {
            return;
        }
        String msg = this.positionValidatorServiceHelper.validateAdminorgIsvirtual(adminOrg);
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            this.addFatalErrorMessage(data, msg);
        }
    }
}

