/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.validate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hrmp.hbpm.business.utils.PositionPermissionUtil;
import kd.hrmp.hbpm.opplugin.web.validate.PositionImptValidator;

public class PositionSaveImptValidator
extends PositionImptValidator {
    public PositionSaveImptValidator() {
    }

    public PositionSaveImptValidator(List<ExtendedDataEntity> falseDataentity) {
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    protected void validateOther(DynamicObject position, ExtendedDataEntity data) {
        this.validateParentIsComplete(position, data);
        this.validateEntryEntity(position, data);
    }

    @Override
    protected void validatePostProcessor(ExtendedDataEntity[] dataEntities) {
        AuthorizedOrgResult hasPermAdminOrg = PositionPermissionUtil.getHasPermAdminOrg((long)RequestContext.get().getCurrUserId());
        HasPermOrgResult posHasPermOrg = PositionPermissionUtil.getPosHasPermOrg();
        for (ExtendedDataEntity data : dataEntities) {
            DynamicObject position = data.getDataEntity();
            this.validateOrgHasPerm(position, data, posHasPermOrg);
            String adminOrgHasPermMsg = this.positionValidatorServiceHelper.validateAdminOrgHasPerm(position.getDynamicObject("adminorg"), hasPermAdminOrg);
            if (!StringUtils.isNotEmpty((CharSequence)adminOrgHasPermMsg)) continue;
            this.addFatalErrorMessage(data, adminOrgHasPermMsg);
        }
    }

    private void validateParentIsComplete(DynamicObject position, ExtendedDataEntity data) {
        DynamicObject parent = position.getDynamicObject("parent");
        if (HRObjectUtils.isEmpty((Object)parent)) {
            return;
        }
        String errorMessage = this.positionValidatorServiceHelper.validateParentIsComplete(parent);
        if (StringUtils.isNotEmpty((CharSequence)errorMessage)) {
            this.addFatalErrorMessage(data, errorMessage);
        }
    }

    private void validateEntryEntity(DynamicObject position, ExtendedDataEntity data) {
        DynamicObjectCollection entryEntity = position.getDynamicObjectCollection("entryentity");
        if (entryEntity != null && entryEntity.size() > 0) {
            ArrayList reportTypeIds = Lists.newArrayListWithExpectedSize((int)8);
            for (DynamicObject entity : entryEntity) {
                String targetWorkRoleUniqueMessage;
                String targetWorkRoleMessage;
                String reportTypeMessage;
                DynamicObject reportType = entity.getDynamicObject("reporttype");
                DynamicObject targetWorkRole = entity.getDynamicObject("targetworkrole");
                if (!HRObjectUtils.isEmpty((Object)targetWorkRole) && StringUtils.isNotEmpty((CharSequence)(reportTypeMessage = this.positionValidatorServiceHelper.validateMustForReportType(reportType)))) {
                    this.addFatalErrorMessage(data, reportTypeMessage);
                }
                if (!HRObjectUtils.isEmpty((Object)reportType) && StringUtils.isNotEmpty((CharSequence)(targetWorkRoleMessage = this.positionValidatorServiceHelper.validateMustForTargetWorkRole(targetWorkRole)))) {
                    this.addFatalErrorMessage(data, targetWorkRoleMessage);
                }
                if (!StringUtils.isNotEmpty((CharSequence)(targetWorkRoleUniqueMessage = this.positionValidatorServiceHelper.validateReportTypeUnique(reportTypeIds, reportType)))) continue;
                this.addFatalErrorMessage(data, targetWorkRoleUniqueMessage);
            }
        }
    }

    private void validateOrgHasPerm(DynamicObject position, ExtendedDataEntity data, HasPermOrgResult posHasPermOrg) {
        DynamicObject adminOrg = position.getDynamicObject("adminorg");
        if (HRObjectUtils.isEmpty((Object)adminOrg)) {
            return;
        }
        String msg = this.positionValidatorServiceHelper.validateOrgHasPerm(adminOrg.getDynamicObject("org"), posHasPermOrg);
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            this.addFatalErrorMessage(data, msg);
        }
    }
}

