/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.validate;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.utils.PositionPermissionUtil;
import kd.hrmp.hbpm.business.utils.PositionUtils;
import kd.hrmp.hbpm.opplugin.web.validate.PositionImptValidator;

public class PositionUpdateImptValidator
extends PositionImptValidator {
    @Override
    protected void validateOther(DynamicObject position, ExtendedDataEntity data) {
        this.validateParentIsComplete(position, data);
        this.validateIsInitComplete(position, data);
    }

    private void validateParentIsComplete(DynamicObject position, ExtendedDataEntity data) {
        DynamicObject parent = position.getDynamicObject("parent");
        if (HRObjectUtils.isEmpty((Object)parent)) {
            return;
        }
        String errorMessage = this.positionValidatorServiceHelper.validateParentIsComplete(parent);
        if (StringUtils.isNotEmpty((CharSequence)errorMessage)) {
            this.addFatalErrorMessage(data, errorMessage);
        }
    }

    private void validateIsInitComplete(DynamicObject position, ExtendedDataEntity data) {
        if (HRObjectUtils.isEmpty((Object)position)) {
            return;
        }
        String errorMessage = this.positionValidatorServiceHelper.validateIsInitComplete(position);
        if (StringUtils.isNotEmpty((CharSequence)errorMessage)) {
            this.addFatalErrorMessage(data, errorMessage);
        }
    }

    @Override
    protected void validatePostProcessor(ExtendedDataEntity[] dataEntities) {
        HashSet numbers = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        Arrays.stream(dataEntities).forEach(data -> numbers.add(data.getDataEntity().getString("number")));
        Object[] positionInfo = PositionQueryRepository.getInstance().queryPositionByNumbers((Set)numbers);
        if (PositionUtils.isArrayEmpty((Object[])positionInfo).booleanValue()) {
            return;
        }
        AuthorizedOrgResult hasPermAdminOrg = PositionPermissionUtil.getHasPermAdminOrg((long)RequestContext.get().getCurrUserId());
        Map<String, DynamicObject> numberAndAdminOrgMap = Arrays.stream(positionInfo).collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy));
        HasPermOrgResult posHasPermOrg = PositionPermissionUtil.getPosHasPermOrg();
        for (ExtendedDataEntity data2 : dataEntities) {
            String adminOrgHasPermMsg;
            DynamicObject position = data2.getDataEntity();
            this.validateOrgHasPerm(position, data2, posHasPermOrg);
            String msg = this.positionValidatorServiceHelper.validateAdminOrgIsChange(position, numberAndAdminOrgMap);
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                this.addFatalErrorMessage(data2, msg);
            }
            if (StringUtils.isNotEmpty((CharSequence)(adminOrgHasPermMsg = this.positionValidatorServiceHelper.validateAdminOrgHasPerm(position.getDynamicObject("adminorg"), hasPermAdminOrg)))) {
                this.addFatalErrorMessage(data2, adminOrgHasPermMsg);
            }
            if (!StringUtils.isNotEmpty((CharSequence)(msg = this.positionValidatorServiceHelper.validatePositionTypeIsEmpty(position)))) continue;
            this.addFatalErrorMessage(data2, msg);
        }
    }

    private void validateOrgHasPerm(DynamicObject position, ExtendedDataEntity data, HasPermOrgResult posHasPermOrg) {
        DynamicObject adminOrg = position.getDynamicObject("adminorg");
        if (HRObjectUtils.isEmpty((Object)adminOrg)) {
            return;
        }
        String msg = this.positionValidatorServiceHelper.validateOrgHasPerm(adminOrg.getDynamicObject("org"), posHasPermOrg);
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            this.addFatalErrorMessage(data, msg);
        }
    }
}

