/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.validate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.hbpm.business.service.projectrole.ProjectRoleBusiness;
import kd.hrmp.hbpm.business.service.projectrole.ProjectRoleValidateHelper;
import kd.hrmp.hbpm.common.constants.ProjectRoleConstants;

public class ProjectRoleDisableValidator
extends HRDataBaseValidator
implements ProjectRoleConstants {
    private static final Log LOG = LogFactory.getLog(ProjectRoleDisableValidator.class);
    private static final String SYSTEM_TYPE = "hrmp-hbpm-opplugin";

    public void validate() {
        super.validate();
        Map variables = this.getOption().getVariables();
        String effDateStr = (String)variables.get("bsed");
        Date effDate = new Date(Long.parseLong(effDateStr));
        effDate = ProjectRoleValidateHelper.formatDateYYYYMMDD((Date)effDate);
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashMap dynMap = new HashMap(dataEntities.length);
        HashMap idDynMap = new HashMap(dataEntities.length);
        ArrayList ids = new ArrayList(dataEntities.length);
        HashMap idNameMap = new HashMap(dataEntities.length);
        Arrays.stream(dataEntities).forEach(dyn -> {
            DynamicObject dy = dyn.getDataEntity();
            dynMap.put(dy.getString("number"), dyn);
            idDynMap.put(dy.getLong("id"), dyn);
            ids.add(dy.getLong("id"));
            idNameMap.put(dy.getLong("id"), dy.getString("name"));
        });
        DynamicObject[] proRoleDynArr = ProjectRoleValidateHelper.PR_SERVICE_HELPER.queryOriginalArray("id,name,number,isdutypers,bsed,enable,projteam.name", new QFilter[]{new QFilter("id", "in", ids)});
        HashSet enableRoleIdSet = new HashSet(proRoleDynArr.length);
        HashMap proRoleMap = new HashMap(proRoleDynArr.length);
        Arrays.stream(proRoleDynArr).forEach(dyn -> {
            Long id = dyn.getLong("id");
            if (HRStringUtils.equals((String)"1", (String)dyn.getString("enable"))) {
                enableRoleIdSet.add(id);
            }
            proRoleMap.put(id, dyn);
        });
        String curEffDateMsg = ResManager.loadKDString((String)"%1$s\uff1a\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u751f\u6548\u65e5\u671f%2$s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectRoleDisableValidator_4", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        Map proRoleCoopLastEffDynMap = ProjectRoleValidateHelper.getProRoleCoopLastEffDynMap(enableRoleIdSet);
        for (ExtendedDataEntity data : dataEntities) {
            Long id = data.getDataEntity().getLong("id");
            if (!enableRoleIdSet.contains(id)) {
                this.addFatalErrorMessage(data, ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"ProjectRoleDisableValidator_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                continue;
            }
            DynamicObject proRoleDyDb = (DynamicObject)proRoleMap.get(id);
            Date bseDate = proRoleDyDb.getDate("bsed");
            bseDate = ProjectRoleValidateHelper.getProRoleAndCoopLastDate((Map)proRoleCoopLastEffDynMap, (Long)id, (Date)bseDate);
            if (!effDate.before(bseDate = ProjectRoleValidateHelper.formatDateYYYYMMDD((Date)bseDate)) || !HRStringUtils.equals((String)"1", (String)proRoleDyDb.getString("enable"))) continue;
            this.addErrorMessage(data, String.format(Locale.ROOT, curEffDateMsg, proRoleDyDb.getString("number"), HRDateTimeUtils.format((Date)bseDate, (String)"yyyy-MM-dd")));
        }
        List oneLeaders = ProjectRoleValidateHelper.disableCheckOneLeader((DynamicObject[])proRoleDynArr);
        String oneLeadersClues = ResManager.loadKDString((String)"%1$s\uff0c\u9879\u76ee\u56e2\u961f\u4e2d\u81f3\u5c11\u9700\u8981\u6709\u4e00\u4e2a\u4e3b\u8d1f\u8d23\u89d2\u8272\u3002", (String)"ProjectRoleDisableValidator_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        for (String oneLeader : oneLeaders) {
            String[] split = oneLeader.split(";");
            this.addErrorMessage((ExtendedDataEntity)dynMap.get(split[0]), String.format(Locale.ROOT, oneLeadersClues, split[1]));
        }
        List slaves = ProjectRoleValidateHelper.disableCheckSlave((DynamicObject[])proRoleDynArr);
        String slavesClues = ResManager.loadKDString((String)"%s\uff1a\u6709\u542f\u7528\u7684\u4e0b\u7ea7\u89d2\u8272\u65f6\u65e0\u6cd5\u7981\u7528\u3002", (String)"ProjectRoleDisableValidator_2", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        for (String slave : slaves) {
            String[] split = slave.split(";");
            this.addErrorMessage((ExtendedDataEntity)dynMap.get(split[0]), String.format(Locale.ROOT, slavesClues, split[1]));
        }
        Map idTipMap = ProjectRoleBusiness.validProjectRoleMembers(idNameMap);
        idTipMap.forEach((k, v) -> this.addErrorMessage((ExtendedDataEntity)idDynMap.get(k), v.toString()));
        LOG.info("ProjectRoleDisableValidator.validate end===");
    }
}

