/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.validate;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.hbpm.common.constants.ProjectRoleConstants;

public class ProjectRoleEnableValidator
extends HRDataBaseValidator
implements ProjectRoleConstants {
    private static final HRBaseServiceHelper HBPM_PROJECTROLESDETAIL = new HRBaseServiceHelper("hbpm_projectrolesdetail");

    public void validate() {
        this.checkSelfDisable();
        this.checkProjTeam();
        this.checkName();
        this.checkParentEnable();
    }

    private void checkSelfDisable() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String msg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e3a\u5df2\u542f\u7528\u72b6\u6001\u3002", (String)"ProjectRoleEnableValidator_0", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
        Arrays.stream(dataEntities).forEach(pjtExt -> {
            String enable = pjtExt.getDataEntity().getString("enable");
            if ("1".equals(enable)) {
                this.addErrorMessage((ExtendedDataEntity)pjtExt, msg);
            }
        });
    }

    private void checkProjTeam() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String msg = ResManager.loadKDString((String)"\u9879\u76ee\u89d2\u8272\u7684\u6240\u5c5e\u9879\u76ee\u56e2\u961f\u5fc5\u987b\u662f\u5df2\u542f\u7528\u72b6\u6001\uff0c\u8bf7\u5148\u542f\u7528\u9879\u76ee\u56e2\u961f\u3002", (String)"ProjectRoleEnableValidator_1", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
        Arrays.stream(dataEntities).forEach(pjtExt -> {
            String enable = pjtExt.getDataEntity().getString("projteam.enable");
            if (!"1".equals(enable)) {
                this.addErrorMessage((ExtendedDataEntity)pjtExt, msg);
            }
        });
    }

    private void checkName() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String msg = ResManager.loadKDString((String)"\u89d2\u8272\u540d\u79f0\u5728\u8be5\u9879\u76ee\u56e2\u961f\u5df2\u542f\u7528\u7684\u89d2\u8272\u4e2d\u5df2\u5b58\u5728\u3002", (String)"ProjectRoleEnableValidator_2", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
        Map<Long, List<ExtendedDataEntity>> map = Arrays.stream(dataEntities).collect(Collectors.groupingBy(val -> val.getDataEntity().getLong("projteam.id")));
        HashSet<Long> teamIds = new HashSet<Long>(dataEntities.length);
        HashSet<String> roleNames = new HashSet<String>(dataEntities.length);
        HashSet<ExtendedDataEntity> errorDatas = new HashSet<ExtendedDataEntity>(dataEntities.length / 2 + 1);
        for (Map.Entry<Long, List<ExtendedDataEntity>> entry : map.entrySet()) {
            List<ExtendedDataEntity> list = entry.getValue();
            HashSet<String> names = new HashSet<String>(list.size());
            for (ExtendedDataEntity dataEntity : list) {
                DynamicObject dy = dataEntity.getDataEntity();
                String name = dy.getString("name");
                if (names.add(name)) {
                    roleNames.add(name);
                    teamIds.add(entry.getKey());
                    continue;
                }
                this.addErrorMessage(dataEntity, msg);
                errorDatas.add(dataEntity);
            }
        }
        if (!teamIds.isEmpty()) {
            QFilter qFilter = new QFilter("name", "in", roleNames).and("projteam.id", "in", teamIds).and("enable", "in", (Object)"1").and("iscurrentversion", "=", (Object)"1").and("datastatus", "=", (Object)"1");
            DynamicObject[] dys = HBPM_PROJECTROLESDETAIL.query("name,projteam", new QFilter[]{qFilter});
            if (dys == null || dys.length == 0) {
                return;
            }
            Map<String, List<DynamicObject>> nameMap = Arrays.stream(dys).collect(Collectors.groupingBy(val -> this.nameFormat((DynamicObject)val)));
            for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObject dy;
                List<DynamicObject> list;
                if (errorDatas.contains(dataEntity) || (list = nameMap.get(this.nameFormat(dy = dataEntity.getDataEntity()))) == null) continue;
                for (DynamicObject dyn : list) {
                    if (dyn.getLong("id") == dy.getLong("id")) continue;
                    this.addErrorMessage(dataEntity, msg);
                }
            }
        }
    }

    private String nameFormat(DynamicObject dy) {
        return dy.getLong("projteam.id") + "-" + dy.getString("name");
    }

    private void checkParentEnable() {
        HashSet<Long> ids = new HashSet<Long>(this.dataEntities.length);
        ArrayList<ExtendedDataEntity> hasParentDatas = new ArrayList<ExtendedDataEntity>(this.dataEntities.length);
        HashSet<Long> parentIds = new HashSet<Long>(this.dataEntities.length);
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject dy = extendedDataEntity.getDataEntity();
            ids.add(dy.getLong("id"));
            long supRoleId = dy.getLong("superroles.id");
            if (supRoleId <= 0L) continue;
            hasParentDatas.add(extendedDataEntity);
            parentIds.add(supRoleId);
        }
        if (!parentIds.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u8be5\u6570\u636e\u7684\u4e0a\u7ea7\u89d2\u8272\u662f\u5df2\u7981\u7528\u72b6\u6001\uff0c\u8bf7\u5148\u542f\u7528\u4e0a\u7ea7\u89d2\u8272\u3002", (String)"ProjectRoleEnableValidator_3", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
            Set parentIdsNotCur = parentIds.stream().filter(val -> !ids.contains(val)).collect(Collectors.toSet());
            DynamicObject[] dys = HBPM_PROJECTROLESDETAIL.query("id", new QFilter[]{new QFilter("id", "in", parentIdsNotCur).and("enable", "=", (Object)"1")});
            Set<Object> enableIds = dys != null && dys.length > 0 ? Arrays.stream(dys).map(val -> val.getLong("id")).collect(Collectors.toSet()) : new HashSet(hasParentDatas.size());
            List<ExtendedDataEntity> sortList = this.sortFromHighToLow(this.dataEntities);
            for (ExtendedDataEntity extendedDataEntity : sortList) {
                long roleId = extendedDataEntity.getDataEntity().getLong("superroles.id");
                if (roleId <= 0L || enableIds.contains(roleId)) {
                    enableIds.add(extendedDataEntity.getDataEntity().getLong("id"));
                    continue;
                }
                this.addErrorMessage(extendedDataEntity, msg);
            }
        }
    }

    private List<ExtendedDataEntity> sortFromHighToLow(ExtendedDataEntity[] list) {
        HashMap idToDataMap = Maps.newHashMapWithExpectedSize((int)list.length);
        HashMap idToParentMap = Maps.newHashMapWithExpectedSize((int)list.length);
        for (ExtendedDataEntity extendedDataEntity : list) {
            DynamicObject dy = extendedDataEntity.getDataEntity();
            Long id = dy.getLong("id");
            idToParentMap.put(id, dy.getLong("superroles.id"));
            idToDataMap.put(id, extendedDataEntity);
        }
        ArrayList sortDataList = Lists.newArrayListWithExpectedSize((int)list.length);
        for (ExtendedDataEntity extendedDataEntity : list) {
            long id = extendedDataEntity.getDataEntity().getLong("id");
            this.addDataFromHighToLow(id, idToParentMap, idToDataMap, sortDataList);
        }
        return sortDataList;
    }

    private void addDataFromHighToLow(long roleId, Map<Long, Long> idToParentMap, Map<Long, ExtendedDataEntity> idToDataMap, List<ExtendedDataEntity> sortDataList) {
        ExtendedDataEntity data = idToDataMap.get(roleId);
        Long parent = idToParentMap.get(roleId);
        ExtendedDataEntity parentData = idToDataMap.get(parent);
        if (parentData == null || sortDataList.contains(parentData)) {
            if (!sortDataList.contains(data)) {
                sortDataList.add(data);
            }
            return;
        }
        this.addDataFromHighToLow(parent, idToParentMap, idToDataMap, sortDataList);
        if (!sortDataList.contains(data)) {
            sortDataList.add(data);
        }
    }
}

