/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.validate.basedata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class NameValidator
extends HRDataBaseValidator {
    private static final String CREATE_ORG_ID = "createorg.id";
    private static final String DIVISION = "||";
    private String multiBdKey;
    private String checkKey;

    public NameValidator(String checkKey, String multiBdKey) {
        Objects.requireNonNull(multiBdKey);
        Objects.requireNonNull(checkKey);
        this.multiBdKey = multiBdKey;
        this.checkKey = checkKey;
    }

    public void validate() {
        switch (this.getOperateKey()) {
            case "save": 
            case "enable": {
                this.valid();
                break;
            }
        }
    }

    private void valid() {
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        ArrayList<ExtendedDataEntity> memoryCheckedExDyList = new ArrayList<ExtendedDataEntity>(extendedDataEntities.length);
        HashMap<String, Set> nameVsBdIdsMap = new HashMap<String, Set>(extendedDataEntities.length);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            Set checkedMultiBdIds;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String name = dataEntity.getString(this.checkKey) + DIVISION + dataEntity.getString(CREATE_ORG_ID);
            if (!StringUtils.isNotBlank((CharSequence)name)) continue;
            Set<Long> curMultiBdIds = this.getSetFromDynamicObjectCollection(dataEntity.getDynamicObjectCollection(this.multiBdKey));
            if (this.isJoint(curMultiBdIds, checkedMultiBdIds = (Set)nameVsBdIdsMap.get(name))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u201c\u521b\u5efa\u7ec4\u7ec7\u201d\u201c\u6240\u5c5e\u7ec4\u7ec7\u56e2\u961f\u201d\u201c\u540d\u79f0\u201d \u7684\u7ec4\u5408\u503c\u91cd\u590d\uff0c\u8bf7\u81f3\u5c11\u4fee\u6539\u4e00\u9879\u3002", (String)"NameValidator_1", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]));
                continue;
            }
            memoryCheckedExDyList.add(extendedDataEntity);
            nameVsBdIdsMap.computeIfAbsent(name, key -> new HashSet()).addAll(curMultiBdIds);
        }
        QFilter nameFilter = new QFilter(this.checkKey, "in", Arrays.stream(extendedDataEntities).map(item -> item.getDataEntity().getString(this.checkKey)).collect(Collectors.toSet()));
        String entityName = this.getDataEntities()[0].getDataEntity().getDataEntityType().getName();
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityName);
        DynamicObject[] query = hrBaseServiceHelper.query("createorg.id," + this.checkKey + "," + this.multiBdKey, new QFilter[]{nameFilter});
        nameVsBdIdsMap.clear();
        Set checkedMemoryIdSet = memoryCheckedExDyList.stream().map(ExtendedDataEntity::getDataEntity).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        for (DynamicObject dynamicObject : query) {
            if (checkedMemoryIdSet.contains(dynamicObject.getLong("id"))) continue;
            nameVsBdIdsMap.computeIfAbsent(dynamicObject.getString(this.checkKey) + DIVISION + dynamicObject.getString(CREATE_ORG_ID), key -> new HashSet()).addAll(this.getSetFromDynamicObjectCollection(dynamicObject.getDynamicObjectCollection(this.multiBdKey)));
        }
        for (ExtendedDataEntity extendedDataEntity : memoryCheckedExDyList) {
            Set checkedMultiBdIds;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String name = dataEntity.getString(this.checkKey) + DIVISION + dataEntity.getString(CREATE_ORG_ID);
            Set<Long> curMultiBdIds = this.getSetFromDynamicObjectCollection(dataEntity.getDynamicObjectCollection(this.multiBdKey));
            if (!this.isJoint(curMultiBdIds, checkedMultiBdIds = (Set)nameVsBdIdsMap.get(name))) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u201c\u521b\u5efa\u7ec4\u7ec7\u201d\u201c\u6240\u5c5e\u7ec4\u7ec7\u56e2\u961f\u201d\u201c\u540d\u79f0\u201d \u7684\u7ec4\u5408\u503c\u91cd\u590d\uff0c\u8bf7\u81f3\u5c11\u4fee\u6539\u4e00\u9879\u3002", (String)"NameValidator_1", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean isJoint(Set<Long> set1, Set<Long> set2) {
        if (CollectionUtils.isEmpty(set1) || CollectionUtils.isEmpty(set2)) {
            return false;
        }
        return set1.stream().anyMatch(set2::contains);
    }

    private Set<Long> getSetFromDynamicObjectCollection(DynamicObjectCollection dynamicObjectCollection) {
        if (!CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return dynamicObjectCollection.stream().map(dy -> dy.getLong("fbasedataid.id")).filter(id -> id != 0L).collect(Collectors.toSet());
        }
        return new HashSet<Long>();
    }
}

