/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.validate.basedata;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.hbpm.business.utils.PositionUtils;
import kd.hrmp.hbpm.opplugin.web.validate.basedata.PositionValidatorServiceHelper;

public class PositionBaseValidator
extends HRDataBaseValidator {
    public PositionValidatorServiceHelper positionValidatorServiceHelper = new PositionValidatorServiceHelper();

    public void validate() {
        Object[] dataEntities = this.getDataEntities();
        if (ArrayUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        for (Object dataEntity : dataEntities) {
            DynamicObject position = dataEntity.getDataEntity();
            this.validateBSedAbility(position, (ExtendedDataEntity)dataEntity);
            this.validateCountryAndCity(position, (ExtendedDataEntity)dataEntity);
            this.validateOrgNotNull(position, (ExtendedDataEntity)dataEntity);
            this.validateAdminOrgAbility(position, (ExtendedDataEntity)dataEntity);
        }
    }

    private void validateAdminOrgAbility(DynamicObject position, ExtendedDataEntity dataEntity) {
        if (this.positionValidatorServiceHelper.isSkip(Thread.currentThread().getStackTrace()[1].getMethodName())) {
            return;
        }
        if ("0".equals(position.getString("enable")) && "2".equals(position.getString("initdatasource"))) {
            return;
        }
        String msg = this.positionValidatorServiceHelper.validateAdminOrgEnable(position.getDynamicObject("adminorg"));
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            this.addFatalErrorMessage(dataEntity, msg);
        }
    }

    private void validateBSedAbility(DynamicObject position, ExtendedDataEntity data) {
        String msg = this.positionValidatorServiceHelper.validateBSedLessAssignDate(position.getDate("bsed"), PositionUtils.getCurrentDate());
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            this.addFatalErrorMessage(data, msg);
        }
        if (StringUtils.isNotEmpty((CharSequence)(msg = this.positionValidatorServiceHelper.validateBSedAndAdminOrgEstablishmentDate(position.getDate("bsed"), position.getDynamicObject("adminorg"))))) {
            this.addFatalErrorMessage(data, msg);
        }
        if (StringUtils.isNotEmpty((CharSequence)(msg = this.positionValidatorServiceHelper.validateBSedAndEstablishmentDate(position.getDate("bsed"), position.getDate("establishmentdate"))))) {
            this.addFatalErrorMessage(data, msg);
        }
        if (StringUtils.isNotEmpty((CharSequence)(msg = this.positionValidatorServiceHelper.validateEstablishLessParentFirstBsed(position.getDate("bsed"), position.getDynamicObject("parent"))))) {
            this.addFatalErrorMessage(data, msg);
        }
    }

    private void validateCountryAndCity(DynamicObject position, ExtendedDataEntity data) {
        String msg = this.positionValidatorServiceHelper.validateCountryAndCity(position.getDynamicObject("countryregion"), position.getDynamicObject("city"));
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            this.addFatalErrorMessage(data, msg);
        }
    }

    private void validateOrgNotNull(DynamicObject position, ExtendedDataEntity data) {
        String msg = this.positionValidatorServiceHelper.validateOrgNotNull(position.getDynamicObject("org"));
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            this.addFatalErrorMessage(data, msg);
        }
    }
}

