/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.validate.basedata;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.utils.PositionUtils;
import kd.hrmp.hbpm.opplugin.web.validate.basedata.PositionValidatorServiceHelper;

public class PositionUpdateValidator
extends HRDataBaseValidator {
    public PositionValidatorServiceHelper positionValidatorServiceHelper = new PositionValidatorServiceHelper();

    public void validate() {
        Object[] dataEntities = this.getDataEntities();
        if (ArrayUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        HashSet numbers = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        Arrays.stream(dataEntities).forEach(data -> numbers.add(data.getDataEntity().getString("number")));
        Object[] positionInfo = PositionQueryRepository.getInstance().queryPositionByNumbers((Set)numbers);
        if (PositionUtils.isArrayEmpty((Object[])positionInfo).booleanValue()) {
            return;
        }
        Map<String, DynamicObject> oldPositionMap = Arrays.stream(positionInfo).collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy));
        for (Object dataEntity : dataEntities) {
            DynamicObject position = dataEntity.getDataEntity();
            this.validateParentIsModifier(position, oldPositionMap, (ExtendedDataEntity)dataEntity);
            this.validateBaseInfoIsModifier(position, oldPositionMap, (ExtendedDataEntity)dataEntity);
        }
    }

    private void validateParentIsModifier(DynamicObject position, Map<String, DynamicObject> oldPositionMap, ExtendedDataEntity data) {
        String msg;
        DynamicObject oldPositionBillFromDB = oldPositionMap.get(position.getString("number"));
        if (oldPositionBillFromDB == null) {
            return;
        }
        Date bsedFromDB = oldPositionBillFromDB.getDate("bsed");
        if (position.getDate("bsed").before(bsedFromDB) && StringUtils.isNotEmpty((CharSequence)(msg = this.positionValidatorServiceHelper.validateParentIsModifier(position.getLong("parent.id"), oldPositionBillFromDB.getLong("parent.id"), bsedFromDB)))) {
            this.addFatalErrorMessage(data, msg);
        }
        Date firstBsed = oldPositionBillFromDB.getDate("firstbsed");
        String msg2 = this.positionValidatorServiceHelper.validateFirstBsed(position.getDate("bsed"), firstBsed);
        if (StringUtils.isNotEmpty((CharSequence)msg2)) {
            this.addFatalErrorMessage(data, msg2);
        }
    }

    private void validateBaseInfoIsModifier(DynamicObject position, Map<String, DynamicObject> oldPositionMap, ExtendedDataEntity data) {
        String msg = this.positionValidatorServiceHelper.validateAdminOrgIsChange(position, oldPositionMap);
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            this.addFatalErrorMessage(data, msg);
        }
        if (StringUtils.isNotEmpty((CharSequence)(msg = this.positionValidatorServiceHelper.validatePositionTypeIsEmpty(position)))) {
            this.addFatalErrorMessage(data, msg);
        }
        if (StringUtils.isNotEmpty((CharSequence)(msg = this.positionValidatorServiceHelper.validateEstabDateIsChange(position, oldPositionMap)))) {
            this.addFatalErrorMessage(data, msg);
        }
    }
}

