/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.validate.basedata;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbpm.business.ext.PositionSkipValidateServiceExt;

public class PositionValidatorServiceHelper {
    public String validateNumberUnique(Long id, String name, Set<Long> hisVersionIdFromDB) {
        String msg = null;
        if (CollectionUtils.isEmpty(hisVersionIdFromDB)) {
            return null;
        }
        if (!hisVersionIdFromDB.contains(id)) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff1a\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionValidatorServiceHelper_6", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]), name);
        }
        return msg;
    }

    public String validateParentPositionEnable(DynamicObject parentPosition, String name) {
        String msg = null;
        if (HRObjectUtils.isEmpty((Object)parentPosition)) {
            return null;
        }
        if (!"1".equals(parentPosition.getString("enable"))) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff1a\u4e0a\u7ea7\u5c97\u4f4d\u5df2\u7981\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionValidatorServiceHelper_1", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]), name);
        }
        return msg;
    }

    public String validateParentIsComplete(DynamicObject parentPosition) {
        String msg = null;
        if (ObjectUtils.isEmpty((Object)parentPosition)) {
            return null;
        }
        if (!"2".equals(parentPosition.getString("initstatus"))) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0a\u7ea7\u5c97\u4f4d\u4e0d\u5b58\u5728\u3002", (String)"PositionValidatorServiceHelper_14", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]), new Object[0]);
        }
        return msg;
    }

    public String validateIsInitComplete(DynamicObject position) {
        String msg = null;
        if (ObjectUtils.isEmpty((Object)position)) {
            return null;
        }
        if (!"2".equals(position.getString("initstatus"))) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c\u5c97\u4f4d\u7f16\u7801\u201d\u65e0\u6548\u3002", (String)"PositionValidatorServiceHelper_17", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]), new Object[0]);
        }
        return msg;
    }

    public String validateParentIsModifier(long parentId, long parentIdFromOld, Date bsedFromDB) {
        String msg = null;
        if (parentId != parentIdFromOld) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u53d8\u66f4\u4e0a\u7ea7\u5c97\u4f4d\uff0c\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u7248\u672c\u751f\u6548\u65e5\u671f\u201c%s\u201d\u3002", (String)"PositionValidatorServiceHelper_10", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]), DateUtils.formatDate((Date)bsedFromDB, (Object[])new Object[]{"yyyy-MM-dd"}));
        }
        return msg;
    }

    public String validateFirstBsed(Date bsed, Date firstBsed) {
        String msg = null;
        if (bsed.before(firstBsed)) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5c97\u4f4d\u6700\u65e9\u751f\u6548\u65e5\u671f\uff0c\u6700\u65e9\u751f\u6548\u65e5\u671f\u201c%s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionValidatorServiceHelper_28", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]), DateUtils.formatDate((Date)firstBsed, (Object[])new Object[]{"yyyy-MM-dd"}));
        }
        return msg;
    }

    public String validateBSedAndEstablishmentDate(Date bSed, Date establishmentDate) {
        String msg = null;
        if (HRDateTimeUtils.truncateDate((Date)establishmentDate) == null) {
            return null;
        }
        if (HRDateTimeUtils.truncateDate((Date)bSed).before(HRDateTimeUtils.truncateDate((Date)establishmentDate))) {
            msg = ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u8bbe\u7acb\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionValidatorServiceHelper_2", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
        }
        return msg;
    }

    public String validateBSedAndAdminOrgEstablishmentDate(Date bSed, DynamicObject adminOrg) {
        String msg = null;
        if (ObjectUtils.isEmpty((Object)adminOrg)) {
            return null;
        }
        Date adminOrgDate = adminOrg.getDate("establishmentdate");
        if (HRDateTimeUtils.truncateDate((Date)bSed).before(HRDateTimeUtils.truncateDate((Date)adminOrgDate))) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u6240\u5728\u7ec4\u7ec7\u7684\u6210\u7acb\u65e5\u671f\u201c%s\u201d\u3002", (String)"PositionValidatorServiceHelper_9", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]), HRDateTimeUtils.format((Date)adminOrgDate, (String)"yyyy-MM-dd"));
        }
        return msg;
    }

    public String validateOrgNotNull(DynamicObject orgDy) {
        String msg = null;
        if (HRObjectUtils.isEmpty((Object)orgDy)) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionValidatorServiceHelper_19", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]), new Object[0]);
        }
        return msg;
    }

    public String validateOrgHasPerm(DynamicObject orgDy, HasPermOrgResult posHasPermOrg) {
        String msg = null;
        if (posHasPermOrg.hasAllOrgPerm()) {
            return null;
        }
        if (HRObjectUtils.isEmpty((Object)orgDy)) {
            return null;
        }
        List hasPermOrgs = posHasPermOrg.getHasPermOrgs();
        if (CollectionUtils.isEmpty((Collection)hasPermOrgs) || !hasPermOrgs.contains(orgDy.getLong("id"))) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e3b\u7ba1\u8d23\u4efb\u5355\u4f4d\u4e0d\u5728\u6743\u9650\u8303\u56f4\u5185\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionValidatorServiceHelper_20", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]), new Object[0]);
        }
        return msg;
    }

    public String validateBSedLessAssignDate(Date bSed, Date assignDate) {
        String msg = null;
        if (HRDateTimeUtils.truncateDate((Date)bSed).after(HRDateTimeUtils.truncateDate((Date)assignDate))) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionValidatorServiceHelper_8", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]), new Object[0]);
        }
        return msg;
    }

    public String validateBSed(Date bSed) {
        String msg = null;
        if (bSed == null) {
            msg = ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PositionValidatorServiceHelper_37", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
        }
        return msg;
    }

    public String validateMustForReportType(DynamicObject reportType) {
        String msg = null;
        if (ObjectUtils.isEmpty((Object)reportType)) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u534f\u4f5c\u7c7b\u578b\u201d\u3002", (String)"PositionValidatorServiceHelper_3", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]), new Object[0]);
        }
        return msg;
    }

    public String validateMustForTargetWorkRole(DynamicObject targetWorkRole) {
        String msg = null;
        if (ObjectUtils.isEmpty((Object)targetWorkRole)) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u534f\u4f5c\u5c97\u4f4d/\u89d2\u8272\u540d\u79f0\u201d\u3002", (String)"PositionValidatorServiceHelper_4", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]), new Object[0]);
        }
        return msg;
    }

    public String validateTargetWorkRoleEnable(DynamicObject targetWorkRole, DynamicObject reportType) {
        String msg = null;
        if (ObjectUtils.isEmpty((Object)targetWorkRole)) {
            return null;
        }
        if (ObjectUtils.isEmpty((Object)reportType)) {
            return null;
        }
        if (!"1".equals(targetWorkRole.getString("enable"))) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u5bf9\u5e94\u7684\u534f\u4f5c\u5c97\u4f4d/\u89d2\u8272\u201c%2$s\u201d\u5df2\u7981\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionValidatorServiceHelper_5", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]), reportType.getString("name"), targetWorkRole.getString("name"));
        }
        return msg;
    }

    public String validateReportTypeUnique(List<Long> reportTypeIds, DynamicObject reportType) {
        String msg = null;
        if (HRObjectUtils.isEmpty((Object)reportType)) {
            return null;
        }
        if (reportTypeIds.contains(reportType.getLong("id"))) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u534f\u4f5c\u7c7b\u578b\u201c%s\u201d\u6709\u591a\u6761\u4e00\u6837\u7684\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionValidatorServiceHelper_18", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]), reportType.getString("name"));
        }
        reportTypeIds.add(reportType.getLong("id"));
        return msg;
    }

    public String validateCountryAndCity(DynamicObject country, DynamicObject city) {
        String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a\u4e0e\u6240\u5728\u57ce\u5e02\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionValidatorServiceHelper_11", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]), new Object[0]);
        if (HRObjectUtils.isEmpty((Object)country) && HRObjectUtils.isEmpty((Object)city)) {
            return null;
        }
        if (HRObjectUtils.isEmpty((Object)country) && !HRObjectUtils.isEmpty((Object)city)) {
            return msg;
        }
        if (!HRObjectUtils.isEmpty((Object)country) && !HRObjectUtils.isEmpty((Object)city) && country.getLong("id") != city.getLong("country.id")) {
            return msg;
        }
        return null;
    }

    public String validateEstablishLessParentFirstBsed(Date establish, DynamicObject parent) {
        String msg = null;
        if (HRObjectUtils.isEmpty((Object)parent)) {
            return null;
        }
        Date date = parent.getDate("firstbsed");
        if (date == null) {
            date = parent.getDate("establishmentdate");
        }
        if (establish.before(date)) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u4e0a\u7ea7\u5c97\u4f4d\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionValidatorServiceHelper_12", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]), new Object[0]);
        }
        return msg;
    }

    public String validateAdminOrgIsChange(DynamicObject position, Map<String, DynamicObject> numberAndAdminOrgMap) {
        String msg = null;
        DynamicObject dynamicObject = numberAndAdminOrgMap.get(position.getString("number"));
        if (HRObjectUtils.isEmpty((Object)dynamicObject)) {
            return null;
        }
        if (position.getLong("adminorg.id") != dynamicObject.getLong("adminorg.id")) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5c97\u4f4d\u4e0d\u80fd\u53d8\u66f4\u201c\u884c\u653f\u7ec4\u7ec7\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionValidatorServiceHelper_13", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]), new Object[0]);
        }
        return msg;
    }

    public String validateAdminOrgHasPerm(DynamicObject adminOrg, AuthorizedOrgResult hasPermAdminOrg) {
        List perms;
        String msg = null;
        if (HRObjectUtils.isEmpty((Object)adminOrg)) {
            return null;
        }
        if (Objects.nonNull(hasPermAdminOrg) && !hasPermAdminOrg.isHasAllOrgPerm() && (CollectionUtils.isEmpty((Collection)(perms = hasPermAdminOrg.getHasPermOrgs())) || !perms.contains(adminOrg.getLong("id")))) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6ca1\u6709\u884c\u653f\u7ec4\u7ec7\u6743\u9650\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionValidatorServiceHelper_15", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]), new Object[0]);
        }
        return msg;
    }

    public String validatePositionTypeIsEmpty(DynamicObject position) {
        String msg = null;
        if (position.getLong("positiontype.id") == 0L) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5c97\u4f4d\u7c7b\u578b\u201d\u3002", (String)"PositionValidatorServiceHelper_16", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]), new Object[0]);
        }
        return msg;
    }

    public String validateEstabDateIsChange(DynamicObject position, Map<String, DynamicObject> numberAndAdminOrgMap) {
        String msg = null;
        DynamicObject dynamicObject = numberAndAdminOrgMap.get(position.getString("number"));
        if (HRObjectUtils.isEmpty((Object)dynamicObject)) {
            return null;
        }
        if (!dynamicObject.getDate("establishmentdate").equals(position.getDate("establishmentdate"))) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5c97\u4f4d\u4e0d\u80fd\u53d8\u66f4\u201c\u8bbe\u7acb\u65e5\u671f\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionValidatorServiceHelper_21", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]), new Object[0]);
        }
        return msg;
    }

    public String validateAdminOrgEnable(DynamicObject adminOrg) {
        String msg = null;
        if (HRObjectUtils.isEmpty((Object)adminOrg)) {
            return null;
        }
        if ("0".equals(adminOrg.getString("enable"))) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u5df2\u7981\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionValidatorServiceHelper_22", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]), new Object[0]);
        }
        return msg;
    }

    public String validateBsledChanged(Date bsled1, Date bsled2) {
        String msg = null;
        if (!HRDateTimeUtils.dayEquals((Date)HRDateTimeUtils.truncateDate((Date)bsled1), (Date)HRDateTimeUtils.truncateDate((Date)bsled2))) {
            msg = ResManager.loadKDString((String)"\u6570\u636e\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\u3002", (String)"PositionValidatorServiceHelper_27", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
        }
        return msg;
    }

    public String validateDataEnable(DynamicObject dyn) {
        String msg = null;
        if (!HRStringUtils.equals((String)dyn.getString("enable"), (String)"1")) {
            msg = ResManager.loadKDString((String)"\u53ea\u80fd\u4fee\u8ba2\u5df2\u542f\u7528\u7684\u6570\u636e\u3002", (String)"PositionValidatorServiceHelper_25", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
        }
        return msg;
    }

    public String validateDataStatus(DynamicObject dyn) {
        String msg = null;
        if (!Lists.newArrayList((Object[])new String[]{"1", "2"}).contains(dyn.getString("datastatus"))) {
            msg = ResManager.loadKDString((String)"\u53ea\u80fd\u4fee\u8ba2\u5df2\u5931\u6548\u3001\u751f\u6548\u4e2d\u7684\u7248\u672c\u6570\u636e\u3002", (String)"PositionValidatorServiceHelper_26", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
        }
        return msg;
    }

    public String validateFirstEffdtLessOldDate(Date newFirstEffdt, Date oldFirstEffdt) {
        String msg = null;
        if (HRDateTimeUtils.truncateDate((Date)newFirstEffdt).after(HRDateTimeUtils.truncateDate((Date)oldFirstEffdt))) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6700\u65e9\u751f\u6548\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u5c97\u4f4d\u6700\u65e9\u751f\u6548\u65e5\u671f\u201c%s\u201d\u3002", (String)"PositionValidatorServiceHelper_23", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]), HRDateTimeUtils.format((Date)oldFirstEffdt, (String)"yyyy-MM-dd"));
        }
        return msg;
    }

    public String validateEstablishmentdtLessOldDate(Date newEstablishmentd, Date oldEstablishmentd) {
        String msg = null;
        if (HRDateTimeUtils.truncateDate((Date)newEstablishmentd).after(HRDateTimeUtils.truncateDate((Date)oldEstablishmentd))) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8bbe\u7acb\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u5c97\u4f4d\u8bbe\u7acb\u65e5\u671f\u201c%s\u201d\u3002", (String)"PositionValidatorServiceHelper_24", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]), HRDateTimeUtils.format((Date)oldEstablishmentd, (String)"yyyy-MM-dd"));
        }
        return msg;
    }

    public String validateAdminorgNotNull(DynamicObject adminorg) {
        String msg = null;
        if (HRObjectUtils.isEmpty((Object)adminorg)) {
            msg = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u884c\u653f\u7ec4\u7ec7\u201d\u3002", (String)"PositionValidatorServiceHelper_29", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
        }
        return msg;
    }

    public String validateAdminorgIsvirtual(DynamicObject adminorg) {
        String msg = null;
        if ("true".equals(adminorg.getString("isvirtualorg"))) {
            msg = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u4e3a\u865a\u62df\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionValidatorServiceHelper_31", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
        }
        return msg;
    }

    public String validateIsCurrentversion(DynamicObject dyn) {
        String msg = null;
        String datastatus = dyn.getString("datastatus");
        if (!HRStringUtils.equals((String)"2", (String)datastatus)) {
            msg = ResManager.loadKDString((String)"\u4e0d\u80fd\u4fee\u8ba2\u5f53\u524d\u751f\u6548\u4e2d\u7248\u672c\u6570\u636e\uff0c\u8bf7\u901a\u8fc7\u66f4\u65b0\u5bfc\u5165\u5904\u7406\u3002", (String)"PositionValidatorServiceHelper_30", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
        }
        return msg;
    }

    public String validateHasFutureVersion() {
        return ResManager.loadKDString((String)"\u5c97\u4f4d\u5df2\u5b58\u5728\u5f85\u751f\u6548\u7248\u672c\uff0c\u751f\u6548\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"PositionValidatorServiceHelper_36", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
    }

    public String validateHasFutureFailVersion() {
        return ResManager.loadKDString((String)"\u5c97\u4f4d\u5b58\u5728\u751f\u6548\u5931\u8d25\u7684\u5f85\u751f\u6548\u7248\u672c\uff0c\u8bf7\u5148\u5904\u7406\u3002", (String)"PositionValidatorServiceHelper_33", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
    }

    public String validatePositionEnable(DynamicObject dyn) {
        String msg = null;
        if (!HRStringUtils.equals((String)dyn.getString("enable"), (String)"1")) {
            msg = ResManager.loadKDString((String)"\u5c97\u4f4d\u5df2\u7981\u7528\uff0c\u4e0d\u80fd\u5bfc\u5165\u534f\u4f5c\u5173\u7cfb\u3002", (String)"PositionValidatorServiceHelper_32", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
        }
        return msg;
    }

    public String validateBsedLessEffectingVersionBsed(Date bsed, Date effectingVersionBsed) {
        String msg = null;
        if (HRDateTimeUtils.truncateDate((Date)bsed).before(HRDateTimeUtils.truncateDate((Date)effectingVersionBsed))) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u751f\u6548\u4e2d\u7248\u672c\u7684\u751f\u6548\u65e5\u671f\u201c%s\u201d\u3002", (String)"PositionValidatorServiceHelper_35", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]), HRDateTimeUtils.format((Date)effectingVersionBsed, (String)"yyyy-MM-dd"));
        }
        return msg;
    }

    public String validateDataStatusFuture(DynamicObject dyn) {
        String msg = null;
        if (!HRStringUtils.equals((String)dyn.getString("datastatus"), (String)"0")) {
            msg = ResManager.loadKDString((String)"\u53ea\u80fd\u4fee\u6539\u5f85\u751f\u6548\u72b6\u6001\u6570\u636e\u3002", (String)"PositionValidatorServiceHelper_34", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
        }
        return msg;
    }

    public boolean isSkip(String currentValidateMethod) {
        List skipValidateMethods = PositionSkipValidateServiceExt.getInstance().getSkipValidateMethods();
        return !CollectionUtils.isEmpty((Collection)skipValidateMethods) && HRStringUtils.isNotEmpty((String)currentValidateMethod) && skipValidateMethods.contains(currentValidateMethod);
    }
}

