/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.validate.projectrole;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.hbpm.business.domain.repository.position.ProjectRoleQueryRepository;
import kd.hrmp.hbpm.business.service.projectrole.ProjectRoleValidateHelper;
import kd.hrmp.hbpm.common.constants.ProjectRoleConstants;

public abstract class ProRoleBaseValidator
extends HRDataBaseValidator
implements ProjectRoleConstants {
    static final Log LOG = LogFactory.getLog(ProRoleBaseValidator.class);
    static final String SYSTEM_TYPE = "hrmp-hbpm-opplugin";
    DynamicObject proRoleDyn;
    ExtendedDataEntity extendedDataEntity;
    Set<String> numberSet;
    Set<Long> proTeamIdSet;
    StringBuilder nameValidityErrMsgSb = new StringBuilder();
    ExtendedDataEntity[] extendedDataEntities;

    protected void initBaseData() {
        this.extendedDataEntities = this.getDataEntities();
        this.extendedDataEntity = this.extendedDataEntities[0];
        this.proRoleDyn = this.extendedDataEntity.getDataEntity();
        this.numberSet = new HashSet<String>(this.extendedDataEntities.length);
        this.proTeamIdSet = new HashSet<Long>(this.extendedDataEntities.length);
        this.numberSet.add(this.proRoleDyn.getString("number"));
        this.proTeamIdSet.add(this.proRoleDyn.getLong("projteam.id"));
    }

    void addBizErrorMessage(ExtendedDataEntity dataEntity, String errMsg) {
        if (!StringUtils.isEmpty((Object)errMsg)) {
            this.addErrorMessage(dataEntity, errMsg);
        }
    }

    void addBizErrMessage(List<String> checkName, DynamicObject dyn, String systemType) {
        if (ObjectUtils.isEmpty(checkName)) {
            return;
        }
        for (String mess : checkName) {
            this.addBizErrorMessage(this.extendedDataEntity, this.getErrMsgInfo(dyn, systemType, mess));
        }
    }

    List<String> getErrMsgInfo(List<String> checkName, DynamicObject dyn, String systemType) {
        ArrayList<String> errMsgList = new ArrayList<String>(0);
        if (ObjectUtils.isEmpty(checkName)) {
            return errMsgList;
        }
        for (String mess : checkName) {
            errMsgList.add(this.getErrMsgInfo(dyn, systemType, mess));
        }
        return errMsgList;
    }

    String getErrMsgInfo(DynamicObject dyn, String systemType, String mess) {
        String errMsg = null;
        switch (mess) {
            case "NumberExist": {
                errMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff1a\u9879\u76ee\u89d2\u8272\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProRoleBaseValidator_0", (String)systemType, (Object[])new Object[]{dyn.getString("number")}), new Object[0]);
                break;
            }
            case "NameExist": {
                errMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff1a\u9879\u76ee\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProRoleBaseValidator_1", (String)systemType, (Object[])new Object[]{dyn.getString("number")}), new Object[0]);
                break;
            }
            case "specialsymbols": {
                errMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff1a\u9879\u76ee\u89d2\u8272\u540d\u79f0\u4e0d\u5141\u8bb8\u6709\u7279\u6b8a\u7684\u5206\u9694\u7b26\uff08!_/\\\uff09\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProRoleBaseValidator_2", (String)systemType, (Object[])new Object[0]), dyn.getString("name"));
                break;
            }
            case "projteam": {
                String projTeam = ResManager.loadKDString((String)"%s\uff1a\u6240\u5c5e\u9879\u76ee\u56e2\u961f\u5df2\u7981\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProRoleBaseValidator_3", (String)systemType, (Object[])new Object[0]);
                errMsg = String.format(Locale.ROOT, projTeam, dyn.getString("projteam.name"));
                break;
            }
            case "superroles": {
                errMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff1a\u4e0a\u7ea7\u89d2\u8272\u5df2\u7981\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProRoleBaseValidator_4", (String)systemType, (Object[])new Object[0]), dyn.getString("name"));
                break;
            }
            case "subordinateRelations": {
                String subordinateRelations = ResManager.loadKDString((String)"%s\uff1a\u4e0d\u80fd\u9009\u62e9\u81ea\u5df1\u7684\u4e0b\u7ea7\u89d2\u8272\u4e3a\u4e0a\u7ea7\u89d2\u8272\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProRoleBaseValidator_5", (String)systemType, (Object[])new Object[0]);
                errMsg = String.format(Locale.ROOT, subordinateRelations, dyn.getString("name"));
                break;
            }
            case "designBeforeEst": {
                String designBeforeEst = ResManager.loadKDString((String)"%1$s\uff1a\u8bbe\u7acb\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u6240\u5c5e\u9879\u76ee\u56e2\u961f\u7684\u6210\u7acb\u65e5\u671f%2$s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProRoleBaseValidator_6", (String)systemType, (Object[])new Object[0]);
                errMsg = String.format(Locale.ROOT, designBeforeEst, dyn.getString("number"), HRDateTimeUtils.format((Date)dyn.getDate("projteam.establishmentdate"), (String)"yyyy-MM-dd"));
                break;
            }
            case "efiBeforeDesign": {
                String efiBeforeDesign = ResManager.loadKDString((String)"%1$s\uff1a\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u9879\u76ee\u89d2\u8272\u7684\u8bbe\u7acb\u65e5\u671f%2$s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProRoleBaseValidator_7", (String)systemType, (Object[])new Object[0]);
                errMsg = String.format(Locale.ROOT, efiBeforeDesign, dyn.getString("number"), HRDateTimeUtils.format((Date)dyn.getDate("design"), (String)"yyyy-MM-dd"));
                break;
            }
            case "efiBeforeProEarliestEfi": {
                String efiBeforeProEarliestEfi = ResManager.loadKDString((String)"%1$s\uff1a\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u6240\u5c5e\u9879\u76ee\u56e2\u961f\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f%2$s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProRoleBaseValidator_8", (String)systemType, (Object[])new Object[0]);
                errMsg = String.format(Locale.ROOT, efiBeforeProEarliestEfi, dyn.getString("number"), HRDateTimeUtils.format((Date)dyn.getDate("projteam.firstbsed"), (String)"yyyy-MM-dd"));
                break;
            }
            case "designBeforeEarliestEfi": {
                String desiBeforeProEarliestEfi = ResManager.loadKDString((String)"%1$s\uff1a\u8bbe\u7acb\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u6240\u5c5e\u9879\u76ee\u56e2\u961f\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f%2$s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProRoleBaseValidator_9", (String)systemType, (Object[])new Object[0]);
                errMsg = String.format(Locale.ROOT, desiBeforeProEarliestEfi, dyn.getString("number"), HRDateTimeUtils.format((Date)dyn.getDate("projteam.firstbsed"), (String)"yyyy-MM-dd"));
                break;
            }
            case "atLeastOneLeader": {
                String atLeastOneLeader = ResManager.loadKDString((String)"%1$s\uff1a\u9879\u76ee\u56e2\u961f\u4e2d\u81f3\u5c11\u9700\u8981\u6709\u4e00\u4e2a\u4e3b\u8d1f\u8d23\u89d2\u8272\u3002", (String)"ProRoleBaseValidator_10", (String)systemType, (Object[])new Object[0]);
                errMsg = String.format(Locale.ROOT, atLeastOneLeader, dyn.getString("projteam.name"));
                break;
            }
            case "addAnotherLeader": {
                String addAnotherLeader = this.getAddAnotherLeaderMsg();
                errMsg = String.format(Locale.ROOT, addAnotherLeader, dyn.getString("number"));
                break;
            }
        }
        return errMsg;
    }

    void checkNameValidity() {
        List checkRetList = ProjectRoleValidateHelper.checkNameValidity((OrmLocaleValue)((OrmLocaleValue)this.proRoleDyn.get("name")));
        List<String> errMsgInfoList = this.getErrMsgInfo(checkRetList, this.proRoleDyn, SYSTEM_TYPE);
        if (!ObjectUtils.isEmpty(errMsgInfoList)) {
            errMsgInfoList.stream().forEach(msg -> this.nameValidityErrMsgSb.append((String)msg).append("\n"));
        }
    }

    void checkNumberUnique(boolean isExistProRoleNumber) {
        if (isExistProRoleNumber) {
            this.addBizErrorMessage(this.extendedDataEntity, this.getErrMsgInfo(this.proRoleDyn, SYSTEM_TYPE, "NumberExist"));
        }
    }

    void checkNameRepeat(Map<Long, List<DynamicObject>> proRoleByProTeam) {
        Long projTeamId = this.proRoleDyn.getLong("projteam.id");
        List<DynamicObject> proRoleDynList = proRoleByProTeam.get(projTeamId);
        if (ObjectUtils.isEmpty(proRoleDynList)) {
            return;
        }
        OrmLocaleValue dataNameObj = (OrmLocaleValue)this.proRoleDyn.get("name");
        long curProRoleId = this.proRoleDyn.getLong("id");
        block0: for (DynamicObject proDyn : proRoleDynList) {
            OrmLocaleValue roleName = (OrmLocaleValue)proDyn.get("name");
            Long dataId = proDyn.getLong("id");
            if (curProRoleId == dataId) continue;
            Set dataNameEntries = dataNameObj.entrySet();
            for (Map.Entry dataEntry : dataNameEntries) {
                for (Map.Entry roleNameMap : roleName.entrySet()) {
                    String nameValue = (String)dataEntry.getValue();
                    if (!HRStringUtils.isNotEmpty((String)nameValue) || !nameValue.equals(roleNameMap.getValue())) continue;
                    this.addBizErrorMessage(this.extendedDataEntity, this.getErrMsgInfo(this.proRoleDyn, SYSTEM_TYPE, "NameExist"));
                    continue block0;
                }
            }
        }
    }

    void checkParentValidity() {
        List checkEffectiveness = ProjectRoleValidateHelper.checkEffectiveness((DynamicObject)this.proRoleDyn.getDynamicObject("superroles"), (DynamicObject)this.proRoleDyn.getDynamicObject("projteam"));
        this.addBizErrMessage(checkEffectiveness, this.proRoleDyn, SYSTEM_TYPE);
    }

    void checkCollaborationValidity() {
        String errMsg = ProjectRoleValidateHelper.checkCollaborationDisable((Set)ProjectRoleValidateHelper.checkCollaborationEffective((DynamicObject)this.proRoleDyn), (String)SYSTEM_TYPE);
        this.addBizErrorMessage(this.extendedDataEntity, errMsg);
        String errUniqMsg = ProjectRoleValidateHelper.checkCollaborationUnique((Set)ProjectRoleValidateHelper.checkSameTypeCollaborationUnique((DynamicObject)this.proRoleDyn), (String)SYSTEM_TYPE);
        this.addBizErrorMessage(this.extendedDataEntity, errUniqMsg);
    }

    void checkSubordinateRelValidity() {
        List checkSubordinateRelations = ProjectRoleValidateHelper.checkSubordinateRelations((DynamicObject)this.proRoleDyn);
        this.addBizErrMessage(checkSubordinateRelations, this.proRoleDyn, SYSTEM_TYPE);
    }

    void checkCollaborationCycle() {
        String errCycleMsg = ProjectRoleValidateHelper.checkCollaborationCycle((Set)ProjectRoleValidateHelper.checkSameTypeCollaborationCycle((DynamicObject)this.proRoleDyn), (String)SYSTEM_TYPE);
        this.addBizErrorMessage(this.extendedDataEntity, errCycleMsg);
    }

    void checkCommonDateValidity() {
        String operateKey = this.getOperateKey();
        if (HRStringUtils.equals((String)"save_coop_change", (String)operateKey)) {
            DynamicObjectCollection coopInfoList = this.proRoleDyn.getDynamicObjectCollection("entryentity");
            Optional<DynamicObject> anyOptional = coopInfoList.stream().filter(dyn -> dyn.getLong("id") == 0L).findAny();
            if (anyOptional.isPresent()) {
                this.addBizErrMessage(ProjectRoleValidateHelper.checkProRoleDesignDate((DynamicObject)this.proRoleDyn), this.proRoleDyn, SYSTEM_TYPE);
            }
        } else {
            this.addBizErrMessage(ProjectRoleValidateHelper.checkEstablishDate((DynamicObject)this.proRoleDyn), this.proRoleDyn, SYSTEM_TYPE);
            this.addBizErrMessage(ProjectRoleValidateHelper.checkProRoleDesignDate((DynamicObject)this.proRoleDyn), this.proRoleDyn, SYSTEM_TYPE);
            Date designDate = this.proRoleDyn.getDate("design");
            if (HRStringUtils.equals((String)"save_donothing", (String)operateKey) && !ProjectRoleValidateHelper.checkSuperRolesEffDate((Long)this.proRoleDyn.getLong("superroles.id"), (Date)designDate)) {
                Date superRoleDesignDate = this.proRoleDyn.getDate("superroles.firstbsed");
                String errMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff1a\u8bbe\u7acb\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u4e0a\u7ea7\u89d2\u8272\u7684\u8bbe\u7acb\u65e5\u671f%2$s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProRoleBaseValidator_11", (String)SYSTEM_TYPE, (Object[])new Object[0]), this.proRoleDyn.getString("number"), HRDateTimeUtils.format((Date)superRoleDesignDate, (String)"yyyy-MM-dd"));
                this.addErrorMessage(this.extendedDataEntity, errMsg);
            }
        }
    }

    void checkCoopRelDateValidity() {
        DynamicObject workRoleDyn = null;
        if (!this.isNewSaveChangeType(this.getOperateKey())) {
            workRoleDyn = ProjectRoleValidateHelper.getWorkRoleDyn((Long)this.proRoleDyn.getLong("id"));
        }
        Date curProCoopEffDate = ProjectRoleValidateHelper.formatDateYYYYMMDD((Date)this.proRoleDyn.getDate("bsed"));
        DynamicObjectCollection coopInfoList = this.proRoleDyn.getDynamicObjectCollection("entryentity");
        String newSaveErrMsg = ResManager.loadKDString((String)"%1$s\uff1a\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u534f\u4f5c\u89d2\u8272\u201c%2$s\u201d\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f%3$s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProRoleBaseValidator_12", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        for (DynamicObject coopInfo2 : coopInfoList) {
            Date orgTeamFirstBSed = ProjectRoleValidateHelper.formatDateYYYYMMDD((Date)coopInfo2.getDate("parent.firstbsed"));
            if (coopInfo2.getLong("id") != 0L || !curProCoopEffDate.before(orgTeamFirstBSed)) continue;
            String message = String.format(Locale.ROOT, newSaveErrMsg, this.proRoleDyn.getString("number"), coopInfo2.getString("parent.name"), DateUtils.formatDate((Date)orgTeamFirstBSed, (Object[])new Object[]{"yyyy-MM-dd"}));
            this.addErrorMessage(this.extendedDataEntity, message);
        }
        Map roleCoopRelMap = new HashMap(16);
        if (workRoleDyn != null) {
            roleCoopRelMap = ProjectRoleValidateHelper.getRoleCoopRelMap((Long)workRoleDyn.getLong("id"));
        }
        if (ObjectUtils.isEmpty(roleCoopRelMap)) {
            return;
        }
        ArrayList proTeamChgSaveErrList = new ArrayList(16);
        ArrayList proTeamDelErrList = new ArrayList(16);
        HashMap coopRelChgLastDateMap = new HashMap(16);
        ProjectRoleValidateHelper.addCoopRelErrInfo((DynamicObjectCollection)coopInfoList, (DynamicObject)this.proRoleDyn, roleCoopRelMap, proTeamChgSaveErrList, coopRelChgLastDateMap, proTeamDelErrList);
        proTeamChgSaveErrList.stream().forEach(coopInfo -> {
            Date lastDate = (Date)coopRelChgLastDateMap.get(coopInfo.getLong("id"));
            String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff1a\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u751f\u6548\u65e5\u671f%2$s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProRoleBaseValidator_13", (String)SYSTEM_TYPE, (Object[])new Object[0]), this.proRoleDyn.getString("number"), DateUtils.formatDate((Date)lastDate, (Object[])new Object[]{"yyyy-MM-dd"}));
            this.addErrorMessage(this.extendedDataEntity, message);
        });
        proTeamDelErrList.forEach(coopInfo -> {
            Date orgTeamFirstBSed = coopInfo.getDate("bsed");
            String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff1a\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u751f\u6548\u65e5\u671f%2$s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProRoleBaseValidator_14", (String)SYSTEM_TYPE, (Object[])new Object[0]), this.proRoleDyn.getString("number"), DateUtils.formatDate((Date)orgTeamFirstBSed, (Object[])new Object[]{"yyyy-MM-dd"}));
            this.addErrorMessage(this.extendedDataEntity, message);
        });
    }

    private boolean isNewSaveChangeType(String changeType) {
        return "save_donothing".equals(changeType) || "donothing_saveandnew".equals(changeType);
    }

    void checkMainLeader() {
        List checkTheMainLeader = ProjectRoleValidateHelper.checkTheMainLeader((DynamicObject)this.proRoleDyn);
        this.addBizErrMessage(checkTheMainLeader, this.proRoleDyn, SYSTEM_TYPE);
    }

    void checkProRoleItemChgCurEffDate() {
        HRBaseServiceHelper proRoleHelper = new HRBaseServiceHelper("hbpm_projectroles");
        DynamicObject dyn = proRoleHelper.queryOne("id,bsed", new QFilter("id", "=", this.proRoleDyn.get("id")));
        Date dbEffDate = ProjectRoleValidateHelper.formatDateYYYYMMDD((Date)dyn.getDate("bsed"));
        Date effDate = ProjectRoleValidateHelper.formatDateYYYYMMDD((Date)this.proRoleDyn.getDate("bsed"));
        if (effDate.before(dbEffDate)) {
            String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff1a\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u751f\u6548\u65e5\u671f%2$s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProRoleBaseValidator_14", (String)SYSTEM_TYPE, (Object[])new Object[0]), this.proRoleDyn.getString("number"), DateUtils.formatDate((Date)dbEffDate, (Object[])new Object[]{"yyyy-MM-dd"}));
            this.addBizErrorMessage(this.extendedDataEntity, message);
        }
    }

    void checkAvailability() {
        long boid = this.proRoleDyn.getLong("boid");
        DynamicObject dbCurRole = ProjectRoleQueryRepository.getInstance().queryOriginalOneById("enable", boid);
        if (!"1".equals(dbCurRole.getString("enable"))) {
            String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u5df2\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u4e0d\u53ef\u53d8\u66f4\u3002", (String)"ProRoleBaseValidator_17", (String)SYSTEM_TYPE, (Object[])new Object[0]), this.proRoleDyn.getString("number"));
            this.addBizErrorMessage(this.extendedDataEntity, message);
        }
    }

    protected abstract String getAddAnotherLeaderMsg();
}

