/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.workroles;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRCoreBaseBillOp;
import kd.hrmp.hbpm.business.domain.repository.position.DutyWorkRoleQueryRepository;
import kd.hrmp.hbpm.business.service.WorkRoleServiceHelper;
import kd.hrmp.hbpm.business.utils.PositionUtils;
import kd.hrmp.hbpm.business.utils.WorkRoleNewHisUtils;

public class DutyWorkRoleOp
extends HRCoreBaseBillOp {
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        switch (e.getOperationKey()) {
            case "change_api": {
                this.changeHisField(e.getDataEntities());
                break;
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        WorkRoleNewHisUtils.newHisBatchSave(Arrays.asList(e.getDataEntities()));
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
    }

    public void onReturnOperation(ReturnOperationArgs e) {
    }

    private void changeHisField(DynamicObject[] dataEntities) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date2999 = HisEffDateCommonService.getInstance().getDate2999(sdf);
        List dataCollect = Arrays.stream(dataEntities).filter(data -> PositionUtils.getCurrentDate().after(data.getDate("bsed"))).filter(data -> data.getDate("bsled") == null || HRDateTimeUtils.dayEquals((Date)HRDateTimeUtils.truncateDate((Date)data.getDate("bsled")), (Date)date2999)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dataCollect)) {
            return;
        }
        Map longDateMap = PositionUtils.buildBoIdAndBSedMap(dataCollect);
        DynamicObject[] positionHisVersion = DutyWorkRoleQueryRepository.getInstance().queryPositionHisVersion(longDateMap.keySet());
        Map preHisVersion = WorkRoleServiceHelper.queryPreHisVersion((Map)longDateMap, (DynamicObject[])positionHisVersion);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject prePosition = (DynamicObject)preHisVersion.get(dataEntity.getLong("boid"));
            if (HRObjectUtils.isEmpty((Object)prePosition)) continue;
            if (!HRStringUtils.equals((String)prePosition.getString("datastatus"), (String)"1") || !HRStringUtils.equals((String)dataEntity.getString("datastatus"), (String)"1")) {
                dataEntity.set("bsled", (Object)prePosition.getDate("bsled"));
            }
            dataEntity.set("sourcevid", (Object)prePosition.getLong("id"));
        }
    }
}

