/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.bussiness.config;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbss.bussiness.config.HRConfigServiceHelper;

public class HRParamConfigTreeServiceHelper {
    private TreeView treeView;

    public HRParamConfigTreeServiceHelper(TreeView treeView) {
        this.treeView = treeView;
    }

    public void reBuildWholeTree() {
        this.treeView.deleteAllNodes();
        TreeNode rootNode = HRParamConfigTreeServiceHelper.buildRootNode();
        this.addCloudNode(rootNode);
        this.treeView.addNode(rootNode);
        this.treeView.focusNode(rootNode);
        this.treeView.treeNodeClick("", rootNode.getId());
    }

    private static TreeNode buildRootNode() {
        String rootName = ResManager.loadKDString((String)"\u5168\u90e8", (String)"HRParamConfigTreeServiceHelper_0", (String)"hrmp-hbss-business", (Object[])new Object[0]);
        TreeNode rootNode = new TreeNode("", "1010", rootName, true);
        rootNode.setIsOpened(true);
        return rootNode;
    }

    private void addCloudNode(TreeNode rootNode) {
        List<Map<String, String>> bizCloudNodeList = HRConfigServiceHelper.getBizCloud();
        String parentId = rootNode.getId();
        for (Map<String, String> bizCloudNode : bizCloudNodeList) {
            String id = bizCloudNode.get("id");
            String name = bizCloudNode.get("name");
            TreeNode cloudNode = new TreeNode(parentId, id, name, true);
            rootNode.addChild(cloudNode);
        }
    }

    public void handleExpandNodeClick(String parentId) {
        String nodeIdPrefix = parentId.split("_split_")[0];
        String parentTrueId = this.isRootNode(parentId) ? parentId : parentId.split("_split_")[1];
        QFilter[] qfArr = new QFilter[1];
        DynamicObject[] load = null;
        String localeId = RequestContext.get().getLang().name();
        if (HRStringUtils.equals((String)"1", (String)nodeIdPrefix)) {
            load = this.filterLeftCloud(parentTrueId, qfArr);
            this.setCloudTreeNode(parentId, localeId, load);
        }
    }

    private void setCloudTreeNode(String parentId, String localeid, DynamicObject[] load) {
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)load.length);
        for (DynamicObject obj : load) {
            String id = "2_split_" + obj.getString("id");
            String name = (String)AppMetadataCache.getAppInfo((String)obj.getString("id")).getName().get((Object)localeid);
            TreeNode appNode = new TreeNode(parentId, id, name, false);
            resultList.add(appNode);
        }
        this.treeView.addNodes((List)resultList);
    }

    private DynamicObject[] filterLeftCloud(String parentTrueId, QFilter[] qfArr) {
        List<String> ids = HRConfigServiceHelper.findBizappExistsEntity(parentTrueId);
        qfArr[0] = new QFilter("id", "in", ids);
        qfArr = RunModeServiceHelper.getAppIdBlacklistFilters((QFilter[])qfArr, (String)"id");
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"", (QFilter[])qfArr, (String)"sequence");
        return load;
    }

    private boolean isRootNode(String nodeId) {
        return HRStringUtils.equals((String)nodeId, (String)"1010");
    }
}

