/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.bussiness.domain.repository.login;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class HrLoginCommonRepository {
    private static final Log LOGGER = LogFactory.getLog(HrLoginCommonRepository.class);

    public static DynamicObject loadLoginConfigByNumber(String loginConfigNumber) {
        DynamicObject dynamicObject = new HRBaseServiceHelper("hbss_loginconfig").queryOne("bannergroup,bannerpic,backgroundgroup,backgroundpic,bannergroupapp,appbannerpic,backgroundgroupapp,appbackgroundpic,sysappbannerpic,sysappbackgroundpic,sysbannerpic,sysbackgroundpic,sysbannerpicl,sysappbannerpicl,client,privacystmt.id,privacystmt.name,privacystmt.form,privacystmt.locale,privacystmt.status,privacystmt.enable,usertype.id,redirectform.bizappid.id,redirectappformid.bizappid.id,logintype", new QFilter[]{new QFilter("number", "=", (Object)loginConfigNumber), new QFilter("enable", "=", (Object)Character.valueOf('1'))});
        if (dynamicObject == null) {
            LOGGER.info("Can not get login config data with number: {}.", (Object)loginConfigNumber);
        }
        return dynamicObject;
    }

    public static DynamicObject querySafeUriByParams(String originalUrlParams) {
        return new HRBaseServiceHelper("hbss_safeuri").queryOne("args", new QFilter[]{new QFilter("originuri", "like", (Object)("%" + originalUrlParams))});
    }

    public static DynamicObject[] queryPrivacyStatementByLocale(String formId, long localeId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("privacystatement");
        DynamicObject[] privacyDynamicObjects = serviceHelper.query("id", new QFilter[]{new QFilter("form.id", "=", (Object)formId), new QFilter("locale.id", "=", (Object)localeId), new QFilter("enable", "=", (Object)"1"), new QFilter("status", "=", (Object)"C")}, "version desc");
        return privacyDynamicObjects;
    }

    public static DynamicObject[] queryPrivacyStatementByFormId(String formId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("privacystatement");
        DynamicObject[] allPrivacyDynamicObjects = serviceHelper.query("id,version,content,name,form,locale,enable", new QFilter[]{new QFilter("form.id", "=", (Object)formId), new QFilter("enable", "=", (Object)"1"), new QFilter("status", "=", (Object)"C")}, "version desc");
        ArrayList<DynamicObject> items = new ArrayList<DynamicObject>();
        HashSet<String> languageSet = new HashSet<String>(allPrivacyDynamicObjects.length);
        for (DynamicObject item : allPrivacyDynamicObjects) {
            String tempLanguage = item.getString("locale.number");
            if (!languageSet.add(tempLanguage)) continue;
            items.add(item);
        }
        return items.toArray(new DynamicObject[0]);
    }

    public static DynamicObject queryPrivacyStatementByCurrPrivacyId(long currPrivacyId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("privacystatement");
        DynamicObject privacyItem = serviceHelper.queryOne("id,form,locale,version", new QFilter[]{new QFilter("id", "=", (Object)currPrivacyId)}, "version desc");
        return privacyItem;
    }

    public static DynamicObject queryPrivacyStatementByFormIdAndLocale(String formId, long localeId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("privacystatement");
        DynamicObject maxVersionResult = serviceHelper.queryOne("id,version,content,name,form,locale,enable", new QFilter[]{new QFilter("form.id", "=", (Object)formId), new QFilter("locale.id", "=", (Object)localeId), new QFilter("status", "=", (Object)"C")}, "version desc");
        return maxVersionResult;
    }

    public static Map<String, Object> getNewVersionPrivacy(Map<String, Object> signHistoryMap) {
        Map newVersionPrivacyMap = (Map)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSPrivacyService", (String)"getNewVersionPrivacy", (Object[])new Object[]{signHistoryMap});
        return newVersionPrivacyMap;
    }

    public static Map<String, Object> signPrivacy(List<Map<String, Object>> signMapList) {
        Map signResultMap = (Map)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSPrivacyService", (String)"signPrivacy", (Object[])new Object[]{signMapList});
        return signResultMap;
    }

    public static DynamicObject getVerifyCodeMessage(String loginType, String value) {
        ArrayList verifyCodeFilters = Lists.newArrayList((Object[])new QFilter[]{new QFilter("enable", "=", (Object)"0")});
        if (HRStringUtils.equals((String)"1", (String)loginType)) {
            verifyCodeFilters.add(new QFilter("phone", "=", (Object)value));
        } else if (HRStringUtils.equals((String)"2", (String)loginType)) {
            verifyCodeFilters.add(new QFilter("email", "=", (Object)value));
        }
        DynamicObject[] items = BusinessDataServiceHelper.load((String)"hbss_verifycodelog", (String)"verifyCode,message,status,createtime", (QFilter[])verifyCodeFilters.toArray(new QFilter[0]), (String)"createtime desc", (int)1);
        return items.length > 0 ? items[0] : null;
    }

    public static DynamicObject getVerifyCodeMessage(QFilter[] filters) {
        DynamicObject[] items = BusinessDataServiceHelper.load((String)"hbss_verifycodelog", (String)"verifyCode,message,status,createtime", (QFilter[])filters, (String)"createtime desc", (int)1);
        return items.length > 0 ? items[0] : null;
    }
}

