/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.bussiness.md;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbss.bussiness.md.AdminOrgQueryParamInfo;
import kd.hr.hbss.common.constants.HRMDConstants;

public class AdminOrgBusinesServiceHelper {
    private static final char ENABLED_CHAR = '1';
    private static final char UNUSING_CHAR = '2';

    public static Map<String, Integer> getSubAdminOrgCountMap(AdminOrgQueryParamInfo queryParamInfo, List<String> orgIdList) {
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select orgstruct.fparentid as \"parentid\",count(orgstruct.fadminorgid) as \"suborgcount\"").append(" from t_haos_adminstruct orgstruct ").append(" inner join t_haos_adminorg adminOrg on adminOrg.fid=orgstruct.fadminorgid").append(" inner join t_haos_adminorgtype orgtype on orgtype.fid=adminOrg.fadminorgtypeid").append(" inner join t_haos_adminorgtypestd orgtypestd on orgtypestd.fid=TO_INTEGER(orgtype.fadminorgtypestdid)");
        selectSql.append(" where 1=1");
        if (null != orgIdList && orgIdList.size() > 0) {
            String idString = String.join((CharSequence)",", orgIdList);
            selectSql.append(" and orgstruct.FPARENTID in (").append(idString).append(')');
        }
        if (!queryParamInfo.isShowDept()) {
            selectSql.append(" and orgtypestd.fid in (").append("1010").append(',').append("1020").append(',').append("1030").append(')');
        }
        if (!queryParamInfo.isShowDisable()) {
            selectSql.append(" and adminOrg.fenable='").append('1').append("' ");
        }
        if (!queryParamInfo.isShowUnUsing()) {
            selectSql.append(" and adminOrg.fenable!='").append('2').append("' ");
        }
        selectSql.append(" group by orgstruct.fparentid");
        HashMap<String, Integer> subOrgCountMap = new HashMap<String, Integer>();
        try (DataSet rs = null;){
            rs = HRDBUtil.queryDataSet((String)"hr_haos_getsuborgcount", (DBRoute)HRMDConstants.DB_ROUTE_HAOS, (String)selectSql.toString(), null);
            Iterator iterator = rs.iterator();
            while (iterator != null && iterator.hasNext()) {
                Row data = (Row)iterator.next();
                subOrgCountMap.put(data.getString("parentid"), data.getInteger("suborgcount"));
            }
        }
        return subOrgCountMap;
    }

    public static DynamicObject getCompanyByAdminOrgId(long adminOrgId) {
        String sql = "select adminorgstruct.fid,adminorgstructtypestd.fid from t_haos_adminorg adminorg inner join t_haos_adminstruct adminstruct on adminorg.fid = adminstruct.fadminorgid inner join t_haos_adminstruct struct on (charindex(concat(struct.flongnumber,'!'), adminstruct.flongnumber) = 1 or struct.flongnumber = adminstruct.flongnumber) inner join t_haos_adminorg adminorgstruct on struct.fadminorgid = adminorgstruct.fid inner join t_haos_adminorgtype adminorgstructtype on adminorgstruct.fadminorgtypeid = adminorgstructtype.fid inner join t_haos_adminorgtypestd adminorgstructtypestd on adminorgstructtype.fadminorgtypestdid = adminorgstructtypestd.fid where adminorg.fid = ? and adminorgstruct.fstatus = 'C' and adminorgstruct.fenable='1' and adminorgstructtypestd.fid = 1020 order by struct.flevel desc ";
        List companyList = (List)HRDBUtil.query((DBRoute)new DBRoute("hr"), (String)sql, (Object[])new Object[]{adminOrgId}, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws SQLException {
                ArrayList<Long> list = new ArrayList<Long>();
                while (rs.next()) {
                    if (rs.getLong(2) != 1020L) continue;
                    list.add(rs.getLong(1));
                    break;
                }
                return list;
            }
        });
        if (companyList.size() == 0) {
            return null;
        }
        long companyId = (Long)companyList.get(0);
        DynamicObject companyDy = HRBaseDaoFactory.getInstance((String)"haos_adminorghr").queryOne((Object)companyId);
        return companyDy;
    }

    public static List<Long> getSubAdminOrgList(String orgId) {
        QFilter orgIdFilter = new QFilter("adminorg.id", "=", (Object)Long.valueOf(orgId));
        DynamicObject focusNodeDy = HRBaseDaoFactory.getInstance((String)"haos_adminstruct").queryOne("longnumber", orgIdFilter);
        if (focusNodeDy == null) {
            return new ArrayList<Long>();
        }
        String longNumber = (String)focusNodeDy.get("longnumber");
        QFilter filter = new QFilter("longnumber", "like", (Object)(longNumber + "!" + "%"));
        filter.or(orgIdFilter);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dyColl = HRBaseDaoFactory.getInstance((String)"haos_adminstruct").queryColl("adminorg.id adminorg", filters, null);
        ArrayList<Long> ids = new ArrayList<Long>(dyColl.size());
        int size = dyColl.size();
        for (int i = 0; i < size; ++i) {
            ids.add(((DynamicObject)dyColl.get(i)).getLong("adminorg"));
        }
        return ids;
    }

    public static List<Long> getSubAdminOrgList(List<Long> orgIds, Boolean isEnabled) {
        QFilter[] filters;
        QFilter orgIdFilter = new QFilter("adminorg.id", "in", orgIds);
        DynamicObject[] focusNodeDys = HRBaseDaoFactory.getInstance((String)"haos_adminstruct").query("longnumber", orgIdFilter);
        if (focusNodeDys == null) {
            return new ArrayList<Long>();
        }
        for (DynamicObject focusNodeDy : focusNodeDys) {
            String longNumber = (String)focusNodeDy.get("longnumber");
            QFilter filter = new QFilter("longnumber", "like", (Object)(longNumber + "!" + "%"));
            orgIdFilter.or(filter);
        }
        if (isEnabled.booleanValue()) {
            QFilter enableFilter = new QFilter("adminorg.enable", "=", (Object)"1");
            filters = new QFilter[]{orgIdFilter, enableFilter};
        } else {
            filters = new QFilter[]{orgIdFilter};
        }
        DynamicObjectCollection dyColl = HRBaseDaoFactory.getInstance((String)"haos_adminstruct").queryColl("adminorg.id adminorg", filters, null);
        ArrayList<Long> ids = new ArrayList<Long>(dyColl.size());
        int size = dyColl.size();
        for (int i = 0; i < size; ++i) {
            ids.add(((DynamicObject)dyColl.get(i)).getLong("adminorg"));
        }
        return ids;
    }

    public static DynamicObject getParentOrgByOrgId(Long orgId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorghr");
        return serviceHelper.queryOne("parent.id", (Object)orgId);
    }
}

