/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.bussiness.md;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FloatingDirection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbss.bussiness.util.DuplicateCodeUtil;
import org.apache.commons.lang3.StringUtils;

public class JobClassTreeListPlugin
extends StandardTreeListPlugin {
    private static final String ROOT_NODE_ID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final String TBL_NEW = "tblnew";
    private static final String SEARCH = "searchap";
    private static final String BTN_TREE_FILTER = "btntreefilter";
    private static final String ACTION_ID_CALLBACK = "callback";
    private static final String KEY_JOB_CLASS_LEVEL = "jobclasslevel";
    private static final String KEY_CURRENT_NODE_ID = "currentnodeid";
    private static final String FIELD_JOB_SEQ_ID = "jobseqid.id";
    private static final String FIELD_JOB_FAMILY_ID = "jobfamilyid.id";
    private static final String FIELD_PARENT_ID = "parent.id";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_TREE_FILTER});
        Search search = (Search)this.getView().getControl(SEARCH);
        if (null != search) {
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void initializeTree(EventObject e) {
        TreeView treeView = (TreeView)this.getControl("treeview");
        TreeView.TreeState treeState = treeView.getTreeState();
        Map focusNode = treeState.getFocusNode();
        if (null != focusNode) {
            this.getView().getFormShowParameter().setCustomParam("id", focusNode.get("id"));
        }
        this.getTreeModel().setRoot(this.loadAllNodes());
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if (StringUtils.equalsIgnoreCase((CharSequence)control.getKey(), (CharSequence)BTN_TREE_FILTER)) {
            this.showTreeFilterDialog();
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String billStatus;
        args.setCancel(true);
        BillList billListSource = (BillList)args.getHyperLinkClickEvent().getSource();
        Long id = (Long)billListSource.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("hjms_jobclass");
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        baseShowParameter.setPkId((Object)id);
        baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_ID_CALLBACK));
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hjms_jobclass");
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        DynamicObject jobClass = hrBaseServiceHelper.queryOne("id, status", new QFilter[]{qFilter});
        switch (billStatus = jobClass == null ? "" : jobClass.getString("status")) {
            case "A": {
                baseShowParameter.setBillStatus(BillOperationStatus.EDIT);
                break;
            }
            default: {
                baseShowParameter.setBillStatus(BillOperationStatus.VIEW);
            }
        }
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        HRPageCache pageCache = new HRPageCache(this.getPageCache());
        String jobClassLevel = (String)closedCallBackEvent.getReturnData();
        pageCache.put(KEY_JOB_CLASS_LEVEL, (Object)jobClassLevel);
        if (HRStringUtils.equals((String)ACTION_ID_CALLBACK, (String)closedCallBackEvent.getActionId())) {
            pageCache.put(KEY_CURRENT_NODE_ID, this.getTreeModel().getCurrentNodeId());
            this.getView().invokeOperation("refresh");
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent event) {
        QFilter treeFilter;
        HRPageCache pageCache = new HRPageCache(this.getPageCache());
        String nodeId = (String)pageCache.get(KEY_CURRENT_NODE_ID, String.class);
        if (null == nodeId) {
            nodeId = (String)event.getNodeId();
        }
        if (null != (treeFilter = this.buildAppQFilter(nodeId))) {
            event.addQFilter(treeFilter);
        }
        event.setCancel(true);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String currentNodeId = this.getSpecificNodeId(formOperate.getOperateKey(), args);
        HRPageCache pageCache = new HRPageCache(this.getPageCache());
        pageCache.put(KEY_CURRENT_NODE_ID, (Object)currentNodeId);
        this.getTreeModel().setCurrentNodeId((Object)ROOT_NODE_ID);
    }

    private String getSpecificNodeId(String operateKey, BeforeDoOperationEventArgs args) {
        String currentNodeId = (String)this.getTreeModel().getCurrentNodeId();
        switch (operateKey) {
            case "disable": 
            case "delete": {
                List<String> jobClassIds = this.getSelectedJobClassIds(args);
                String nodeId = currentNodeId.substring(1, currentNodeId.length());
                Boolean isContain = Boolean.FALSE;
                for (String jobClassId : jobClassIds) {
                    if (!HRStringUtils.equals((String)jobClassId, (String)nodeId)) continue;
                    isContain = Boolean.TRUE;
                }
                if (!isContain.booleanValue()) break;
                currentNodeId = this.getCurrentNodeIdBasedOnCurrentNode(currentNodeId);
                break;
            }
        }
        return currentNodeId;
    }

    private List<String> getSelectedJobClassIds(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection selectedJobClassIds = args.getListSelectedData();
        ArrayList<String> jobClassIds = new ArrayList<String>();
        if (!selectedJobClassIds.isEmpty()) {
            for (ListSelectedRow selectedJobClass : selectedJobClassIds) {
                Long rowId = (Long)selectedJobClass.getPrimaryKeyValue();
                if (null == rowId || rowId.equals(0L)) continue;
                jobClassIds.add(Long.toString(rowId));
            }
        }
        return jobClassIds;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        HRPageCache pageCache = new HRPageCache(this.getPageCache());
        String currentNodeId = (String)pageCache.get(KEY_CURRENT_NODE_ID, String.class);
        String jobClassLevel = (String)pageCache.get(KEY_JOB_CLASS_LEVEL, String.class);
        if (null != jobClassLevel) {
            String currentNodeLayer = currentNodeId.substring(0, 1);
            String jobClassId = currentNodeId.substring(1, currentNodeId.length());
            switch (currentNodeLayer) {
                case "3": {
                    if (!HRStringUtils.equals((String)jobClassLevel, (String)"2")) break;
                    currentNodeId = "4" + jobClassId;
                    break;
                }
                case "4": {
                    if (!HRStringUtils.equals((String)jobClassLevel, (String)"1")) break;
                    currentNodeId = "3" + jobClassId;
                    break;
                }
            }
        }
        pageCache.remove(KEY_CURRENT_NODE_ID);
        TreeNode node = new TreeNode("", currentNodeId, "");
        this.getTreeListView().getTreeView().focusNode(node);
        this.getTreeModel().setCurrentNodeId((Object)currentNodeId);
        if (!"refresh".equals(afterDoOperationEventArgs.getOperateKey())) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void refreshNode(RefreshNodeEvent event) {
        boolean isShowDisable = this.getIsShowDisableValue();
        event.setChildNodes(DuplicateCodeUtil.getJobSeqTreeNode(isShowDisable));
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (HRStringUtils.equals((String)evt.getItemKey(), (String)TBL_NEW)) {
            evt.setCancel(true);
            BaseShowParameter baseShowParameter = new BaseShowParameter();
            baseShowParameter.setFormId("hjms_jobclass");
            baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            baseShowParameter.setStatus(OperationStatus.ADDNEW);
            baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_ID_CALLBACK));
            String nodeId = (String)this.treeListView.getTreeModel().getCurrentNodeId();
            if (null != nodeId && !HRStringUtils.isEmpty((String)nodeId)) {
                HashMap<String, Object> cusParamMap = new HashMap<String, Object>();
                String nodeLayer = nodeId.substring(0, 1);
                String nodeLayerId = nodeId.substring(1, nodeId.length());
                switch (nodeLayer) {
                    case "1": {
                        cusParamMap.put("jobseqid", nodeLayerId);
                        break;
                    }
                    case "2": {
                        this.handleCase2(cusParamMap, nodeLayerId);
                        break;
                    }
                    case "3": {
                        this.handleCase3(cusParamMap, nodeLayerId);
                        break;
                    }
                    case "4": {
                        this.handleCase4(cusParamMap, nodeLayerId);
                        break;
                    }
                }
                cusParamMap.put("layer", nodeLayer);
                baseShowParameter.setCustomParam("cusParam", cusParamMap);
            }
            this.getView().showForm((FormShowParameter)baseShowParameter);
        }
    }

    private void handleCase4(Map<String, Object> cusParamMap, String nodeLayerId) {
        HRBaseServiceHelper jobSubClassHelper = new HRBaseServiceHelper("hjms_jobclass");
        QFilter jobSubClassFilter = new QFilter("id", "=", (Object)nodeLayerId);
        DynamicObject jobSubClassObj = jobSubClassHelper.queryOne("id, parent, jobfamilyid, jobseqid", new QFilter[]{jobSubClassFilter});
        cusParamMap.put("jobseqid", jobSubClassObj.get(FIELD_JOB_SEQ_ID));
        cusParamMap.put("jobfamilyid", jobSubClassObj.get(FIELD_JOB_FAMILY_ID));
        cusParamMap.put("parent", jobSubClassObj.get(FIELD_PARENT_ID));
    }

    private void handleCase3(Map<String, Object> cusParamMap, String nodeLayerId) {
        HRBaseServiceHelper jobClassHelper = new HRBaseServiceHelper("hjms_jobclass");
        QFilter jobClassFilter = new QFilter("id", "=", (Object)nodeLayerId);
        DynamicObject jobClassObj = jobClassHelper.queryOne("id, jobfamilyid, jobseqid", new QFilter[]{jobClassFilter});
        cusParamMap.put("jobseqid", jobClassObj.get(FIELD_JOB_SEQ_ID));
        cusParamMap.put("jobfamilyid", jobClassObj.get(FIELD_JOB_FAMILY_ID));
        cusParamMap.put("parent", nodeLayerId);
    }

    private void handleCase2(Map<String, Object> cusParamMap, String nodeLayerId) {
        HRBaseServiceHelper jobFamilyHelper = new HRBaseServiceHelper("hjms_jobfamily");
        QFilter jobFamilyFilter = new QFilter("id", "=", (Object)nodeLayerId);
        DynamicObject jobFamilyObj = jobFamilyHelper.queryOne("id, jobseqid", new QFilter[]{jobFamilyFilter});
        cusParamMap.put("jobseqid", jobFamilyObj.get(FIELD_JOB_SEQ_ID));
        cusParamMap.put("jobfamilyid", nodeLayerId);
    }

    private TreeNode loadAllNodes() {
        TreeNode root = new TreeNode();
        HashMap<String, String> rootData = new HashMap<String, String>();
        boolean isShowDisable = this.getIsShowDisableValue();
        this.getPageCache().put("chkshowdisable", String.valueOf(isShowDisable));
        rootData.put("type", "root");
        root.setData(rootData);
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"JobClassTreeListPlugin_0", (String)"hrmp-hbss-business", (Object[])new Object[0]));
        root.setParentid("");
        root.setId(ROOT_NODE_ID);
        root.setIsOpened(true);
        root.addChildren(DuplicateCodeUtil.getJobSeqTreeNode(isShowDisable));
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        return root;
    }

    private QFilter buildAppQFilter(String nodeId) {
        if (null != nodeId && !HRStringUtils.isEmpty((String)nodeId)) {
            QFilter filter;
            String nodeLayer;
            switch (nodeLayer = nodeId.substring(0, 1)) {
                case "1": {
                    filter = new QFilter("jobseqid", "=", (Object)nodeId.substring(1, nodeId.length()));
                    break;
                }
                case "2": {
                    filter = new QFilter("jobfamilyid", "=", (Object)nodeId.substring(1, nodeId.length()));
                    break;
                }
                case "3": 
                case "4": {
                    String classNodeId = nodeId.substring(1, nodeId.length());
                    filter = new QFilter("id", "=", (Object)classNodeId);
                    filter.or("parent", "=", (Object)classNodeId);
                    break;
                }
                default: {
                    filter = new QFilter("id", "is not null", (Object)"");
                }
            }
            return filter;
        }
        return null;
    }

    private void showTreeFilterDialog() {
        FormShowParameter formShowParameter = new FormShowParameter();
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Floating);
        openStyle.setFloatingDirection(FloatingDirection.BottomCenter);
        openStyle.setTargetKey(BTN_TREE_FILTER);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "treefilteroperation"));
        formShowParameter.setFormId("hjms_jobclassfilterdialog");
        String chkShowDisable = this.getPageCache().get("chkshowdisable");
        formShowParameter.setCustomParam("chkshowdisable", (Object)chkShowDisable);
        this.getView().showForm(formShowParameter);
    }

    private String getCurrentNodeIdBasedOnCurrentNode(String currNodeId) {
        String currentNodeId = ROOT_NODE_ID;
        String nodeLayer = currNodeId.substring(0, 1);
        String nodeLayerId = currNodeId.substring(1, currNodeId.length());
        switch (nodeLayer) {
            case "1": 
            case "2": {
                break;
            }
            case "3": {
                currentNodeId = this.getCurrentNodeIdByThree(currentNodeId, nodeLayerId);
                break;
            }
            case "4": {
                currentNodeId = this.getCurrentNodeIdByFour(currentNodeId, nodeLayerId);
                break;
            }
        }
        return currentNodeId;
    }

    private String getCurrentNodeIdByFour(String currentNodeId, String nodeLayerId) {
        if (!HRStringUtils.isEmpty((String)nodeLayerId)) {
            HRBaseServiceHelper jobSupClassHelper = new HRBaseServiceHelper("hjms_jobclass");
            QFilter jobSupClassFilter = new QFilter("id", "=", (Object)nodeLayerId);
            DynamicObject jobSupClass = jobSupClassHelper.queryOne("id, parent.id, parent.enable, jobfamilyid.id, jobfamilyid.enable, jobseqid.id, jobseqid.enable", new QFilter[]{jobSupClassFilter});
            if (null == jobSupClass) {
                return currentNodeId;
            }
            if (HRStringUtils.equals((String)"1", (String)jobSupClass.getString("parent.enable"))) {
                currentNodeId = "3" + jobSupClass.getString(FIELD_PARENT_ID);
            } else if (HRStringUtils.equals((String)"1", (String)jobSupClass.getString("jobfamilyid.enable"))) {
                currentNodeId = "2" + jobSupClass.getString(FIELD_JOB_FAMILY_ID);
            } else if (HRStringUtils.equals((String)"1", (String)jobSupClass.getString("jobseqid.enable"))) {
                currentNodeId = "1" + jobSupClass.getString(FIELD_JOB_SEQ_ID);
            }
        }
        return currentNodeId;
    }

    private String getCurrentNodeIdByThree(String currentNodeId, String nodeLayerId) {
        if (!HRStringUtils.isEmpty((String)nodeLayerId)) {
            HRBaseServiceHelper jobClassHelper = new HRBaseServiceHelper("hjms_jobclass");
            QFilter jobClassFilter = new QFilter("id", "=", (Object)nodeLayerId);
            DynamicObject jobClass = jobClassHelper.queryOne("id, jobfamilyid.id, jobfamilyid.enable, jobseqid.id, jobseqid.enable", new QFilter[]{jobClassFilter});
            if (null == jobClass) {
                return currentNodeId;
            }
            if (HRStringUtils.equals((String)"1", (String)jobClass.getString("jobfamilyid.enable"))) {
                currentNodeId = "2" + jobClass.getString(FIELD_JOB_FAMILY_ID);
            } else if (HRStringUtils.equals((String)"1", (String)jobClass.getString("jobseqid.enable"))) {
                currentNodeId = "1" + jobClass.getString(FIELD_JOB_SEQ_ID);
            }
        }
        return currentNodeId;
    }

    private boolean getIsShowDisableValue() {
        boolean isShowDiable = false;
        Boolean isShowDisableParam = (Boolean)this.getView().getFormShowParameter().getCustomParam("chkshowdisable");
        if (null != isShowDisableParam) {
            this.getPageCache().put("chkshowdisable", String.valueOf(isShowDisableParam));
            isShowDiable = isShowDisableParam;
        } else {
            String cacheShowDiable = this.getPageCache().get("chkshowdisable");
            isShowDiable = cacheShowDiable != null ? Boolean.parseBoolean(cacheShowDiable) : false;
        }
        return isShowDiable;
    }
}

