/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.bussiness.service.hrbu;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbss.common.model.OrgInfo;
import org.apache.commons.lang3.StringUtils;

public class HRBUDisableService {
    private static final Log LOGGER = LogFactory.getLog(HRBUDisableService.class);

    @ExcludeFromJacocoGeneratedReport
    public static Map<Long, Set<Long>> checkBusinessStrategy(Map<Long, Set<Long>> businessStrategyMap) {
        return (Map)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSStrategyService", (String)"judgeStrategyExist4HrBu", (Object[])new Object[]{businessStrategyMap});
    }

    public static DynamicObject selectDisableConfig(Long viewId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hbss_orgcheckconfig");
        QFilter orgFilter = new QFilter("orgfun", "=", (Object)viewId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return helper.loadDynamicObject(new QFilter[]{orgFilter, enableFilter});
    }

    @ExcludeFromJacocoGeneratedReport
    public static Map<Long, Set<Long>> assembleBusinessStrategy(List<OrgInfo> allNodes) {
        HashMap orgFunRefMap = Maps.newHashMapWithExpectedSize((int)16);
        HashSet viewIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (OrgInfo org : allNodes) {
            Long orgId = org.getOrgId();
            Long viewId = org.getViewId();
            viewIdSet.add(viewId);
            orgFunRefMap.computeIfAbsent(orgId, key -> new HashSet(16)).add(viewId);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_bussinessfield");
        DynamicObjectCollection businessRefDys = serviceHelper.queryOriginalCollection("id,controlfuntype", new QFilter[]{new QFilter("controlfuntype", "in", (Object)viewIdSet)});
        HashMap businessRefMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject businessRef : businessRefDys) {
            Long id = businessRef.getLong("id");
            Long funTypeId = businessRef.getLong("controlfuntype");
            businessRefMap.computeIfAbsent(funTypeId, key -> new HashSet(16)).add(id);
        }
        HashMap orgBusinessRefMap = Maps.newHashMapWithExpectedSize((int)16);
        orgFunRefMap.forEach((key, value) -> {
            HashSet businessRefFunIdSet = Sets.newHashSetWithExpectedSize((int)16);
            value.forEach(bfId -> {
                if (businessRefMap.get(bfId) != null) {
                    businessRefFunIdSet.addAll((Collection)businessRefMap.get(bfId));
                }
            });
            orgBusinessRefMap.put(key, businessRefFunIdSet);
        });
        return orgBusinessRefMap;
    }

    public static boolean assembleDisableConfig(DynamicObject dy, Long viewId, Long orgId, Map<Long, List<String>> errorMap) {
        HashMap orgMap = Maps.newHashMapWithExpectedSize((int)16);
        HashSet ids = Sets.newHashSetWithExpectedSize((int)1);
        ids.add(orgId);
        orgMap.put(viewId, ids);
        DynamicObject cloud = dy.getDynamicObject("cloud");
        DynamicObject app = dy.getDynamicObject("app");
        DynamicObjectCollection collection = dy.getDynamicObjectCollection("entryentity");
        TreeMap<Long, List> treeMap = new TreeMap<Long, List>();
        for (DynamicObject dynamicObject : collection) {
            long isOpen = dynamicObject.getLong("apienable");
            if (isOpen != 1L) continue;
            Long checkindex = dynamicObject.getLong("checkindex");
            String api = dynamicObject.getString("api");
            treeMap.computeIfAbsent(checkindex, key -> new ArrayList()).add(api);
        }
        Set entrySet = treeMap.entrySet();
        for (Map.Entry entry : entrySet) {
            List apis = (List)entry.getValue();
            for (String api : apis) {
                Map<Long, String> resultMap = HRBUDisableService.checkDisableConfig(orgMap, cloud.getString("number").toLowerCase(), app.getString("number").toLowerCase(), api);
                if (resultMap == null) continue;
                for (Map.Entry<Long, String> resultEntry : resultMap.entrySet()) {
                    Long bosOrgId = resultEntry.getKey();
                    String resultMsg = resultEntry.getValue();
                    if (!StringUtils.isNotEmpty((CharSequence)resultMsg)) continue;
                    errorMap.computeIfAbsent(bosOrgId, key -> new ArrayList()).add(resultMsg);
                }
            }
            List<String> errorMsgs = errorMap.get(orgId);
            if (errorMsgs == null || errorMsgs.size() <= 0) continue;
            return false;
        }
        return true;
    }

    private static Map<Long, String> checkDisableConfig(Map<Long, Set<Long>> map, String cloud, String app, String api) {
        if (api.contains("&")) {
            String[] split = api.split("&");
            String serviceName = split[0];
            String methodName = split[1];
            return (Map)HRMServiceHelper.invokeBizService((String)cloud, (String)app, (String)serviceName, (String)methodName, (Object[])new Object[]{map});
        }
        return null;
    }
}

