/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.bussiness.service.hrbu;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.OrgProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.api.IOrgService;
import kd.bos.org.model.OperationType;
import kd.bos.org.model.OrgDutyView;
import kd.bos.org.model.OrgParam;
import kd.bos.org.service.OrgService;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.message.MessageCreator;
import kd.bos.schedule.server.ScheduleService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbss.bussiness.servicehelper.HRBUExtServiceHelper;
import kd.hr.hbss.bussiness.task.HRBuSync;
import kd.hr.hbss.common.constants.HRBUConstants;
import kd.hr.hbss.common.model.OrgInfo;
import kd.hr.hbss.common.util.LocalCacheUtils;
import org.apache.commons.lang3.StringUtils;

public class HRBUValidationService {
    private static final Log LOGGER = LogFactory.getLog(HRBUValidationService.class);
    private static final List<String> excludeEntities = Arrays.asList("hbss_hrbuext", "hbss_hrbuviewext", "hrcs_empstrentry", "hrcs_orgstrentry");
    private static final ExecutorService executorService = ThreadPools.newExecutorService((String)HRBUValidationService.class.getName(), (int)10);

    public static String checkHRBuNode(long buId) {
        LOGGER.info("HRBUValidationService.checkHRBuNode(),org:{} begin", (Object)buId);
        List<OrgInfo> allNodes = HRBUExtServiceHelper.getSubOrg(Lists.newArrayList((Object[])new Long[]{buId}), HRBUConstants.HR_VIEW_ID, Boolean.TRUE, null);
        try {
            HRBUValidationService.checkOrgInfo(allNodes, "-1", new LongAdder(), "", new Boolean[]{Boolean.TRUE, Boolean.TRUE}, new AtomicBoolean());
        }
        catch (Exception exception) {
            LOGGER.error("HRBUValidationService.checkHRBuNode(),checkOrgInfo error :", (Throwable)exception);
            return String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u79fb\u9664\u62a5\u9519\uff0c\u9519\u8bef\u539f\u56e0\uff1a%1$s\u3002", (String)"HRBUValidationService_0", (String)"hrmp-hbss-business", (Object[])new Object[0]), exception.getMessage());
        }
        ArrayListMultimap viewId2OrgIds = ArrayListMultimap.create();
        StringBuilder errorInfo = new StringBuilder();
        allNodes.forEach(orgInfo -> {
            viewId2OrgIds.put((Object)orgInfo.getViewId(), (Object)orgInfo.getOrgId());
            if (orgInfo.isBusinessStrayRef()) {
                errorInfo.append(String.format(ResManager.loadKDString((String)"\u79fb\u9664\u5931\u8d25\uff0c\u201c%1$s\u201d\u5df2\u88ab\u4e1a\u52a1\u7c7b\u578b\u201c%2$s\u201d\u8bbe\u7f6e\u4e86\u7ba1\u7406\u5173\u7cfb\u7b56\u7565\u3002", (String)"HRBUValidationService_1", (String)"hrmp-hbss-business", (Object[])new Object[0]), orgInfo.getName(), StringUtils.join((Iterable)orgInfo.getBusinessStrayRefList(), (String)","))).append(System.lineSeparator());
            }
            if (orgInfo.isBusinessDataRef()) {
                errorInfo.append(String.format(ResManager.loadKDString((String)"\u79fb\u9664\u5931\u8d25\uff0c\u201c%1$s\u201d\u5df2\u88ab\u4e1a\u52a1\u6570\u636e\u5f15\u7528\u3002", (String)"HRBUValidationService_2", (String)"hrmp-hbss-business", (Object[])new Object[0]), orgInfo.getName())).append(System.lineSeparator());
            }
        });
        Map<Object, DynamicObject> bizCheckers = HRBUValidationService.getBizCheckers("deleteduty", "OrBizDelChecker");
        LOGGER.info("HRBUValidationService.checkHRBuNode_getBizCheckers:{}", bizCheckers);
        for (DynamicObject checkerObj : bizCheckers.values()) {
            Map<Long, Map<Long, Set<String>>> checkResult;
            long childViewId = checkerObj.getLong("view.id");
            if (!viewId2OrgIds.containsKey((Object)childViewId) || !Objects.nonNull(checkResult = HRBUValidationService.invokerBizChecker((ArrayListMultimap<Long, Long>)viewId2OrgIds, checkerObj, childViewId)) || checkResult.size() <= 0) continue;
            checkResult.forEach((key, value) -> errorInfo.append(StringUtils.join((Iterable)((Iterable)value.get(childViewId)), (String)";")).append(System.lineSeparator()));
        }
        String result = errorInfo.toString();
        if (StringUtils.isBlank((CharSequence)result)) {
            List<OrgInfo> childrenOrgInfos = allNodes.stream().filter(orgInfo -> orgInfo.getViewId().longValue() != HRBUConstants.HR_VIEW_ID.longValue()).collect(Collectors.toList());
            try {
                HRBUValidationService.delOrgArrays(childrenOrgInfos);
            }
            catch (Exception exception) {
                LOGGER.error("HRBUValidationService.checkHRBuNode(),delOrgArrays error:", (Throwable)exception);
                return String.format(ResManager.loadKDString((String)"\u5b50\u804c\u80fd\u7ec4\u7ec7\u79fb\u9664\u62a5\u9519\uff0c\u9519\u8bef\u539f\u56e0\uff1a%1$s\u3002", (String)"HRBUValidationService_3", (String)"hrmp-hbss-business", (Object[])new Object[0]), exception.getMessage());
            }
        }
        LOGGER.info("HRBUValidationService.checkHRBuNode(),org:{} end", (Object)buId);
        return result;
    }

    public static Map<Long, Map<Long, Set<String>>> invokerBizChecker(ArrayListMultimap<Long, Long> viewId2OrgIds, DynamicObject checkerObj, long childViewId) {
        String appId = checkerObj.getString("app.id");
        String appNumber = checkerObj.getString("app.number");
        String serviceName = checkerObj.getString("servicename").trim();
        DynamicObject cloudDy = (DynamicObject)DispatchServiceHelper.invokeBOSService((String)"bos", (String)"BizCloudService", (String)"getBizCloudByAppID", (Object[])new Object[]{appId});
        if (Objects.isNull(cloudDy)) {
            return new HashMap<Long, Map<Long, Set<String>>>();
        }
        return (Map)HRMServiceHelper.invokeBizService((String)cloudDy.getString("number").toLowerCase(Locale.ROOT), (String)appNumber, (String)serviceName, (String)"validate", (Object[])new Object[]{childViewId, viewId2OrgIds.get((Object)childViewId), new HashMap()});
    }

    public static void checkOrgInfo(List<OrgInfo> allNodes, String taskId, LongAdder progress, String desc, Boolean[] validatorEnable, AtomicBoolean isTaskEnd) {
        if (isTaskEnd.get() || allNodes.size() == 0) {
            return;
        }
        LOGGER.info("HRBUValidationService.checkOrgInfo(),taskId:{},allNodes size:{}", (Object)taskId, (Object)allNodes.size());
        Map<Long, Set<Long>> businessStrategyResult = null;
        HashMap businessType2OrgTypeMap = null;
        HashMap id2BusinessRefMap = null;
        if (validatorEnable[0].booleanValue()) {
            businessType2OrgTypeMap = Maps.newHashMapWithExpectedSize((int)16);
            id2BusinessRefMap = Maps.newHashMapWithExpectedSize((int)16);
            Map<Long, Set<Long>> businessStrategyMap = HRBUValidationService.assembleBusinessStrategy(allNodes, businessType2OrgTypeMap, id2BusinessRefMap);
            businessStrategyResult = HRBUValidationService.checkBusinessStrategy(businessStrategyMap);
            LOGGER.info("HRBUValidationService.checkOrgInfo(),businessStrategyResult validate fail org:{}", businessStrategyResult);
        }
        if (isTaskEnd.get()) {
            return;
        }
        Table<Long, Long, Boolean> businessBillRefMap = null;
        if (validatorEnable[1].booleanValue()) {
            businessBillRefMap = HRBUValidationService.checkBillRefResult(allNodes, taskId, progress, desc, isTaskEnd);
            LOGGER.info("HRBUValidationService.checkOrgInfo(),checkBillRefResult validate fail org:{}", businessBillRefMap);
        }
        Map<Long, Set<Long>> finalBusinessStrategyResult = businessStrategyResult;
        HashMap finalBusinessType2OrgTypeMap = businessType2OrgTypeMap;
        HashMap finalId2BusinessRefMap = id2BusinessRefMap;
        Table<Long, Long, Boolean> finalBusinessBillRefMap = businessBillRefMap;
        allNodes.forEach(node -> {
            Boolean aBoolean;
            if (finalBusinessStrategyResult != null) {
                HRBUValidationService.markBusinessStrategyResult(finalBusinessStrategyResult, finalBusinessType2OrgTypeMap, finalId2BusinessRefMap, node);
            }
            if (finalBusinessBillRefMap != null && (aBoolean = (Boolean)finalBusinessBillRefMap.get((Object)node.getOrgId(), (Object)node.getViewId())) != null && aBoolean.booleanValue()) {
                node.setBusinessDataRef(true);
            }
        });
    }

    public static Map<Long, List<String>> orgFreezeValidate(List<Long> orgIds, Long viewId) {
        HashMap result = Maps.newHashMap();
        List<OrgInfo> childViewOrgInfo = HRBUExtServiceHelper.getSubOrg(orgIds, viewId, Boolean.FALSE, null);
        List<OrgInfo> isFreezeOrgInfo = childViewOrgInfo.stream().filter(OrgInfo::isFreeze).collect(Collectors.toList());
        isFreezeOrgInfo.forEach(orgInfo -> {
            if (orgInfo.getViewId().equals(viewId)) {
                result.putIfAbsent(orgInfo.getOrgId(), Lists.newArrayList((Object[])new String[]{HRBUValidationService.getTipOfFreeze(orgInfo)}));
            }
        });
        childViewOrgInfo.removeAll(isFreezeOrgInfo);
        HRBUValidationService.checkOrgInfoOfFreeze(childViewOrgInfo);
        HashSet errStrategyId = Sets.newHashSetWithExpectedSize((int)childViewOrgInfo.size());
        Map<Long, List<OrgInfo>> collectTemp = childViewOrgInfo.stream().filter(OrgInfo::isBusinessStrayRef).collect(Collectors.groupingBy(OrgInfo::getOrgId));
        if (collectTemp != null && collectTemp.size() > 0) {
            for (Map.Entry<Long, List<OrgInfo>> entry : collectTemp.entrySet()) {
                Long orgId = entry.getKey();
                String orgName = entry.getValue().get(0).getName();
                errStrategyId.add(orgId);
                List orDefault = result.getOrDefault(orgId, Lists.newArrayList());
                String entryStrategyTip = entry.getValue().stream().map(orgInfo -> String.join((CharSequence)",", orgInfo.getBusinessStrayRefList())).collect(Collectors.joining(","));
                String strategyTip = HRBUValidationService.getStrategyTip(entryStrategyTip);
                if (orDefault.size() == 0) {
                    orDefault.add("\u201c" + orgName + "\u201d" + strategyTip);
                } else {
                    orDefault.add(strategyTip);
                }
                result.put(orgId, orDefault);
            }
        }
        List<OrgInfo> passedStrayOrgInfo = childViewOrgInfo.stream().filter(orgInfo -> !errStrategyId.contains(orgInfo.getOrgId())).collect(Collectors.toList());
        List<OrgParam> orgParamsList = HRBUValidationService.transferToOrgParam(passedStrayOrgInfo, null, null, false);
        ((IOrgService)ServiceFactory.getService(IOrgService.class)).freeze(orgParamsList);
        HRBUValidationService.handleResultOfOrgParam(result, orgParamsList);
        return result;
    }

    public static void handleResultOfOrgParam(Map<Long, List<String>> result, List<OrgParam> orgParamsList) {
        orgParamsList.stream().filter(orgParam -> !orgParam.isSuccess()).forEach(orgParam2 -> {
            List orDefault = result.getOrDefault(orgParam2.getId(), Lists.newArrayList());
            String tipTemp = StringUtils.join((Iterable)orgParam2.getMsgList(), (String)",").replaceAll(orgParam2.getNumber(), orgParam2.getName());
            if (!tipTemp.startsWith(orgParam2.getName())) {
                tipTemp = orgParam2.getName() + "\uff1a" + tipTemp;
            }
            orDefault.add(tipTemp);
            result.put(orgParam2.getId(), orDefault);
        });
    }

    public static String getTipOfFreeze(OrgInfo orgInfo) {
        return String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7ec4\u7ec7\u5df2\u4e3a\u5c01\u5b58\u72b6\u6001\u3002", (String)"HRBUValidationService_4", (String)"hrmp-hbss-business", (Object[])new Object[0]), orgInfo.getName());
    }

    public static String getTipOfUnFreeze(OrgInfo orgInfo) {
        return String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7ec4\u7ec7\u5df2\u4e3a\u89e3\u5c01\u72b6\u6001\u3002", (String)"HRBUValidationService_5", (String)"hrmp-hbss-business", (Object[])new Object[0]), orgInfo.getName());
    }

    public static Map<Long, List<String>> orgUnFreezeValidate(List<Long> orgIds, Long viewId) {
        HashMap result = Maps.newHashMap();
        ArrayList orgIdsTemp = Lists.newArrayList(orgIds);
        if (!HRBUConstants.HR_VIEW_ID.equals(viewId)) {
            List<OrgInfo> orgInfoOfBase = HRBUExtServiceHelper.getOrgInfo(orgIdsTemp, HRBUConstants.HR_VIEW_ID);
            orgInfoOfBase.stream().filter(OrgInfo::isFreeze).forEach(orgInfo -> {
                result.put(orgInfo.getOrgId(), Lists.newArrayList((Object[])new String[]{String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5f53\u524d\u7ec4\u7ec7\u7684\u201cHR\u7ba1\u7406\u7ec4\u7ec7\u201d\u804c\u80fd\u5df2\u5c01\u5b58\uff0c\u4e0d\u5141\u8bb8\u89e3\u5c01\u3002", (String)"HRBUValidationService_11", (String)"hrmp-hbss-business", (Object[])new Object[0]), orgInfo.getName())}));
                orgIdsTemp.remove(orgInfo.getOrgId());
            });
        }
        List<OrgInfo> childViewOrgInfo = HRBUExtServiceHelper.getSubOrg(orgIdsTemp, viewId, Boolean.FALSE, null);
        List<OrgInfo> isNonFreezeOrgInfo = childViewOrgInfo.stream().filter(orgInfo -> !orgInfo.isFreeze()).collect(Collectors.toList());
        isNonFreezeOrgInfo.forEach(orgInfo -> {
            if (orgInfo.getViewId().equals(viewId)) {
                result.putIfAbsent(orgInfo.getOrgId(), Lists.newArrayList((Object[])new String[]{HRBUValidationService.getTipOfUnFreeze(orgInfo)}));
            }
        });
        childViewOrgInfo.removeAll(isNonFreezeOrgInfo);
        List<OrgParam> orgParamsList = HRBUValidationService.transferToOrgParam(childViewOrgInfo, null, null, false);
        ((IOrgService)ServiceFactory.getService(IOrgService.class)).unFreeze(orgParamsList);
        HRBUValidationService.handleResultOfOrgParam(result, orgParamsList);
        return result;
    }

    public static String getStrategyTip(String strategyTypeName) {
        return String.format(ResManager.loadKDString((String)"\u5c01\u5b58\u5931\u8d25\uff0c\u5df2\u88ab\u4e1a\u52a1\u7c7b\u578b\u201c%1$s\u201d\u8bbe\u7f6e\u4e86\u7ba1\u7406\u5173\u7cfb\u7b56\u7565\u3002", (String)"HRBUValidationService_6", (String)"hrmp-hbss-business", (Object[])new Object[0]), strategyTypeName);
    }

    public static void checkOrgInfoOfFreeze(List<OrgInfo> allNodes) {
        HRBUValidationService.checkOrgInfo(allNodes, "", new LongAdder(), "", new Boolean[]{Boolean.TRUE, Boolean.FALSE}, new AtomicBoolean(false));
    }

    private static void markBusinessStrategyResult(Map<Long, Set<Long>> finalBusinessStrategyResult, Map<Long, Long> finalBusinessType2OrgTypeMap, Map<Long, DynamicObject> finalId2BusinessRefMap, OrgInfo node) {
        List collect;
        Long orgId = node.getOrgId();
        Long viewId = node.getViewId();
        Set<Long> businessTypeIds = finalBusinessStrategyResult.get(orgId);
        if (businessTypeIds != null && businessTypeIds.size() > 0 && (collect = businessTypeIds.stream().filter(ob -> ((Long)finalBusinessType2OrgTypeMap.get(ob)).longValue() == viewId.longValue()).collect(Collectors.toList())).size() > 0) {
            node.setBusinessStrayRef(true);
            node.setBusinessStrayRefList(collect.stream().map(id -> ((DynamicObject)finalId2BusinessRefMap.get(id)).getString("name")).collect(Collectors.toList()));
        }
    }

    public static Map<Long, Set<Long>> checkBusinessStrategy(Map<Long, Set<Long>> businessStrategyMap) {
        return (Map)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSStrategyService", (String)"judgeStrategyExist4HrBu", (Object[])new Object[]{businessStrategyMap});
    }

    public static Map<Long, Set<Long>> assembleBusinessStrategy(List<OrgInfo> allNodes, Map<Long, Long> businessType2OrgTypeMap, Map<Long, DynamicObject> id2BusinessRefMap) {
        HashMap orgFunRefMap = Maps.newHashMapWithExpectedSize((int)16);
        HashSet viewIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (OrgInfo org : allNodes) {
            Long orgId = org.getOrgId();
            Long viewId = org.getViewId();
            viewIdSet.add(viewId);
            orgFunRefMap.computeIfAbsent(orgId, key -> new HashSet(16)).add(viewId);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_bussinessfield");
        DynamicObjectCollection businessRefDys = serviceHelper.queryOriginalCollection("id,controlfuntype,name", new QFilter[]{new QFilter("controlfuntype", "in", (Object)viewIdSet)});
        HashMap businessRefMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject businessRef : businessRefDys) {
            Long id = businessRef.getLong("id");
            Long funTypeId = businessRef.getLong("controlfuntype");
            businessRefMap.computeIfAbsent(funTypeId, key -> new HashSet(16)).add(id);
            businessType2OrgTypeMap.put(id, funTypeId);
            id2BusinessRefMap.put(id, businessRef);
        }
        HashMap orgBusinessRefMap = Maps.newHashMapWithExpectedSize((int)16);
        orgFunRefMap.forEach((key, value) -> {
            HashSet businessRefFunIdSet = Sets.newHashSetWithExpectedSize((int)16);
            value.forEach(bfId -> {
                if (businessRefMap.get(bfId) != null) {
                    businessRefFunIdSet.addAll((Collection)businessRefMap.get(bfId));
                }
            });
            orgBusinessRefMap.put(key, businessRefFunIdSet);
        });
        return orgBusinessRefMap;
    }

    public static List<OrgInfo> transferToOrgInfo(List<OrgParam> orgParams) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)orgParams.size());
        for (OrgParam orgParam : orgParams) {
            OrgInfo orgInfo = new OrgInfo();
            orgInfo.setOrgId(Long.valueOf(orgParam.getId()));
            orgInfo.setViewId(Long.valueOf(orgParam.getDuty()));
            list.add(orgInfo);
        }
        return list;
    }

    public static List<OrgParam> transferToOrgParam(List<OrgInfo> rmOrgIds, OperationType operationType, Long orgChangeRecordId, boolean isSendRecordMsg) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)rmOrgIds.size());
        for (OrgInfo orgInfo : rmOrgIds) {
            OrgParam orgParam = map.getOrDefault(orgInfo.getOrgId(), new OrgParam());
            orgParam.setCustomOrgId(orgInfo.getOrgId().longValue());
            orgParam.setId(orgInfo.getOrgId().longValue());
            orgParam.setName(orgInfo.getName());
            orgParam.setNumber(orgInfo.getNumber());
            orgParam.setDuty(String.valueOf(orgInfo.getViewId()));
            orgParam.setOperationType(operationType);
            if (orgChangeRecordId != null) {
                orgParam.setChangeRecordId(orgChangeRecordId.longValue());
            }
            orgParam.setSendChangeRecordMsg(isSendRecordMsg);
            String dutyNum = String.valueOf(orgInfo.getViewId());
            TreeMap<String, OrgDutyView> multiViewMap = orgParam.getMultiViewMap();
            if (multiViewMap == null) {
                multiViewMap = new TreeMap<String, OrgDutyView>();
            }
            multiViewMap.put(dutyNum, new OrgDutyView(orgInfo.getParentId().longValue()));
            orgParam.setMultiViewMap(multiViewMap);
            map.put(orgInfo.getOrgId(), orgParam);
        }
        return new ArrayList<OrgParam>(map.values());
    }

    public static List<OrgParam> delOrgArrays(List<OrgInfo> rmOrgIds) {
        OrgService orgService = new OrgService();
        List<OrgParam> delParams = HRBUValidationService.transferToOrgParam(rmOrgIds, OperationType.deleteDuty, null, true);
        orgService.deleteDuty(delParams);
        return delParams;
    }

    private static Table<Long, Long, Boolean> checkBillRefResult(List<OrgInfo> allNodes, String taskId, LongAdder progress, String desc, AtomicBoolean isTaskEnd) {
        Set allBaseDataCtrl;
        Map<String, List<String>> refEntityMap;
        LOGGER.info("HRBUValidationService.checkBillRefResult(),taskId:{} begin", (Object)taskId);
        LocalCacheUtils instance = LocalCacheUtils.getInstance();
        LocalMemoryCache localCache = instance.getLocalCache();
        String cacheKey = "HRBUValidationService.checkBillRefResult_getRefEntities_" + RequestContext.get().getCurrUserId();
        Object cache = localCache.get(cacheKey);
        if (Objects.isNull(cache)) {
            DynamicObject[] refEntities = HRBUValidationService.getRefEntities();
            LOGGER.info("HRBUValidationService.checkBillRefResult() ref entity count:{}", (Object)refEntities.length);
            refEntityMap = Arrays.stream(refEntities).filter(ob -> !excludeEntities.contains(ob.getString("objecttypeid"))).collect(Collectors.groupingBy(obj -> obj.getString("objecttypeid"), Collectors.mapping(obj -> obj.getString("fieldname"), Collectors.toList())));
            localCache.put(cacheKey, refEntityMap);
        } else {
            refEntityMap = (Map<String, List<String>>)cache;
        }
        LOGGER.info("HRBUValidationService.checkBillRefResult() ref map count:{}", (Object)refEntityMap.size());
        if (isTaskEnd.get()) {
            return null;
        }
        boolean isPlatformRemove = "-1".equals(taskId);
        String cacheKey2 = "HRBUValidationService.checkBillRefResult_getAllBaseDataCtrl_" + RequestContext.get().getCurrUserId();
        Object cache2 = localCache.get(cacheKey2);
        if (Objects.isNull(cache2)) {
            allBaseDataCtrl = HRBUValidationService.getAllBaseDataCtrl(refEntityMap);
            localCache.put(cacheKey2, (Object)allBaseDataCtrl);
        } else {
            allBaseDataCtrl = (Set)cache2;
        }
        LOGGER.info("HRBUValidationService.checkBillRefResult() allBaseDataCtrl count:{}", (Object)allBaseDataCtrl.size());
        if (isTaskEnd.get()) {
            return null;
        }
        long start = System.currentTimeMillis();
        Map<Long, Set<Long>> viewMap = allNodes.stream().collect(Collectors.groupingBy(OrgInfo::getViewId, Collectors.mapping(OrgInfo::getOrgId, Collectors.toSet())));
        LOGGER.info("HRBUValidationService.checkBillRefResult() viewMap:{}", viewMap);
        ExecutorCompletionService<Table<Long, Long, Boolean>> completionService = new ExecutorCompletionService<Table<Long, Long, Boolean>>(executorService);
        int batchSize = 20;
        int size = refEntityMap.size();
        int mod = size / batchSize;
        ArrayList futureList = Lists.newArrayListWithExpectedSize((int)size);
        for (Map.Entry<String, List<String>> entry : refEntityMap.entrySet()) {
            futureList.add(completionService.submit(new BillRefChecker(entry.getKey(), entry.getValue(), viewMap, allBaseDataCtrl.contains(entry.getKey()))));
        }
        long checkTimeOut = HRBUValidationService.getCheckTimeOut();
        HashBasedTable result = HashBasedTable.create();
        for (int idx = 1; idx <= size; ++idx) {
            if (isTaskEnd.get()) {
                ThreadPools.executeOnce((String)"kd.hr.hbss.bussiness.service.hrbu.HRBUValidationService.checkBillRefResult", () -> futureList.forEach(future -> future.cancel(true)));
                break;
            }
            try {
                Table resList;
                if (idx % mod == 0) {
                    progress.add(4L);
                    HRBUValidationService.feedbackProgress(progress.intValue(), desc, taskId);
                }
                if ((resList = (Table)completionService.take().get(checkTimeOut, TimeUnit.MILLISECONDS)) == null || resList.isEmpty()) continue;
                result.putAll(resList);
                resList.clear();
                if (!isPlatformRemove) continue;
                break;
            }
            catch (Exception exc) {
                LOGGER.error("HRBUValidationService.checkBillRefResult() error taskId={}; info:{}", (Object)taskId, (Object)exc);
                throw new KDBizException("hrbu validation error\uff1a" + exc.getMessage());
            }
        }
        long end = System.currentTimeMillis();
        LOGGER.info("HRBUValidationService.checkBillRefResult() elapsed time:{}", (Object)(end - start));
        return result;
    }

    private static Set<String> getAllBaseDataCtrl(Map<String, List<String>> refEntityMap) {
        Set<String> entityNumbers = refEntityMap.keySet();
        HashSet<String> baseDataCtrl = new HashSet<String>(entityNumbers.size());
        String selectFields = "id,basedataid";
        QFilter basedataFilter = new QFilter("basedataid", "in", entityNumbers);
        Map defaultCtrlStrtgy = BusinessDataServiceHelper.loadFromCache((String)"bd_bddefctrlstrtgy", (String)selectFields, (QFilter[])new QFilter[]{basedataFilter});
        if (defaultCtrlStrtgy != null) {
            defaultCtrlStrtgy.values().forEach(dy -> baseDataCtrl.add(dy.getString("basedataid.number")));
        }
        return baseDataCtrl;
    }

    public static Map<Object, DynamicObject> getBizCheckers(String operation, String extNumber) {
        String selectFields = "id,number,view,operation,app,servicefactory,servicename";
        QFilter opFilter = new QFilter("operation", "=", (Object)operation);
        opFilter.and("number", "!=", (Object)extNumber);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        Set<Long> versionView = HRBUValidationService.getVersionView();
        QFilter viewFilter = new QFilter("view.id", "in", versionView);
        QFilter[] filters = new QFilter[]{opFilter, enableFilter, viewFilter};
        return BusinessDataServiceHelper.loadFromCache((String)"bos_org_checkerregister", (String)selectFields, (QFilter[])filters);
    }

    private static long getCheckTimeOut() {
        int timeout = 10000;
        String buildTimeout = System.getProperty("hrbu.validation.timeout");
        if (!HRStringUtils.isEmpty((String)buildTimeout)) {
            timeout = Integer.parseInt(buildTimeout);
        }
        return timeout;
    }

    private static String getPermOrgFuncId(MainEntityType dataEntityType, String orgFieldKey) {
        String finalBuCaFuncId = null;
        DynamicProperty typeProperty = dataEntityType.getProperty(orgFieldKey);
        if (typeProperty instanceof OrgProp) {
            finalBuCaFuncId = ((OrgProp)typeProperty).getOrgFunc();
        }
        return finalBuCaFuncId;
    }

    private static DynamicObject[] getRefEntities() {
        HRBaseServiceHelper cloudHelper = new HRBaseServiceHelper("hbss_cloud");
        DynamicObject[] clouds = cloudHelper.queryOriginalArray("cloud", new QFilter[]{QFilter.of((String)"1=1", (Object[])new Object[0])});
        Set cloudIdSet = Arrays.stream(clouds).map(el -> el.getString("cloud")).collect(Collectors.toSet());
        QFilter idFilter = new QFilter("bizcloud", "in", cloudIdSet);
        QFilter statusFilter = new QFilter("deploystatus", "=", (Object)"2");
        HRBaseServiceHelper appHelper = new HRBaseServiceHelper("bos_devportal_bizapp");
        DynamicObject[] appIds = appHelper.queryOriginalArray("id", new QFilter[]{idFilter, statusFilter});
        Set appIdSet = Arrays.stream(appIds).map(el -> el.getString("id")).collect(Collectors.toSet());
        HRBaseServiceHelper entityHelper = new HRBaseServiceHelper("bos_devp_formmeta");
        DynamicObject[] entityIds = entityHelper.queryOriginalArray("number", new QFilter[]{new QFilter("bizappid", "in", appIdSet), new QFilter("istemplate", "=", (Object)"0"), new QFilter("modeltype", "in", (Object)Sets.newHashSet((Object[])new String[]{"DynamicFormModel", "BillFormModel", "BaseFormModel", "MobileFormModel", "MobileBillFormModel"})), new QFilter("number", "not like", (Object)"%query")});
        Set entityIdSet = Arrays.stream(entityIds).map(el -> el.getString("number")).collect(Collectors.toSet());
        HRBaseServiceHelper entityRefHelper = new HRBaseServiceHelper("bos_objecttyperef");
        return entityRefHelper.queryOriginalArray("objecttypeid,fieldname", new QFilter[]{new QFilter("frefobjecttypeid", "=", (Object)"bos_org"), new QFilter("objecttypeid", "in", entityIdSet), new QFilter("tablename", "!=", (Object)" ")});
    }

    public static void feedbackProgress(int progress, String desc, String taskId) {
        if (taskId.equals("-1")) {
            return;
        }
        if (progress > 100) {
            progress = 100;
        }
        MessageInfo message = MessageCreator.createProgressMessage((String)taskId, (int)progress, (String)desc, null);
        ScheduleService.getInstance().getObjectFactory().getMessageSender().send(message);
    }

    public static void initRefData(OrgInfo org, StringBuilder content) {
        if (org.isBusinessStrayRef()) {
            content.append("\u201c").append(org.getName()).append("\u201d").append(ResManager.loadKDString((String)"\u5df2\u88ab\u4e1a\u52a1\u7c7b\u578b", (String)"HRBUValidationService_7", (String)"hrmp-hbss-business", (Object[])new Object[0]));
            int size = org.getBusinessStrayRefList().size();
            for (int idx = 0; idx < size; ++idx) {
                content.append("\u201c").append((String)org.getBusinessStrayRefList().get(idx)).append("\u201d");
                if (idx == size - 1) continue;
                content.append("\u3001");
            }
            content.append(ResManager.loadKDString((String)"\u8bbe\u7f6e\u4e86\u4e1a\u52a1\u7ba1\u7406\u5173\u7cfb\u7b56\u7565\uff0c\u4e0d\u5141\u8bb8\u79fb\u9664\u3002", (String)"HRBUValidationService_8", (String)"hrmp-hbss-business", (Object[])new Object[0]));
        }
        if (org.isBusinessDataRef()) {
            content.append("\u201c").append(org.getName()).append("\u201d").append(ResManager.loadKDString((String)"\u79fb\u9664\u5931\u8d25\uff0c\u5df2\u88ab\u4e1a\u52a1\u6570\u636e\u5f15\u7528\u3002", (String)"HRBUValidationService_9", (String)"hrmp-hbss-business", (Object[])new Object[0]));
        }
        if (org.isFreeze()) {
            content.append("\u201c").append(org.getName()).append("\u201d").append(ResManager.loadKDString((String)"\u79fb\u9664\u5931\u8d25\uff0c\u8be5\u7ec4\u7ec7\u5df2\u5c01\u5b58\u3002", (String)"HRBUValidationService_10", (String)"hrmp-hbss-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.isNotEmpty((String)org.getBizMsg())) {
            content.append(org.getName()).append("\uff1a").append(org.getBizMsg());
        }
    }

    public static QFilter getVersionQFilter() {
        return new QFilter("id", "in", HRBUValidationService.getVersionView());
    }

    public static Set<Long> getVersionView() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hbss_hrbucafunc");
        DynamicObject vs = helper.queryOne((Object)618L);
        if (Objects.isNull(vs)) {
            return Sets.newHashSet();
        }
        String number = vs.getString("number");
        String[] split = number.split(",");
        HashSet set = Sets.newHashSetWithExpectedSize((int)16);
        for (String view : split) {
            Long viewId = Long.parseLong(view);
            set.add(viewId);
        }
        return set;
    }

    public static String[] getHideTag() {
        Map<Long, String> viewMap = HRBuSync.getViewMap();
        Set<Long> versionView = HRBUValidationService.getVersionView();
        for (Long view : versionView) {
            viewMap.remove(view);
        }
        return viewMap.values().toArray(new String[0]);
    }

    private static class BillRefChecker
    implements Callable<Table<Long, Long, Boolean>> {
        private String entityNumber;
        private boolean isBaseDataCtrl;
        private List<String> fieldNameList;
        private Map<Long, Set<Long>> viewMap;
        private RequestContext context = RequestContext.get();

        BillRefChecker(String entityNumber, List<String> fieldNameList, Map<Long, Set<Long>> viewMap, boolean isBaseDataCtrl) {
            this.entityNumber = entityNumber;
            this.fieldNameList = fieldNameList;
            this.viewMap = viewMap;
            this.isBaseDataCtrl = isBaseDataCtrl;
        }

        @Override
        public Table<Long, Long, Boolean> call() {
            try {
                return this.getOrgInfos();
            }
            catch (Exception exc) {
                LOGGER.error("BillRefChecker error entity: {}, error info:{}", (Object)this.entityNumber, (Object)exc);
                return null;
            }
        }

        private Table<Long, Long, Boolean> getOrgInfos() {
            Set orgIdSet;
            RequestContext.copyAndSet((RequestContext)this.context);
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.entityNumber);
            if (HRStringUtils.isEmpty((String)dataEntityType.getAlias())) {
                return null;
            }
            QFilter qFilter = null;
            ArrayList<String> fields = new ArrayList<String>(this.fieldNameList.size());
            HashMap<String, Set> fieldOrgIds = new HashMap<String, Set>(this.fieldNameList.size());
            HashMap<String, Long> fieldViewIds = new HashMap<String, Long>(this.fieldNameList.size());
            if (this.isBaseDataCtrl) {
                this.fieldNameList.remove("fuseorg");
                this.fieldNameList.remove("forg");
            }
            Map<String, String> dbField2Field = dataEntityType.getFields().values().stream().filter(prop -> StringUtils.isNotBlank((CharSequence)prop.getAlias())).collect(Collectors.toMap(IMetadata::getAlias, IMetadata::getName, (x1, x2) -> x1));
            for (String fName : this.fieldNameList) {
                Long viewId;
                String funId;
                String field = dbField2Field.get(fName);
                if (HRStringUtils.isEmpty((String)field) || HRStringUtils.isEmpty((String)(funId = HRBUValidationService.getPermOrgFuncId(dataEntityType, field))) || (orgIdSet = this.viewMap.get(viewId = Long.valueOf(funId))) == null || orgIdSet.size() == 0) continue;
                fieldOrgIds.put(field, orgIdSet);
                fieldViewIds.put(field, viewId);
                fields.add(field);
                if (qFilter == null) {
                    qFilter = new QFilter(field, "in", orgIdSet);
                    continue;
                }
                qFilter.or(new QFilter(field, "in", (Object)orgIdSet));
            }
            if (qFilter == null) {
                return null;
            }
            HRBaseServiceHelper entitySingleHelper = new HRBaseServiceHelper(this.entityNumber);
            DataSet orgDataSet = fieldOrgIds.size() == 1 && ((Set)fieldOrgIds.values().iterator().next()).size() == 1 ? entitySingleHelper.queryDataSet("HRBUValidationService.BillRefChecker.getOrgInfos_" + this.entityNumber, String.join((CharSequence)",", fields), new QFilter[]{qFilter}, "id", 1) : entitySingleHelper.queryDataSet("HRBUValidationService.BillRefChecker.getOrgInfos_" + this.entityNumber, String.join((CharSequence)",", fields), new QFilter[]{qFilter});
            if (orgDataSet == null || !orgDataSet.hasNext()) {
                return null;
            }
            HashBasedTable result = HashBasedTable.create();
            for (String field : fields) {
                orgIdSet = (Set)fieldOrgIds.get(field);
                ArrayList<Long> tempOrgIdList = new ArrayList<Long>(16);
                while (orgDataSet.hasNext()) {
                    Long orgId = orgDataSet.next().getLong(field);
                    if (orgId == null || orgId.equals(0L) || tempOrgIdList.contains(orgId) || !orgIdSet.contains(orgId)) continue;
                    tempOrgIdList.add(orgId);
                    Long viewId = (Long)fieldViewIds.get(field);
                    result.put((Object)orgId, (Object)viewId, (Object)Boolean.TRUE);
                }
            }
            return result;
        }
    }
}

