/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.bussiness.service.hrbu;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.api.IOrgBizChecker;
import kd.bos.org.api.IOrgService;
import kd.bos.org.model.OrgParam;
import kd.bos.service.ServiceFactory;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbss.bussiness.service.hrbu.HRBUValidationService;
import kd.hr.hbss.bussiness.servicehelper.HRBUExtServiceHelper;
import kd.hr.hbss.common.constants.HRBUConstants;
import kd.hr.hbss.common.model.OrgInfo;

@ExcludeFromJacocoGeneratedReport
public class HROrgFreezeChecker
implements IOrgBizChecker {
    private static final Log LOGGER = LogFactory.getLog(HROrgFreezeChecker.class);

    public Map<Long, Map<Long, Set<String>>> validate(long viewId, List<Long> orgIds, Map<String, Object> operationParams) {
        HashMap result = Maps.newHashMap();
        try {
            Long orgChangeRecordId = Long.valueOf(String.valueOf(operationParams.get("orgChangeRecordId")));
            List<OrgInfo> orgInfoList = HRBUExtServiceHelper.getSubOrg(orgIds, HRBUConstants.HR_VIEW_ID, Boolean.FALSE, "0");
            HRBUValidationService.checkOrgInfoOfFreeze(orgInfoList);
            HashSet errStrategyId = Sets.newHashSetWithExpectedSize((int)orgInfoList.size());
            Map<Long, List<OrgInfo>> collectTemp = orgInfoList.stream().filter(OrgInfo::isBusinessStrayRef).collect(Collectors.groupingBy(OrgInfo::getOrgId));
            if (collectTemp != null && collectTemp.size() > 0) {
                for (Map.Entry<Long, List<OrgInfo>> entry : collectTemp.entrySet()) {
                    Long orgId = entry.getKey();
                    errStrategyId.add(orgId);
                    String entryStrategyTip = entry.getValue().stream().map(orgInfo -> String.join((CharSequence)",", orgInfo.getBusinessStrayRefList())).collect(Collectors.joining(","));
                    String strategyTip = HRBUValidationService.getStrategyTip(entryStrategyTip);
                    Map orDefault = result.getOrDefault(orgId, Maps.newHashMap());
                    Set orDefault1 = orDefault.getOrDefault(HRBUConstants.HR_VIEW_ID, Sets.newHashSet());
                    orDefault1.add(strategyTip);
                    orDefault.put(HRBUConstants.HR_VIEW_ID, orDefault1);
                    result.put(orgId, orDefault);
                }
            }
            List<OrgInfo> passedStrayOrgInfo = orgInfoList.stream().filter(orgInfo -> !errStrategyId.contains(orgInfo.getOrgId()) && HRBUConstants.HR_VIEW_ID.longValue() != orgInfo.getViewId().longValue()).collect(Collectors.toList());
            List<OrgParam> orgParamsList = HRBUValidationService.transferToOrgParam(passedStrayOrgInfo, null, orgChangeRecordId, false);
            ((IOrgService)ServiceFactory.getService(IOrgService.class)).freeze(orgParamsList);
            Set collect = orgParamsList.stream().filter(orgParam -> !orgParam.isSuccess()).map(OrgParam::getId).collect(Collectors.toSet());
            passedStrayOrgInfo.stream().filter(orgInfo -> collect.contains(orgInfo.getOrgId())).forEach(orgInfo2 -> {
                Map orDefault = result.getOrDefault(orgInfo2.getOrgId(), Maps.newHashMap());
                Set orDefault1 = orDefault.getOrDefault(HRBUConstants.HR_VIEW_ID, Sets.newHashSet());
                if (orDefault1.size() == 0) {
                    orDefault1.add(ResManager.loadKDString((String)"HR\u5b50\u804c\u80fd\u7ec4\u7ec7\u5c01\u5b58\u5931\u8d25\uff0c\u4e0d\u5141\u8bb8\u5c01\u5b58HR\u7ba1\u7406\u7ec4\u7ec7\u3002", (String)"HROrgFreezeChecker_0", (String)"hrmp-hbss-business", (Object[])new Object[0]));
                    orDefault.put(HRBUConstants.HR_VIEW_ID, orDefault1);
                    result.put(orgInfo2.getOrgId(), orDefault);
                }
            });
        }
        catch (Exception exception) {
            LOGGER.error("HROrgFreezeChecker.checkBizClear() error:", (Throwable)exception);
            Map orDefault = result.getOrDefault(orgIds.get(0), Maps.newHashMap());
            Set orDefault1 = orDefault.getOrDefault(HRBUConstants.HR_VIEW_ID, Sets.newHashSet());
            orDefault1.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u804c\u80fd\u5c01\u5b58\u62a5\u9519\uff0c\u9519\u8bef\u539f\u56e0\uff1a%1$s", (String)"HROrgFreezeChecker_1", (String)"hrmp-hbss-business", (Object[])new Object[0]), exception.getMessage()));
            orDefault.put(HRBUConstants.HR_VIEW_ID, orDefault1);
            result.put(orgIds.get(0), orDefault);
        }
        return result;
    }
}

