/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.bussiness.service.hrbu;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.api.IOrgBizChecker;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbss.bussiness.service.hrbu.HRBUValidationService;
import kd.hr.hbss.bussiness.servicehelper.HRBUExtServiceHelper;
import kd.hr.hbss.common.constants.HRBUConstants;
import kd.hr.hbss.common.model.OrgInfo;
import kd.hr.hbss.common.util.LocalCacheUtils;
import org.apache.commons.lang3.StringUtils;

@ExcludeFromJacocoGeneratedReport
public class HROrgUnfreezeChecker
implements IOrgBizChecker {
    private static final Log LOGGER = LogFactory.getLog(HROrgUnfreezeChecker.class);

    public Map<Long, Map<Long, Set<String>>> validate(long viewId, List<Long> orgIds, Map<String, Object> operationParams) {
        HashMap result = Maps.newHashMap();
        String tip = ResManager.loadKDString((String)"\u540c\u6b65\u7b56\u7565\u4e3a\u201c\u4e0eHR\u7ba1\u7406\u7ec4\u7ec7\u4fdd\u6301\u4e00\u81f4\u201d\u7684HR\u5b50\u804c\u80fd\u7ec4\u7ec7\u89e3\u5c01\u5931\u8d25\uff0c\u4e0d\u5141\u8bb8\u89e3\u5c01HR\u7ba1\u7406\u7ec4\u7ec7\u3002", (String)"HROrgUnfreezeChecker_0", (String)"hrmp-hbss-business", (Object[])new Object[0]);
        try {
            List<OrgInfo> orgInfoList = HRBUExtServiceHelper.getReferOrgInfo(orgIds, HRBUConstants.HR_VIEW_ID, "1");
            ArrayListMultimap viewId2OrgIds = ArrayListMultimap.create();
            orgInfoList.forEach(orgInfo -> viewId2OrgIds.put((Object)orgInfo.getViewId(), (Object)orgInfo.getOrgId()));
            LOGGER.info("HROrgUnfreezeChecker.validate_viewId2OrgIds :{}", (Object)viewId2OrgIds);
            Collection<DynamicObject> values = HRBUValidationService.getBizCheckers("bizunfreeze", "HROrgUnfreezeChecker").values();
            LOGGER.info("HROrgUnfreezeChecker.validate_getBizCheckers:{}", values);
            for (DynamicObject checkerObj : values) {
                long childViewId = checkerObj.getLong("view.id");
                if (!viewId2OrgIds.containsKey((Object)childViewId)) continue;
                String viewName = checkerObj.getString("view.name");
                Map<Long, Map<Long, Set<String>>> checkResult = HRBUValidationService.invokerBizChecker((ArrayListMultimap<Long, Long>)viewId2OrgIds, checkerObj, childViewId);
                if (!Objects.nonNull(checkResult) || checkResult.size() <= 0) continue;
                checkResult.forEach((key, value) -> {
                    Map orDefault = result.getOrDefault(key, Maps.newHashMap());
                    Set orDefault1 = orDefault.getOrDefault(viewId, Sets.newLinkedHashSet());
                    if (orDefault1.size() == 0) {
                        orDefault1.add(tip);
                    }
                    Set checkResultTemp = (Set)value.get(childViewId);
                    orDefault1.add("\u3010".concat(viewName).concat("\u3011").concat(StringUtils.join((Iterable)checkResultTemp, (String)";")));
                    orDefault.put(viewId, orDefault1);
                    result.put(key, orDefault);
                });
            }
            LocalCacheUtils instance = LocalCacheUtils.getInstance();
            LocalMemoryCache localCache = instance.getLocalCache();
            localCache.put(instance.getOrgUnFreezeCacheKey(orgIds), (Object)"1");
        }
        catch (Exception exception) {
            LOGGER.error("HROrgUnfreezeChecker.checkBizClear(),validate:", (Throwable)exception);
            Map orDefault = result.getOrDefault(orgIds.get(0), Maps.newHashMap());
            Set orDefault1 = orDefault.getOrDefault(HRBUConstants.HR_VIEW_ID, Sets.newHashSet());
            orDefault1.add(String.format(ResManager.loadKDString((String)"\u804c\u80fd\u89e3\u5c01\u62a5\u9519\uff0c\u9519\u8bef\u539f\u56e0\uff1a%1$s", (String)"HROrgUnfreezeChecker_1", (String)"hrmp-hbss-business", (Object[])new Object[0]), exception.getCause().getMessage()));
            orDefault.put(HRBUConstants.HR_VIEW_ID, orDefault1);
            result.put(orgIds.get(0), orDefault);
        }
        return result;
    }
}

