/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.bussiness.servicehelper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbss.bussiness.service.hrbu.HRBUSyncStrategyService;
import kd.hr.hbss.bussiness.service.hrbu.HRBUValidationService;
import kd.hr.hbss.common.constants.HRBUConstants;
import kd.hr.hbss.common.model.OrgInfo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;

public class HRBUExtServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(HRBUExtServiceHelper.class);
    private static final String FIELD_BOSORG_ID = "bosorg.id";
    private static final String FIELD_BOS_ORG_STRUCTURE_ID = "bosorgstructure.id";
    private static final String FIELD_NUMBER = "number";
    private static final String FIELD_ORG_ID = "org.id";
    private static final String FIELD_VIEW_ID = "view.id";
    private static final String ORDER_STATEMENT_LEVEL_ASC = "level asc";
    private static final String FIELD_VIEW_NUMBER = "view.number";
    private static final String LEVEL = "level ";
    private static final String SELECT_FIELDS = "id,org.name,org.number,parent.id,longnumber,view.name,view.number,view.id,org.id,level,enable,isfreeze";

    public static DynamicObject getHrbuExtByQueryListId(Object bosOrgId) {
        HRBaseServiceHelper hrbuExtHelper = new HRBaseServiceHelper("hbss_hrbuext");
        QFilter bosOrgFilter = new QFilter(FIELD_BOSORG_ID, "=", bosOrgId);
        return hrbuExtHelper.queryOne(new QFilter[]{bosOrgFilter});
    }

    public static DynamicObject getHrBuViewExtByQueryListId(Object bosOrgStructureId) {
        HRBaseServiceHelper hrbuExtHelper = new HRBaseServiceHelper("hbss_hrbuviewext");
        QFilter bosOrgFilter = new QFilter(FIELD_BOS_ORG_STRUCTURE_ID, "=", bosOrgStructureId);
        return hrbuExtHelper.queryOne("description", new QFilter[]{bosOrgFilter});
    }

    public static String getViewNumberById(Object viewId) {
        String viewNumber = "";
        HRBaseServiceHelper viewSchemaHelper = new HRBaseServiceHelper("bos_org_viewschema");
        DynamicObject viewDy = viewSchemaHelper.queryOriginalOne(FIELD_NUMBER, viewId);
        if (null != viewDy) {
            viewNumber = viewDy.getString(FIELD_NUMBER);
        }
        return viewNumber;
    }

    public static long getViewIdByNumberId(Object viewNumberId) {
        long viewId = 0L;
        HRBaseServiceHelper viewSchemaHelper = new HRBaseServiceHelper("bos_org_viewschema");
        QFilter viewFilter = new QFilter(FIELD_NUMBER, "=", viewNumberId);
        DynamicObject viewDy = viewSchemaHelper.queryOne("view", new QFilter[]{viewFilter});
        if (null != viewDy) {
            viewId = viewDy.getLong("id");
        }
        return viewId;
    }

    public static DynamicObject getBosOrgStructureParentId(Object orgId) {
        HRBaseServiceHelper hrbuExtHelper = new HRBaseServiceHelper("bos_org_structure");
        if (null == orgId) {
            orgId = 0L;
        }
        QFilter bosOrgFilter = new QFilter(FIELD_ORG_ID, "=", orgId);
        QFilter viewFilter = new QFilter(FIELD_VIEW_ID, "=", (Object)Long.valueOf("11"));
        bosOrgFilter.and(viewFilter);
        return hrbuExtHelper.queryOne("org,parent", new QFilter[]{bosOrgFilter}, ORDER_STATEMENT_LEVEL_ASC);
    }

    public static DynamicObject getBosOrgById(Object orgId) {
        HRBaseServiceHelper hrbuExtHelper = new HRBaseServiceHelper("bos_org");
        return hrbuExtHelper.queryOne("id,number,name,simplename,fcomment,parent,fishr,fishrod,fishrop,fishrbg,fishrtr,fishrpa,fishrwt,fishrcmp,fishrbs,fishrpay,fishrtax,fishrsi,fishrlti,fishrbm,fishrtd,fishrtl,fishrip,fishrssc", orgId);
    }

    public static TreeNode getRootOrgByViewId(Long orgViewId) {
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewId(orgViewId.longValue());
        return OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
    }

    public static void setModelValue(IDataModel dataModel, DynamicObject bosOrgDy) {
        dataModel.setValue("fishr", (Object)bosOrgDy.getString("fishr"));
        dataModel.setValue("fishrod", (Object)bosOrgDy.getString("fishrod"));
        dataModel.setValue("fishrop", (Object)bosOrgDy.getString("fishrop"));
        dataModel.setValue("fishrbg", (Object)bosOrgDy.getString("fishrbg"));
        dataModel.setValue("fishrtr", (Object)bosOrgDy.getString("fishrtr"));
        dataModel.setValue("fishrpa", (Object)bosOrgDy.getString("fishrpa"));
        dataModel.setValue("fishrwt", (Object)bosOrgDy.getString("fishrwt"));
        dataModel.setValue("fishrcmp", (Object)bosOrgDy.getString("fishrcmp"));
        dataModel.setValue("fishrbs", (Object)bosOrgDy.getString("fishrbs"));
        dataModel.setValue("fishrpay", (Object)bosOrgDy.getString("fishrpay"));
        dataModel.setValue("fishrtax", (Object)bosOrgDy.getString("fishrtax"));
        dataModel.setValue("fishrsi", (Object)bosOrgDy.getString("fishrsi"));
        dataModel.setValue("fishrlti", (Object)bosOrgDy.getString("fishrlti"));
        dataModel.setValue("fishrbm", (Object)bosOrgDy.getString("fishrbm"));
        dataModel.setValue("fishrtd", (Object)bosOrgDy.getString("fishrtd"));
        dataModel.setValue("fishrtl", (Object)bosOrgDy.getString("fishrtl"));
        dataModel.setValue("fishrip", (Object)bosOrgDy.getString("fishrip"));
        dataModel.setValue("fishrssc", (Object)bosOrgDy.getString("fishrssc"));
    }

    public static DynamicObject[] getAllBosOrgStructureByView(Object bosViewId) {
        HRBaseServiceHelper bosOrgStructureHelper = new HRBaseServiceHelper("bos_org_structure");
        QFilter viewFilter = new QFilter(FIELD_VIEW_ID, "=", bosViewId);
        return bosOrgStructureHelper.query("org", new QFilter[]{viewFilter}, ORDER_STATEMENT_LEVEL_ASC);
    }

    public static Map<String, DynamicObject> getBosOrgStructByBosOrg(List<String> bosViewNumbers, List<Long> bosOrgIds) {
        HRBaseServiceHelper bosOrgStructureHelper = new HRBaseServiceHelper("bos_org_structure");
        QFilter bosOrgIdFilter = new QFilter(FIELD_ORG_ID, "in", bosOrgIds);
        QFilter viewFilter = new QFilter(FIELD_VIEW_NUMBER, "in", bosViewNumbers);
        bosOrgIdFilter.and(viewFilter);
        DynamicObject[] structures = bosOrgStructureHelper.query("view.number,org.id", new QFilter[]{bosOrgIdFilter});
        HashMap viewNumberOrgIdToStructureMap = Maps.newHashMapWithExpectedSize((int)structures.length);
        for (DynamicObject structure : structures) {
            viewNumberOrgIdToStructureMap.put(structure.getString(FIELD_VIEW_NUMBER) + "!" + structure.getString(FIELD_ORG_ID), structure);
        }
        return viewNumberOrgIdToStructureMap;
    }

    public static DynamicObject[] getBosOrgStructuresByBosOrgs(List<Object> bosOrgIdList) {
        HRBaseServiceHelper bosOrgStructureHelper = new HRBaseServiceHelper("bos_org_structure");
        QFilter bosOrgIdFilter = new QFilter("id", "in", bosOrgIdList);
        return bosOrgStructureHelper.query("org", new QFilter[]{bosOrgIdFilter}, ORDER_STATEMENT_LEVEL_ASC);
    }

    public static List<Long> transferOrgStructId2OrgId(List<Object> bosOrgStructIdList) {
        DynamicObject[] dynamicObjects = HRBUExtServiceHelper.getBosOrgStructuresByBosOrgs(bosOrgStructIdList);
        return Arrays.stream(dynamicObjects).map(dy -> dy.getLong(FIELD_ORG_ID)).collect(Collectors.toList());
    }

    public static DynamicObject[] getAllBosOrgStructureByViewsAndStructures(List<Object> viewIdList, List<Object> orgIdList, String levelSort) {
        HRBaseServiceHelper bosOrgStructureHelper = new HRBaseServiceHelper("bos_org_structure");
        QFilter bosOrgIdFilter = new QFilter(FIELD_ORG_ID, "in", orgIdList);
        QFilter viewIdFilter = new QFilter(FIELD_VIEW_ID, "in", viewIdList);
        bosOrgIdFilter = bosOrgIdFilter.and(viewIdFilter);
        return bosOrgStructureHelper.query("org.id,view.id,view.number,parent,status,enable,isfreeze", new QFilter[]{bosOrgIdFilter}, LEVEL + levelSort);
    }

    public static Object[] updateHRBUExtView(DynamicObject[] dy) {
        return new HRBaseServiceHelper("hbss_hrbuviewext").update(dy);
    }

    public static DynamicObject[] setBosViewDys(ListSelectedRowCollection collection, String viewNumber, Long baseViewId, Object topNodeId) {
        Object[] bosOrgIds = collection.getPrimaryKeyValues();
        HRBaseServiceHelper bosOrgHelper = new HRBaseServiceHelper("bos_org_structure");
        QFilter idFilter = new QFilter(FIELD_ORG_ID, "in", (Object)bosOrgIds);
        QFilter viewFilter = new QFilter(FIELD_VIEW_ID, "=", (Object)baseViewId);
        idFilter.and(viewFilter);
        DynamicObject[] bosOrgStructureDys = bosOrgHelper.query("org,parent,fcomment,longnumber", new QFilter[]{idFilter});
        if (null == bosOrgStructureDys || 0 == bosOrgStructureDys.length) {
            return null;
        }
        HashSet childIds = Sets.newHashSetWithExpectedSize((int)collection.size());
        HRBaseServiceHelper editEntityHelper = new HRBaseServiceHelper("hbss_hrbuviewext");
        DynamicObject[] hrbuExtViewDys = new DynamicObject[collection.size()];
        for (int i = 0; i < hrbuExtViewDys.length; ++i) {
            DynamicObject bosOrgStructureDy = bosOrgStructureDys[i];
            hrbuExtViewDys[i] = editEntityHelper.generateEmptyDynamicObject();
            DynamicObject currentOrgDy = bosOrgStructureDy.getDynamicObject("org");
            childIds.add(currentOrgDy.getLong("id"));
            hrbuExtViewDys[i].set("parentorg", (Object)bosOrgStructureDy.getLong("parent.id"));
            hrbuExtViewDys[i].set("viewnumber", (Object)viewNumber);
            hrbuExtViewDys[i].set("description", (Object)bosOrgStructureDy.getLocaleString("org.fcomment"));
            hrbuExtViewDys[i].set("bosorgstructure", (Object)bosOrgStructureDy);
        }
        for (DynamicObject extViewDy : hrbuExtViewDys) {
            if (childIds.contains(extViewDy.getLong("parentorg"))) continue;
            if (Objects.isNull(topNodeId)) {
                TreeNode rootOrgByViewId = HRBUExtServiceHelper.getRootOrgByViewId(baseViewId);
                topNodeId = rootOrgByViewId.getId();
            }
            extViewDy.set("parentorg", (Object)Long.valueOf(String.valueOf(topNodeId)));
        }
        return hrbuExtViewDys;
    }

    public static DynamicObject getHrBuCaDyById(long id) {
        HRBaseServiceHelper viewSchemaHelper = new HRBaseServiceHelper("hbss_hrbuca");
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        return viewSchemaHelper.queryOne("id,parent,finalparent,syncstrategy,issyspreset", new QFilter[]{idFilter});
    }

    public static DynamicObject[] getBosChildViewDyByFinalParentViewId(long parentViewId) {
        HRBaseServiceHelper hrBuCaHelper = new HRBaseServiceHelper("hbss_hrbuca");
        QFilter parentFilter = new QFilter("parent", "=", (Object)parentViewId);
        QFilter idFilter = new QFilter("id", "!=", (Object)parentViewId);
        return hrBuCaHelper.query("id,parent", new QFilter[]{idFilter, parentFilter});
    }

    public static List<Long> getSyncViewControlFuncIds() {
        HRBaseServiceHelper hrBuCaHelper = new HRBaseServiceHelper("hbss_hrbuca");
        QFilter parent = new QFilter("syncstrategy", "=", (Object)"0");
        DynamicObject[] dynamicObjects = hrBuCaHelper.queryOriginalArray("id", new QFilter[]{parent});
        return Arrays.stream(dynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toList());
    }

    public static List<Long> getChildViewIds(Long viewId) {
        List<Long> viewNumbers = new ArrayList<Long>(16);
        List<DynamicObject> childViewsList = HRBUSyncStrategyService.getChildViewDys(viewId);
        DynamicObject[] childViews = childViewsList.toArray(new DynamicObject[0]);
        if (childViews.length > 0) {
            viewNumbers = Arrays.stream(childViews).map(dy -> dy.getLong("id")).distinct().collect(Collectors.toList());
        }
        return viewNumbers;
    }

    public static DynamicObject[] getChildData(List<Long> orgIds, Long viewId) {
        QFilter fftreetype;
        if (HRBUConstants.HR_VIEW_ID.longValue() == viewId.longValue()) {
            Set<Long> versionView = HRBUValidationService.getVersionView();
            fftreetype = new QFilter(FIELD_VIEW_ID, "in", versionView);
        } else {
            List<Long> viewNumbers = HRBUExtServiceHelper.getChildViewIds(viewId);
            fftreetype = new QFilter(FIELD_VIEW_ID, "in", viewNumbers);
        }
        QFilter fforgid = new QFilter(FIELD_ORG_ID, "in", orgIds);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_org_structure");
        DynamicObject[] selfOrgs = serviceHelper.queryOriginalArray(SELECT_FIELDS, new QFilter[]{fftreetype, fforgid});
        ArrayList longNumbers = Lists.newArrayListWithExpectedSize((int)16);
        HashMap parentIdToLongNumber = Maps.newHashMapWithExpectedSize((int)selfOrgs.length);
        HashSet orgSets = Sets.newHashSetWithExpectedSize((int)selfOrgs.length);
        for (DynamicObject dy : selfOrgs) {
            parentIdToLongNumber.put(dy.getString("longnumber") + "%", dy.getLong("parent.id"));
            orgSets.add(dy.getLong(FIELD_ORG_ID));
        }
        parentIdToLongNumber.forEach((key, value) -> {
            if (!orgSets.contains(value)) {
                longNumbers.add(key);
            }
        });
        Object[] resultDy = new DynamicObject[]{};
        for (List longNumberList : Lists.partition((List)longNumbers, (int)2500)) {
            fforgid = new QFilter(FIELD_ORG_ID, "=", (Object)0);
            for (String str : longNumberList) {
                fforgid.or(new QFilter("longnumber", "like", (Object)str));
            }
            Object[] dynamicObjects = serviceHelper.queryOriginalArray(SELECT_FIELDS, new QFilter[]{fftreetype, fforgid});
            resultDy = (DynamicObject[])ArrayUtils.addAll((Object[])resultDy, (Object[])dynamicObjects);
        }
        return resultDy;
    }

    public static void saveHRBUExt(ListSelectedRowCollection bosOrgCollection) {
        if (CollectionUtils.isNotEmpty((Collection)bosOrgCollection)) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_hrbuext");
            DynamicObjectCollection hrbuExts = new DynamicObjectCollection();
            ArrayList orgIds = Lists.newArrayListWithCapacity((int)bosOrgCollection.size());
            bosOrgCollection.forEach(bos -> {
                DynamicObject hrbuExt = serviceHelper.generateEmptyDynamicObject();
                hrbuExt.set("bosorg", bos.getPrimaryKeyValue());
                orgIds.add(bos.getPrimaryKeyValue());
                hrbuExts.add((Object)hrbuExt);
            });
            serviceHelper.deleteByFilter(new QFilter[]{new QFilter("bosorg", "in", (Object)orgIds)});
            serviceHelper.save(hrbuExts);
        }
    }

    public static List<OrgInfo> getSubOrg(List<Long> orgIdList, Long viewId, Boolean isIncludeChildren, String isFreeze) {
        if (orgIdList.size() == 0) {
            return Lists.newArrayList();
        }
        DynamicObject[] childData = isIncludeChildren != false ? HRBUExtServiceHelper.getChildData(orgIdList, viewId) : HRBUExtServiceHelper.getOrgInfoOfAllView(orgIdList, viewId, isFreeze);
        List<OrgInfo> allNodes = HRBUExtServiceHelper.transferToOrgInfo(childData);
        LOGGER.info("HRBUExtServiceHelper.getSubOrg(),allNodes size:{}", (Object)allNodes.size());
        return allNodes;
    }

    public static List<OrgInfo> getReferOrgInfo(List<Long> orgIdList, Long viewId, String isFreeze) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_org_structure");
        List<Long> viewNumbers = HRBUExtServiceHelper.getChildViewIds(viewId);
        QFilter fftreetype = new QFilter(FIELD_VIEW_ID, "in", viewNumbers);
        QFilter fforgid = new QFilter(FIELD_ORG_ID, "in", orgIdList);
        QFilter isFreezeQFilter = new QFilter("isfreeze", "=", (Object)isFreeze);
        DynamicObject[] childData = serviceHelper.queryOriginalArray(SELECT_FIELDS, new QFilter[]{fftreetype, fforgid, isFreezeQFilter});
        List<OrgInfo> allNodes = HRBUExtServiceHelper.transferToOrgInfo(childData);
        LOGGER.info("HRBUExtServiceHelper.getReferOrgInfo(),allNodes:{}", allNodes);
        return allNodes;
    }

    private static List<OrgInfo> transferToOrgInfo(DynamicObject[] childData) {
        ArrayList allNodes = Lists.newArrayListWithExpectedSize((int)16);
        if (childData == null) {
            return new ArrayList<OrgInfo>();
        }
        for (DynamicObject obj : childData) {
            OrgInfo orgInfo = new OrgInfo();
            orgInfo.setName(obj.getString("org.name"));
            orgInfo.setNumber(obj.getString("org.number"));
            orgInfo.setOrgId(Long.valueOf(obj.getLong(FIELD_ORG_ID)));
            orgInfo.setViewId(Long.valueOf(obj.getLong(FIELD_VIEW_ID)));
            orgInfo.setViewName(obj.getString("view.name"));
            orgInfo.setLevel(Integer.valueOf(obj.getInt("level")));
            orgInfo.setLongNumber(obj.getString("longnumber"));
            orgInfo.setParentId(Long.valueOf(obj.getLong("parent.id")));
            orgInfo.setFreeze(obj.getBoolean("isfreeze"));
            allNodes.add(orgInfo);
        }
        return allNodes;
    }

    public static DynamicObject[] getOrgInfoOfAllView(List<Long> orgIdList, Long viewId, String isFreeze) {
        QFilter fftreetype;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_org_structure");
        if (HRBUConstants.HR_VIEW_ID.longValue() == viewId.longValue()) {
            Set<Long> versionView = HRBUValidationService.getVersionView();
            fftreetype = new QFilter(FIELD_VIEW_ID, "in", versionView);
        } else {
            List<Long> viewNumbers = HRBUExtServiceHelper.getChildViewIds(viewId);
            fftreetype = new QFilter(FIELD_VIEW_ID, "in", viewNumbers);
        }
        QFilter fforgid = new QFilter(FIELD_ORG_ID, "in", orgIdList);
        if (isFreeze != null) {
            QFilter isFreezeQFilter = new QFilter("isfreeze", "=", (Object)isFreeze);
            return serviceHelper.queryOriginalArray(SELECT_FIELDS, new QFilter[]{fftreetype, fforgid, isFreezeQFilter});
        }
        return serviceHelper.queryOriginalArray(SELECT_FIELDS, new QFilter[]{fftreetype, fforgid});
    }

    public static List<OrgInfo> getOrgInfo(List<Long> orgIdList, Long viewId) {
        DynamicObject[] selfOrgs;
        ArrayList allNodes = Lists.newArrayListWithExpectedSize((int)16);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_org_structure");
        QFilter orgFilter = new QFilter("org", "in", orgIdList);
        for (DynamicObject obj : selfOrgs = serviceHelper.queryOriginalArray(SELECT_FIELDS, new QFilter[]{new QFilter("view", "=", (Object)viewId), orgFilter})) {
            OrgInfo orgInfo = new OrgInfo();
            orgInfo.setOrgId(Long.valueOf(obj.getLong(FIELD_ORG_ID)));
            orgInfo.setName(obj.getString("org.name"));
            orgInfo.setNumber(obj.getString("org.number"));
            orgInfo.setViewId(Long.valueOf(obj.getLong(FIELD_VIEW_ID)));
            orgInfo.setViewName(obj.getString("view.name"));
            orgInfo.setLevel(Integer.valueOf(obj.getInt("level")));
            orgInfo.setLongNumber(obj.getString("longnumber"));
            orgInfo.setFreeze(obj.getBoolean("isfreeze"));
            allNodes.add(orgInfo);
        }
        return allNodes;
    }

    public static Map<Long, DynamicObject> queryAllChildrenViewRoot(Set<Long> childrenView) {
        QFilter qFilter = new QFilter(FIELD_VIEW_ID, "in", childrenView);
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        qFilter.and("isfreeze", "=", (Object)Boolean.FALSE);
        qFilter.and("parent", "=", (Object)0L);
        DynamicObject[] dynamicObjects = new HRBaseServiceHelper("bos_org_structure").query("name,number,orgpattern.id,view.number,view.id,org.id", new QFilter[]{qFilter});
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            return Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong(FIELD_VIEW_ID), Function.identity()));
        }
        return new HashMap<Long, DynamicObject>();
    }

    public static DynamicObject queryChildrenViewRootByViewId(Object childrenViewId) {
        QFilter qFilter = new QFilter(FIELD_VIEW_ID, "=", childrenViewId);
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        qFilter.and("parent", "=", (Object)0L);
        DynamicObject dynamicObject = new HRBaseServiceHelper("bos_org_structure").queryOne("name,number,orgpattern.id,view.number,view.id,org.id", new QFilter[]{qFilter});
        if (dynamicObject != null) {
            return dynamicObject;
        }
        return new DynamicObject();
    }
}

