/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.bussiness.servicehelper;

import java.util.ArrayList;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.business.util.OrgServiceUtil;
import kd.hr.hbp.common.model.basedata.LawEntityChangeDto;
import kd.hr.hbp.common.model.basedata.LawEntityDto;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class LawEntityServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(LawEntityServiceHelper.class);
    private static final String LAWENTITY = "lawentity";
    public static final String HBSS_LAWENTITY = "hbss_lawentity";
    public static final String HBSS_LAWENTITYCHG = "hbss_lawentitychg";
    public static final String HBSS_LAWENTITYUSE = "hbss_lawentityuse";
    private static final String HBSS_ENTERPRISE = "hbss_enterprise";
    private static final String HBSS_SIGNCOMPANY = "hbss_signcompany";
    private static final String HBSS_TAXUNIT = "hbss_taxunit";
    private static final String SITBS_WELFAREPAYER = "sitbs_welfarepayer";
    private static final String HSBS_PAYSUBJECT = "hsbs_paysubject";
    private static final String ENTERPRISE = "enterprise";
    private static final String SIGNCOMPANY = "signcompany";
    private static final String TAXUNIT = "taxunit";
    private static final String WELFAREPAYER = "welfarepayer";
    private static final String PAYSUBJECT = "paysubject";
    private static final String OPITEMID = "opitemid";
    private static final String RELLAWENTITYID = "rellawentityid";
    private static final int REL_FLAG_0 = 0;
    private static final int REL_FLAG_1 = 1;
    private static final int REL_FLAG_2 = 2;
    private static final boolean REL_STATUS_0 = false;
    private static final boolean REL_STATUS_1 = true;

    public static boolean queryAssocOrg() {
        long orgId = RequestContext.get().getOrgId() == 0L ? OrgServiceUtil.getHRRootOrgId() : RequestContext.get().getOrgId();
        AppParam appParam = new AppParam("XYRL3+A8Z+Z", Long.valueOf(orgId));
        Object sysParamAssocOrg = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"assocorg");
        boolean assocorg = true;
        if (!Objects.isNull(sysParamAssocOrg)) {
            assocorg = (Boolean)sysParamAssocOrg;
        }
        return assocorg;
    }

    @ExcludeFromJacocoGeneratedReport
    public static DynamicObject syncAddSignCompany(DynamicObject lawEntityDyo) {
        HRBaseServiceHelper signChService = new HRBaseServiceHelper("hbss_signcompanych");
        DynamicObject signCompanyDyo = signChService.loadDynamicObject(new QFilter[]{new QFilter(LAWENTITY, "=", lawEntityDyo.getPkValue())});
        if (signCompanyDyo == null) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(HBSS_SIGNCOMPANY);
            signCompanyDyo = serviceHelper.generateEmptyDynamicObject();
            LawEntityServiceHelper.genNewSignCompanyDyo(lawEntityDyo, signCompanyDyo);
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)HBSS_SIGNCOMPANY, (DynamicObject[])new DynamicObject[]{signCompanyDyo}, (OperateOption)OperateOption.create());
            if (!operationResult.isSuccess()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u540c\u6b65\u65b0\u589e\u8058\u7528\u5355\u4f4d\u5931\u8d25\uff1a%1$s\u3002", (String)"LawEntityServiceHelper_0", (String)"hrmp-hbss-business", (Object[])new Object[0]), ((OperateErrorInfo)((ValidateResult)operationResult.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage()));
            }
            LawEntityServiceHelper.modifyDyoStatus(serviceHelper, signCompanyDyo.getPkValue(), "C", "1");
        } else {
            LawEntityServiceHelper.modifyDyoStatus(signChService, signCompanyDyo.getPkValue(), "A", "1");
            String oprsts = lawEntityDyo.getString("oprsts");
            if ("2".equals(oprsts)) {
                LawEntityServiceHelper.signCompanyDestroy(signCompanyDyo);
            } else {
                LawEntityServiceHelper.modifySignCompany(lawEntityDyo, signCompanyDyo);
                LawEntityServiceHelper.setSignCompanyCh(signCompanyDyo);
            }
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"editsave", (String)"hbss_signcompanych", (DynamicObject[])new DynamicObject[]{signCompanyDyo}, (OperateOption)OperateOption.create());
            if (!operationResult.isSuccess()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u540c\u6b65\u53d8\u66f4\u8058\u7528\u5355\u4f4d\u5931\u8d25\uff1a%1$s", (String)"LawEntityServiceHelper_7", (String)"hrmp-hbss-business", (Object[])new Object[0]), ((OperateErrorInfo)((ValidateResult)operationResult.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage()));
            }
            LawEntityServiceHelper.modifyDyoStatus(signChService, signCompanyDyo.getPkValue(), "C", "1");
        }
        return signCompanyDyo;
    }

    @ExcludeFromJacocoGeneratedReport
    private static void setSignCompanyCh(DynamicObject signCompanyChDyo) {
        signCompanyChDyo.set("changetype", (Object)"2");
        HRBaseUtils.setModifyField((DynamicObject)signCompanyChDyo);
        signCompanyChDyo.set("changereason", (Object)ResManager.loadKDString((String)"\u6cd5\u5f8b\u5b9e\u4f53\u53d8\u66f4", (String)"LawEntityServiceHelper_6", (String)"hrmp-hbss-business", (Object[])new Object[0]));
    }

    @ExcludeFromJacocoGeneratedReport
    private static void signCompanyDestroy(DynamicObject signCompanyChDyo) {
        signCompanyChDyo.set("changetype", (Object)"1");
        signCompanyChDyo.set("ischangecon", (Object)true);
        HRBaseUtils.setModifyField((DynamicObject)signCompanyChDyo);
        signCompanyChDyo.set("changereason", (Object)ResManager.loadKDString((String)"\u6cd5\u5f8b\u5b9e\u4f53\u6ce8\u9500", (String)"LawEntityServiceHelper_17", (String)"hrmp-hbss-business", (Object[])new Object[0]));
    }

    @ExcludeFromJacocoGeneratedReport
    private static void modifyDyoStatus(HRBaseServiceHelper serviceHelper, Object dyoPk, String status, String enable) {
        DynamicObject dynamicObject = serviceHelper.queryOne(dyoPk);
        if (dynamicObject == null) {
            return;
        }
        dynamicObject.set("status", (Object)status);
        dynamicObject.set("enable", (Object)enable);
        serviceHelper.updateOne(dynamicObject);
    }

    @ExcludeFromJacocoGeneratedReport
    private static void modifySignCompany(DynamicObject lawEntityDyo, DynamicObject signCompanyDyo) {
        HRBaseUtils.setModifyField((DynamicObject)signCompanyDyo);
        signCompanyDyo.set("number", lawEntityDyo.get("number"));
        signCompanyDyo.set("name", lawEntityDyo.get("name"));
        if ("1".equals(lawEntityDyo.getString("entitytype"))) {
            signCompanyDyo.set("reorg", (Object)lawEntityDyo);
        }
        signCompanyDyo.set("representative", lawEntityDyo.get("representative"));
        signCompanyDyo.set("unifiedcode", lawEntityDyo.get("uniformsocialcreditcode"));
        signCompanyDyo.set("address", lawEntityDyo.get("address"));
        signCompanyDyo.set("contactnumber", lawEntityDyo.get("phone"));
    }

    @ExcludeFromJacocoGeneratedReport
    private static void genNewSignCompanyDyo(DynamicObject lawEntityDyo, DynamicObject signCompanyDyo) {
        LawEntityServiceHelper.modifySignCompany(lawEntityDyo, signCompanyDyo);
        DynamicObject createOrg = lawEntityDyo.getDynamicObject("createorg");
        signCompanyDyo.set("createorg", (Object)createOrg);
        signCompanyDyo.set("org", (Object)createOrg);
        signCompanyDyo.set("useorg", (Object)createOrg);
        signCompanyDyo.set("ctrlstrategy", (Object)"5");
        signCompanyDyo.set(LAWENTITY, (Object)lawEntityDyo);
        HRBaseUtils.setCreateField((DynamicObject)signCompanyDyo);
        long signCompanyPk = ORM.create().genLongId(HBSS_SIGNCOMPANY);
        signCompanyDyo.set("status", (Object)"C");
        signCompanyDyo.set("enable", (Object)"1");
        signCompanyDyo.set("id", (Object)signCompanyPk);
    }

    @ExcludeFromJacocoGeneratedReport
    public static void createLawEntity(LawEntityDto addLawEntityParam) {
        LOGGER.info("lawEntity-service-createLawEntity, param:{}", (Object)addLawEntityParam.getNumber());
        LawEntityServiceHelper.checkCreateLawEntityParam(addLawEntityParam);
        LawEntityServiceHelper.checkSignCompInfo(addLawEntityParam);
        HRBaseServiceHelper lawHelper = new HRBaseServiceHelper(HBSS_LAWENTITY);
        DynamicObject lawEntityDyo = lawHelper.generateEmptyDynamicObject();
        LawEntityServiceHelper.initEmpLawEntityInfo(lawEntityDyo);
        LawEntityServiceHelper.genLawEntityDyoByDto(addLawEntityParam, lawEntityDyo);
        LOGGER.info("lawEntity-service-createLawEntity, save LawEntityPk:{}", lawEntityDyo.getPkValue());
        OperationResult saveOpRst = OperationServiceHelper.executeOperate((String)"save", (String)HBSS_LAWENTITY, (DynamicObject[])new DynamicObject[]{lawEntityDyo}, (OperateOption)OperateOption.create());
        if (!saveOpRst.isSuccess()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65b0\u589e\u6cd5\u5f8b\u5b9e\u4f53\u5931\u8d25\uff1a%1$s", (String)"LawEntityServiceHelper_14", (String)"hrmp-hbss-business", (Object[])new Object[0]), ((OperateErrorInfo)((ValidateResult)saveOpRst.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage()));
        }
        LawEntityServiceHelper.modifyDyoStatus(lawHelper, lawEntityDyo.getPkValue(), "C", "1");
        if (addLawEntityParam.isSyncAddSignCompany()) {
            LawEntityServiceHelper.syncAddSignCompany(lawEntityDyo);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public static void changeLawEntity(LawEntityChangeDto lawEntityChangeParam) {
        LOGGER.info("lawEntity-service-changeLawEntity, param:id:{},number:{}", (Object)lawEntityChangeParam.getLawEntityId(), (Object)lawEntityChangeParam.getNumber());
        LawEntityServiceHelper.checkCreateLawEntityParam((LawEntityDto)lawEntityChangeParam);
        LawEntityServiceHelper.checkChangeParam(lawEntityChangeParam);
        HRBaseServiceHelper lawChgHelper = new HRBaseServiceHelper(HBSS_LAWENTITYCHG);
        HRBaseServiceHelper lawHelper = new HRBaseServiceHelper(HBSS_LAWENTITY);
        DynamicObject lawEntityChgDyo = lawChgHelper.loadSingle((Object)lawEntityChangeParam.getLawEntityId());
        DynamicObject dbLawEntityDyo = lawHelper.loadSingle((Object)lawEntityChangeParam.getLawEntityId());
        LawEntityServiceHelper.genLawEntityChgDyoByDto(lawEntityChangeParam, lawEntityChgDyo, dbLawEntityDyo);
        String changeType = LawEntityServiceHelper.getChangeType(dbLawEntityDyo, lawEntityChgDyo, lawEntityChangeParam.isCancellation());
        LOGGER.info("lawEntity-service-changeLawEntity, changeType:{}", (Object)changeType);
        lawEntityChgDyo.set("type", (Object)changeType);
        LawEntityServiceHelper.modifyDyoStatus(lawHelper, lawEntityChangeParam.getLawEntityId(), "A", "1");
        LOGGER.info("lawEntity-service-changeLawEntity, editsave:{}", lawEntityChgDyo.getPkValue());
        OperationResult editOpRst = OperationServiceHelper.executeOperate((String)"editsave", (String)HBSS_LAWENTITYCHG, (DynamicObject[])new DynamicObject[]{lawEntityChgDyo}, (OperateOption)OperateOption.create());
        LawEntityServiceHelper.modifyDyoStatus(lawHelper, lawEntityChangeParam.getLawEntityId(), "C", "1");
        if (!editOpRst.isSuccess()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u6cd5\u5f8b\u5b9e\u4f53\u5931\u8d25\uff1a%1$s", (String)"LawEntityServiceHelper_18", (String)"hrmp-hbss-business", (Object[])new Object[0]), ((OperateErrorInfo)((ValidateResult)editOpRst.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage()));
        }
        if (lawEntityChangeParam.isSyncAddSignCompany()) {
            LawEntityServiceHelper.syncAddSignCompany(lawEntityChgDyo);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private static String getChangeType(DynamicObject dbLawEntityDyo, DynamicObject lawEntityChgDyo, boolean isCancellation) {
        String mulType = "";
        if (isCancellation) {
            mulType = ",3,";
        } else {
            ArrayList<String> typeList = new ArrayList<String>(10);
            if (!HRStringUtils.equals((String)dbLawEntityDyo.getString("name"), (String)lawEntityChgDyo.getString("name")) || !HRStringUtils.equals((String)dbLawEntityDyo.getString("firmname"), (String)lawEntityChgDyo.getString("firmname"))) {
                typeList.add("1");
            }
            if (!HRStringUtils.equals((String)dbLawEntityDyo.getString("entitytype"), (String)lawEntityChgDyo.getString("entitytype"))) {
                typeList.add("4");
            }
            if (!HRStringUtils.equals((String)dbLawEntityDyo.getString("propctl"), (String)lawEntityChgDyo.getString("propctl"))) {
                typeList.add("5");
            }
            if (!HRStringUtils.equals((String)dbLawEntityDyo.getString("address"), (String)lawEntityChgDyo.getString("address"))) {
                typeList.add("2");
            }
            if (typeList.size() > 0) {
                mulType = String.join((CharSequence)",", typeList);
            }
        }
        return mulType;
    }

    @ExcludeFromJacocoGeneratedReport
    private static void initEmpLawEntityInfo(DynamicObject lawEntityDyo) {
        long pk = ORM.create().genLongId(HBSS_LAWENTITY);
        lawEntityDyo.set("id", (Object)pk);
        HRBaseServiceHelper bosOrgService = new HRBaseServiceHelper("bos_org");
        long orgId = RequestContext.get().getOrgId() == 0L ? OrgServiceUtil.getHRRootOrgId() : RequestContext.get().getOrgId();
        DynamicObject curBosOrg = bosOrgService.queryOne((Object)orgId);
        lawEntityDyo.set("createorg", (Object)curBosOrg);
        lawEntityDyo.set("org", (Object)curBosOrg);
        lawEntityDyo.set("useorg", (Object)curBosOrg);
        lawEntityDyo.set("ctrlstrategy", (Object)"5");
    }

    @ExcludeFromJacocoGeneratedReport
    private static DynamicObject genLawEntityChgDyoByDto(LawEntityChangeDto param, DynamicObject lawChgDyo, DynamicObject lawOldDyo) {
        lawChgDyo.set("name", (Object)param.getName());
        lawChgDyo.set("desc", (Object)param.getChangeDesc());
        lawChgDyo.set("entitytype", (Object)param.getEntityType());
        lawChgDyo.set("propctl", (Object)param.getPropCtl());
        if (param.isCancellation()) {
            lawChgDyo.set("oprsts", (Object)"2");
        } else {
            lawChgDyo.set("oprsts", (Object)"1");
        }
        lawChgDyo.set("description", (Object)param.getDescription());
        lawChgDyo.set("createorg", lawOldDyo.get("createorg"));
        lawChgDyo.set("org", lawOldDyo.get("org"));
        lawChgDyo.set("useorg", lawOldDyo.get("useorg"));
        lawChgDyo.set("ctrlstrategy", lawOldDyo.get("ctrlstrategy"));
        if (StringUtils.equals((CharSequence)"3", (CharSequence)param.getEntityType())) {
            lawChgDyo.set("adminorg", null);
            lawChgDyo.set("uniformsocialcreditcode", null);
            lawChgDyo.set("firmname", null);
            lawChgDyo.set("representative", null);
            lawChgDyo.set("establishmentdate", null);
            lawChgDyo.set("startdate", null);
            lawChgDyo.set("enddate", null);
            lawChgDyo.set("phone", null);
            lawChgDyo.set("address", null);
        } else if (StringUtils.equals((CharSequence)"3", (CharSequence)lawOldDyo.getString("entitytype"))) {
            lawChgDyo.set("syncaddsigncomp", (Object)param.isSyncAddSignCompany());
            LawEntityServiceHelper.checkSignCompInfo((LawEntityDto)param);
            LawEntityServiceHelper.writeLawOrgInfo((LawEntityDto)param, lawChgDyo);
        }
        return lawChgDyo;
    }

    @ExcludeFromJacocoGeneratedReport
    private static void writeLawOrgInfo(LawEntityDto param, DynamicObject lawChgDyo) {
        HRBaseServiceHelper bosOrgService = new HRBaseServiceHelper("bos_org");
        Long adminOrgId = param.getAdminOrg();
        DynamicObject adminOrg = null;
        if (adminOrgId != null && adminOrgId != 0L) {
            adminOrg = bosOrgService.queryOne((Object)adminOrgId);
        }
        if (adminOrg != null) {
            lawChgDyo.set("adminorg", adminOrg);
            lawChgDyo.set("uniformsocialcreditcode", adminOrg.get("uniformsocialcreditcode"));
            lawChgDyo.set("firmname", adminOrg.get("ffirmname"));
            lawChgDyo.set("representative", adminOrg.get("frepresentative"));
            lawChgDyo.set("establishmentdate", adminOrg.get("establishmentdate"));
            lawChgDyo.set("startdate", adminOrg.get("establishmentdate"));
            lawChgDyo.set("enddate", adminOrg.get("businessterm"));
            lawChgDyo.set("phone", adminOrg.get("phone"));
            lawChgDyo.set("address", (Object)adminOrg.getString("faddress"));
        } else {
            lawChgDyo.set("representative", (Object)param.getLegalRepresentative());
            lawChgDyo.set("uniformsocialcreditcode", (Object)param.getUSCID());
            lawChgDyo.set("address", (Object)param.getAddress());
            lawChgDyo.set("phone", (Object)param.getPhone());
            lawChgDyo.set("firmname", (Object)param.getCompanyName());
            lawChgDyo.set("establishmentdate", (Object)param.getEstablishmentDate());
            lawChgDyo.set("startdate", (Object)param.getBusinessStartDate());
            lawChgDyo.set("enddate", (Object)param.getBusinessEndDate());
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private static DynamicObject genLawEntityDyoByDto(LawEntityDto addLawEntityParam, DynamicObject lawEntityDyo) {
        lawEntityDyo.set("number", (Object)addLawEntityParam.getNumber());
        lawEntityDyo.set("name", (Object)addLawEntityParam.getName());
        lawEntityDyo.set("entitytype", (Object)addLawEntityParam.getEntityType());
        lawEntityDyo.set("propctl", (Object)addLawEntityParam.getPropCtl());
        lawEntityDyo.set("oprsts", (Object)"1");
        lawEntityDyo.set("description", (Object)addLawEntityParam.getDescription());
        if (!StringUtils.equals((CharSequence)"3", (CharSequence)addLawEntityParam.getEntityType())) {
            lawEntityDyo.set("syncaddsigncomp", (Object)addLawEntityParam.isSyncAddSignCompany());
            LawEntityServiceHelper.writeLawOrgInfo(addLawEntityParam, lawEntityDyo);
        }
        return lawEntityDyo;
    }

    @ExcludeFromJacocoGeneratedReport
    private static void checkChangeParam(LawEntityChangeDto param) {
        Long lawEntityId = param.getLawEntityId();
        boolean errorLawEntity = true;
        if (lawEntityId != null && lawEntityId != 0L) {
            String oprsts;
            HRBaseServiceHelper lawEntityService = new HRBaseServiceHelper(HBSS_LAWENTITY);
            DynamicObject lawEntity = lawEntityService.queryOriginalOne("oprsts", new QFilter[]{new QFilter("id", "=", (Object)lawEntityId)});
            boolean bl = errorLawEntity = lawEntity == null;
            if (lawEntity != null && "2".equals(oprsts = lawEntity.getString("oprsts"))) {
                throw new KDBizException(BosErrorCode.paramError, new Object[]{ResManager.loadKDString((String)"\u7ecf\u8425\u72b6\u6001\u4e3a\u5df2\u6ce8\u9500\u65e0\u6cd5\u53d8\u66f4\u3002", (String)"LawEntityServiceHelper_23", (String)"hrmp-hbss-business", (Object[])new Object[0])});
            }
        }
        if (errorLawEntity) {
            throw new KDBizException(BosErrorCode.paramError, new Object[]{ResManager.loadKDString((String)"\u6cd5\u5f8b\u5b9e\u4f53\u4e3b\u952e\u9519\u8bef\u3002", (String)"LawEntityServiceHelper_15", (String)"hrmp-hbss-business", (Object[])new Object[0])});
        }
        String changeDesc = param.getChangeDesc();
        if (HRStringUtils.isEmpty((String)changeDesc)) {
            throw new KDBizException(BosErrorCode.paramError, new Object[]{ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u53d8\u66f4\u8bf4\u660e\u201d\u3002", (String)"LawEntityServiceHelper_16", (String)"hrmp-hbss-business", (Object[])new Object[0])});
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private static void checkCreateLawEntityParam(LawEntityDto param) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)HBSS_LAWENTITY);
        ComboProp entityTypeProp = (ComboProp)dataEntityType.getProperty("entitytype");
        String itemByName = entityTypeProp.getItemByName(param.getEntityType());
        if (HRStringUtils.isEmpty((String)itemByName)) {
            throw new KDBizException(BosErrorCode.paramError, new Object[]{ResManager.loadKDString((String)"\u5b9e\u4f53\u7c7b\u578b\u53c2\u6570\u9519\u8bef\u3002", (String)"LawEntityServiceHelper_8", (String)"hrmp-hbss-business", (Object[])new Object[0])});
        }
        String propCtls = param.getPropCtl();
        if (HRStringUtils.isNotEmpty((String)propCtls)) {
            String[] split;
            MulComboProp propCtrlProp = (MulComboProp)dataEntityType.getProperty("propctl");
            for (String proCtrl : split = propCtls.split(",")) {
                String propItem = propCtrlProp.getItemByName(proCtrl);
                if (!HRStringUtils.isEmpty((String)propItem)) continue;
                throw new KDBizException(BosErrorCode.paramError, new Object[]{ResManager.loadKDString((String)"\u5c5e\u6027\u63a7\u5236\u53c2\u6570\u9519\u8bef\u3002", (String)"LawEntityServiceHelper_9", (String)"hrmp-hbss-business", (Object[])new Object[0])});
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private static void checkSignCompInfo(LawEntityDto param) {
        boolean syncAddSignComp = param.isSyncAddSignCompany();
        String entityType = param.getEntityType();
        boolean assocorg = LawEntityServiceHelper.queryAssocOrg();
        boolean needCheck = false;
        if (StringUtils.equals((CharSequence)"3", (CharSequence)entityType)) {
            if (syncAddSignComp) {
                throw new KDBizException(BosErrorCode.paramError, new Object[]{ResManager.loadKDString((String)"\u5916\u90e8\u670d\u52a1\u673a\u6784\u4e0d\u80fd\u540c\u6b65\u65b0\u589e\u8058\u7528\u5355\u4f4d\u3002", (String)"LawEntityServiceHelper_22", (String)"hrmp-hbss-business", (Object[])new Object[0])});
            }
        } else {
            needCheck = true;
        }
        if (!needCheck) {
            return;
        }
        DynamicObject adminOrg = null;
        Long adminOrgPk = param.getAdminOrg();
        if (adminOrgPk != null && adminOrgPk != 0L) {
            HRBaseServiceHelper bosOrgService = new HRBaseServiceHelper("bos_org");
            adminOrg = bosOrgService.queryOriginalOne("uniformsocialcreditcode,ffirmname,frepresentative", (Object)adminOrgPk);
        }
        if (assocorg && adminOrg == null) {
            throw new KDBizException(BosErrorCode.paramError, new Object[]{ResManager.loadKDString((String)"\u5173\u8054\u6cd5\u4eba\u53c2\u6570\u9519\u8bef\u3002", (String)"LawEntityServiceHelper_10", (String)"hrmp-hbss-business", (Object[])new Object[0])});
        }
        if (!assocorg || syncAddSignComp) {
            if (adminOrg != null) {
                if (HRStringUtils.isEmpty((String)adminOrg.getString("uniformsocialcreditcode"))) {
                    throw new KDBizException(BosErrorCode.paramError, new Object[]{ResManager.loadKDString((String)"\u5173\u8054\u6cd5\u4eba\u201c\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u201d\u4e3a\u7a7a\u3002", (String)"LawEntityServiceHelper_19", (String)"hrmp-hbss-business", (Object[])new Object[0])});
                }
                if (HRStringUtils.isEmpty((String)adminOrg.getString("ffirmname"))) {
                    throw new KDBizException(BosErrorCode.paramError, new Object[]{ResManager.loadKDString((String)"\u5173\u8054\u6cd5\u4eba\u201c\u516c\u53f8\u540d\u79f0\u201d\u4e3a\u7a7a\u3002", (String)"LawEntityServiceHelper_20", (String)"hrmp-hbss-business", (Object[])new Object[0])});
                }
                if (HRStringUtils.isEmpty((String)adminOrg.getString("frepresentative"))) {
                    throw new KDBizException(BosErrorCode.paramError, new Object[]{ResManager.loadKDString((String)"\u5173\u8054\u6cd5\u4eba\u201c\u6cd5\u5b9a\u4ee3\u8868\u4eba\u201d\u4e3a\u7a7a", (String)"LawEntityServiceHelper_21", (String)"hrmp-hbss-business", (Object[])new Object[0])});
                }
            } else {
                if (HRStringUtils.isEmpty((String)param.getUSCID())) {
                    throw new KDBizException(BosErrorCode.paramError, new Object[]{ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u201d\u3002", (String)"LawEntityServiceHelper_11", (String)"hrmp-hbss-business", (Object[])new Object[0])});
                }
                if (HRStringUtils.isEmpty((String)param.getCompanyName())) {
                    throw new KDBizException(BosErrorCode.paramError, new Object[]{ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u516c\u53f8\u540d\u79f0\u201d\u3002", (String)"LawEntityServiceHelper_12", (String)"hrmp-hbss-business", (Object[])new Object[0])});
                }
                if (HRStringUtils.isEmpty((String)param.getLegalRepresentative())) {
                    throw new KDBizException(BosErrorCode.paramError, new Object[]{ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6cd5\u5b9a\u4ee3\u8868\u4eba\u201d\u3002", (String)"LawEntityServiceHelper_13", (String)"hrmp-hbss-business", (Object[])new Object[0])});
                }
            }
        }
    }

    public static void relLawEntity(String entityName, String opKey, DynamicObject[] dataEntities) {
        block3: {
            HRBaseServiceHelper lawUseHelper;
            HRBaseServiceHelper lawHelper;
            block4: {
                block2: {
                    LawEntityServiceHelper.chkCommonParam(entityName, dataEntities);
                    lawHelper = new HRBaseServiceHelper(HBSS_LAWENTITY);
                    lawUseHelper = new HRBaseServiceHelper(HBSS_LAWENTITYUSE);
                    if (!"delete".equals(opKey) && !"unaudit".equals(opKey)) break block2;
                    Long[] opItemsIds = LawEntityServiceHelper.buildOpItemsIds(dataEntities);
                    LawEntityServiceHelper.deleteRelLawEntity(lawHelper, lawUseHelper, entityName, opItemsIds);
                    break block3;
                }
                if (!"save".equals(opKey)) break block4;
                for (int i = 0; i < dataEntities.length; ++i) {
                    LawEntityServiceHelper.updateRelLawEntity(lawHelper, lawUseHelper, entityName, dataEntities[i]);
                }
                break block3;
            }
            if (!"audit".equals(opKey)) break block3;
            for (int i = 0; i < dataEntities.length; ++i) {
                LawEntityServiceHelper.addRelLawEntity(lawHelper, lawUseHelper, entityName, dataEntities[i]);
            }
        }
    }

    private static void addRelLawEntity(HRBaseServiceHelper lawHelper, HRBaseServiceHelper lawUseHelper, String entityName, DynamicObject dataEntity) {
        Long lawId;
        DynamicObject newLawEntity = (DynamicObject)dataEntity.get(LAWENTITY);
        if (!Objects.isNull(newLawEntity) && !Objects.isNull(lawId = (Long)newLawEntity.getPkValue()) && lawId != 0L) {
            boolean existsLawRecord = lawHelper.isExists(LawEntityServiceHelper.buildFilters(lawId, entityName, true));
            if (!existsLawRecord) {
                lawHelper.saveOne(LawEntityServiceHelper.buildLawByRelStatus(lawHelper, lawId, entityName, true));
            }
            lawUseHelper.saveOne(LawEntityServiceHelper.buildNewLawUse(lawUseHelper, entityName, (Long)dataEntity.getPkValue(), lawId));
        }
    }

    private static void updateRelLawEntity(HRBaseServiceHelper lawHelper, HRBaseServiceHelper lawUseHelper, String entityName, DynamicObject dataEntity) {
        Long oldLawId;
        Long newLawId = LawEntityServiceHelper.buildNewLawId(dataEntity);
        if (newLawId.equals(oldLawId = LawEntityServiceHelper.buildOldLawId(entityName, (Long)dataEntity.getPkValue()))) {
            return;
        }
        int relLawFlag = LawEntityServiceHelper.buildRelLawFlag(newLawId, oldLawId);
        LawEntityServiceHelper.chkUpdRelParam(relLawFlag, newLawId, oldLawId);
        Long opItemId = (Long)dataEntity.getPkValue();
        if (relLawFlag == 0) {
            lawHelper.saveOne(LawEntityServiceHelper.buildLawByRelStatus(lawHelper, newLawId, entityName, true));
            lawUseHelper.saveOne(LawEntityServiceHelper.buildNewLawUse(lawUseHelper, entityName, opItemId, newLawId));
        } else if (relLawFlag == 1) {
            lawUseHelper.deleteByFilter(new QFilter[]{new QFilter("number", "=", (Object)entityName), new QFilter(OPITEMID, "=", (Object)opItemId)});
            boolean exists = lawUseHelper.isExists(new QFilter[]{new QFilter("number", "=", (Object)entityName), new QFilter(RELLAWENTITYID, "=", (Object)oldLawId)});
            if (!exists) {
                lawHelper.saveOne(LawEntityServiceHelper.buildLawByRelStatus(lawHelper, oldLawId, entityName, false));
            }
        } else if (relLawFlag == 2) {
            boolean existsLawRecord;
            boolean existsLawUseRecord;
            DynamicObject lawEntityUse = lawUseHelper.queryOne(RELLAWENTITYID, new QFilter[]{new QFilter("number", "=", (Object)entityName), new QFilter(OPITEMID, "=", (Object)opItemId)});
            if (!Objects.isNull(lawEntityUse)) {
                lawEntityUse.set(RELLAWENTITYID, (Object)newLawId);
                lawUseHelper.saveOne(lawEntityUse);
            }
            if (!(existsLawUseRecord = lawUseHelper.isExists(new QFilter[]{new QFilter(RELLAWENTITYID, "=", (Object)oldLawId), new QFilter("number", "=", (Object)entityName)}))) {
                lawHelper.saveOne(LawEntityServiceHelper.buildLawByRelStatus(lawHelper, oldLawId, entityName, false));
            }
            if (!(existsLawRecord = lawHelper.isExists(LawEntityServiceHelper.buildFilters(newLawId, entityName, true)))) {
                lawHelper.saveOne(LawEntityServiceHelper.buildLawByRelStatus(lawHelper, newLawId, entityName, true));
            }
        }
    }

    private static void deleteRelLawEntity(HRBaseServiceHelper lawHelper, HRBaseServiceHelper lawUseHelper, String entityName, Long[] opItemsIds) {
        DynamicObject[] lawIds = lawUseHelper.query(RELLAWENTITYID, new QFilter[]{new QFilter("number", "=", (Object)entityName), new QFilter(OPITEMID, "in", (Object)opItemsIds)});
        lawUseHelper.deleteByFilter(new QFilter[]{new QFilter("number", "=", (Object)entityName), new QFilter(OPITEMID, "in", (Object)opItemsIds)});
        for (int i = 0; i < lawIds.length; ++i) {
            boolean existsLawRecord;
            Long lawId = (Long)lawIds[i].get(RELLAWENTITYID);
            boolean existsLawUseRecord = lawUseHelper.isExists(new QFilter[]{new QFilter("number", "=", (Object)entityName), new QFilter(RELLAWENTITYID, "=", (Object)lawId)});
            if (existsLawUseRecord || !(existsLawRecord = lawHelper.isExists(LawEntityServiceHelper.buildFilters(lawId, entityName, true)))) continue;
            DynamicObject lawEntity = LawEntityServiceHelper.buildLawByRelStatus(lawHelper, lawId, entityName, false);
            lawHelper.saveOne(lawEntity);
        }
    }

    private static Long[] buildOpItemsIds(DynamicObject[] dataEntities) {
        Long[] opItemIds = new Long[dataEntities.length];
        for (int i = 0; i < dataEntities.length; ++i) {
            opItemIds[i] = (Long)dataEntities[i].getPkValue();
        }
        return opItemIds;
    }

    private static Long buildNewLawId(DynamicObject dataEntity) {
        DynamicObject newLawEntity = (DynamicObject)dataEntity.get(LAWENTITY);
        if (!Objects.isNull(newLawEntity)) {
            return (Long)newLawEntity.getPkValue();
        }
        return 0L;
    }

    private static Long buildOldLawId(String currEntityName, Long currOpItemId) {
        DynamicObject oldLawEntity;
        DynamicObject currEntity;
        HRBaseServiceHelper currEntityHelper = new HRBaseServiceHelper(currEntityName);
        if (!(Objects.isNull(currOpItemId) || currOpItemId == 0L || Objects.isNull(currEntity = currEntityHelper.queryOne(LAWENTITY, (Object)currOpItemId)) || Objects.isNull(oldLawEntity = (DynamicObject)currEntity.get(LAWENTITY)))) {
            return (Long)oldLawEntity.getPkValue();
        }
        return 0L;
    }

    private static DynamicObject buildNewLawUse(HRBaseServiceHelper lawUseHelper, String entityName, Long opItemId, Long newLawId) {
        DynamicObject lawEntityUse = lawUseHelper.generateEmptyDynamicObject();
        lawEntityUse.set("id", (Object)ORM.create().genLongId(lawUseHelper.getEntityName()));
        lawEntityUse.set("number", (Object)entityName);
        lawEntityUse.set(OPITEMID, (Object)opItemId);
        lawEntityUse.set(RELLAWENTITYID, (Object)newLawId);
        return lawEntityUse;
    }

    private static int buildRelLawFlag(Long newLawId, Long oldLawId) {
        if (!Objects.isNull(newLawId) && newLawId != 0L) {
            if (Objects.isNull(oldLawId) || oldLawId == 0L) {
                return 0;
            }
            return 2;
        }
        if (!Objects.isNull(oldLawId) && oldLawId != 0L) {
            return 1;
        }
        return 0;
    }

    private static void chkCommonParam(String entityName, DynamicObject[] dataEntities) {
        if (HRStringUtils.isEmpty((String)entityName)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b9e\u4f53\u7f16\u7801\u3002", (String)"LawEntityServiceHelper_1", (String)"hrmp-hbss-business", (Object[])new Object[0]));
        }
        if (Objects.isNull(dataEntities) || dataEntities.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5c\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a", (String)"LawEntityServiceHelper_2", (String)"hrmp-hbss-business", (Object[])new Object[0]));
        }
    }

    private static void chkUpdRelParam(int relLawFlag, Long newLawId, Long oldLawId) {
        if (relLawFlag == 0) {
            if (Objects.isNull(newLawId) || newLawId == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6dfb\u52a0\u5173\u8054\u6cd5\u5f8b\u5b9e\u4f53\u65f6\uff0c\u65b0\u5173\u8054\u6cd5\u5f8b\u5b9e\u4f53ID\u4e0d\u80fd\u4e3a\u7a7a\u62160L", (String)"LawEntityServiceHelper_3", (String)"hrmp-hbss-business", (Object[])new Object[0]));
            }
        } else if (relLawFlag == 1) {
            if (Objects.isNull(oldLawId) || oldLawId == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u6d88\u5173\u8054\u6cd5\u5f8b\u5b9e\u4f53\u65f6\uff0c\u539f\u5173\u8054\u6cd5\u5f8b\u5b9e\u4f53ID\u4e0d\u80fd\u4e3a\u7a7a\u62160L", (String)"LawEntityServiceHelper_4", (String)"hrmp-hbss-business", (Object[])new Object[0]));
            }
        } else if (relLawFlag == 2 && (Objects.isNull(newLawId) || newLawId == 0L || Objects.isNull(oldLawId) || oldLawId == 0L)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4fee\u6539\u5173\u8054\u6cd5\u5f8b\u5b9e\u4f53\u65f6\uff0c\u65b0\u5173\u8054\u6cd5\u5f8b\u5b9e\u4f53ID\u548c\u539f\u5173\u8054\u6cd5\u5f8b\u5b9e\u4f53ID\u90fd\u4e0d\u80fd\u4e3a\u7a7a\u62160L", (String)"LawEntityServiceHelper_5", (String)"hrmp-hbss-business", (Object[])new Object[0]));
        }
    }

    private static DynamicObject buildLawByRelStatus(HRBaseServiceHelper helper, Long pkId, String entityName, boolean relStatus) {
        DynamicObject law = helper.queryOne((Object)pkId);
        if (entityName.equals(HBSS_ENTERPRISE)) {
            law.set(ENTERPRISE, (Object)relStatus);
        } else if (entityName.equals(HBSS_SIGNCOMPANY)) {
            law.set(SIGNCOMPANY, (Object)relStatus);
        } else if (entityName.equals(HBSS_TAXUNIT)) {
            law.set(TAXUNIT, (Object)relStatus);
        } else if (entityName.equals(SITBS_WELFAREPAYER)) {
            law.set(WELFAREPAYER, (Object)relStatus);
        } else if (entityName.equals(HSBS_PAYSUBJECT)) {
            law.set(PAYSUBJECT, (Object)relStatus);
        }
        return law;
    }

    private static QFilter[] buildFilters(Long pkId, String entityName, boolean relStatus) {
        if (entityName.equals(HBSS_ENTERPRISE)) {
            return new QFilter[]{new QFilter("id", "=", (Object)pkId), new QFilter(ENTERPRISE, "=", (Object)relStatus)};
        }
        if (entityName.equals(HBSS_SIGNCOMPANY)) {
            return new QFilter[]{new QFilter("id", "=", (Object)pkId), new QFilter(SIGNCOMPANY, "=", (Object)relStatus)};
        }
        if (entityName.equals(HBSS_TAXUNIT)) {
            return new QFilter[]{new QFilter("id", "=", (Object)pkId), new QFilter(TAXUNIT, "=", (Object)relStatus)};
        }
        if (entityName.equals(SITBS_WELFAREPAYER)) {
            return new QFilter[]{new QFilter("id", "=", (Object)pkId), new QFilter(WELFAREPAYER, "=", (Object)relStatus)};
        }
        if (entityName.equals(HSBS_PAYSUBJECT)) {
            return new QFilter[]{new QFilter("id", "=", (Object)pkId), new QFilter(PAYSUBJECT, "=", (Object)relStatus)};
        }
        return new QFilter[0];
    }
}

